package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeQryBo;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeChangeListReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeChangeListRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @Description: SscQrySchemeChangeListServiceImpl
 * @Author: the_xhl
 * @Date: 2023-03-13
 */
@HTServiceImpl
public class SscQrySchemeChangeListServiceImpl implements SscQrySchemeChangeListService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Override
    public SscQrySchemeChangeListRspBO qrySchemeChangeList(SscQrySchemeChangeListReqBO sscQrySchemeChangeListReqBO) {
        check(sscQrySchemeChangeListReqBO);
        SscQrySchemeChangeListRspBO rspBO = SscRu.success(SscQrySchemeChangeListRspBO.class);
        SscSchemeDo sscSchemeDo = iSscSchemeModel.qrySchemeChangeList(SscRu.js(sscQrySchemeChangeListReqBO, SscSchemeQryBo.class));
        List<SscSchemeChangeBO> changeBOList = sscSchemeDo.getSscSchemeChange();
        if (CollectionUtil.isNotEmpty(changeBOList)) {
            // 状态翻译
            changeBOList.forEach(e -> {
                if (SscCommConstant.OperTypeEnum.PUT_UP.getCode().equals(e.getOperType())) {
                    // 挂起
                    e.setOldSchemeStatusStr(SscCommConstant.SchemeStatus.getInstance(e.getOldSchemeStatus()).getDesc());
                    e.setNewSchemeStatusStr(SscCommConstant.SchemeStatus.getInstance(e.getNewSchemeStatus()).getDesc());
                } else if (SscCommConstant.OperTypeEnum.END.getCode().equals(e.getOperType())) {
                    // 终止
                    e.setOldSchemeStatusStr(SscCommConstant.SchemeStatus.getInstance(e.getOldSchemeStatus()).getDesc());
                    e.setNewSchemeStatusStr(SscCommConstant.SchemeStatus.getInstance(e.getNewSchemeStatus()).getDesc());
                } else if (SscCommConstant.OperTypeEnum.AUDIT_PURCHASE_TYPE.getCode().equals(e.getOperType())) {
                    // 审批采购方式，oldSchemeStatus = schemeStatus
                    e.setOldSchemeStatusStr(SscCommConstant.SchemePurchaseType.getInstance(Integer.valueOf(e.getOldSchemeStatus())).getDesc());
                    e.setNewSchemeStatusStr(SscCommConstant.SchemePurchaseType.getInstance(Integer.valueOf(e.getNewSchemeStatus())).getDesc());
                }

            });
        }
        rspBO.setSscSchemeChange(changeBOList);
        return rspBO;
    }

    private void check(SscQrySchemeChangeListReqBO reqBO) {
        if (reqBO.getSchemeId() == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[schemeId]不能为空");
        }
    }
}
