package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscAccessory;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeEndReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeEndRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;

/**
 * @Description: SscSchemeEndServiceImpl todo
 * @Author: the_xhl
 * @Date: 2023-03-14
 */
@HTServiceImpl
public class SscSchemeEndServiceImpl implements SscSchemeEndService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Override
    public SscSchemeEndRspBO dealSchemeEnd(SscSchemeEndReqBO sscSchemeEndReqBO) {
        check(sscSchemeEndReqBO);
        SscSchemeEndRspBO rspBO = SscRu.success(SscSchemeEndRspBO.class);
        SscSchemeChangeBO changeBO = SscRu.js(sscSchemeEndReqBO, SscSchemeChangeBO.class);
        changeBO.setOperType(SscCommConstant.OperTypeEnum.END.getCode());
        changeBO.setSscAccessory(SscRu.jsl(sscSchemeEndReqBO.getSscAccessory(), SscAccessory.class));
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setCreateLoginId(sscSchemeEndReqBO.getUserId());
        sscSchemeDo.setCreateName(sscSchemeEndReqBO.getName());
        sscSchemeDo.setCreateUsername(sscSchemeEndReqBO.getUsername());
        sscSchemeDo.setSchemeId(sscSchemeEndReqBO.getSchemeId());
        sscSchemeDo.setSchemeStatus(SscCommConstant.SchemeStatus.END.getCode());
        sscSchemeDo.setSscSchemeChange(Collections.singletonList(changeBO));
        iSscSchemeModel.dealSchemeEnd(sscSchemeDo);
        return rspBO;
    }

    private void check(SscSchemeEndReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getSchemeId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[schemeId]不能为空");
        }
    }

}
