package com.tydic.dyc.ssc.service.auditorder;

import com.alibaba.fastjson.JSON;

import com.tydic.dyc.ssc.model.auditorder.SscAuditOrderDo;
import com.tydic.dyc.ssc.model.auditorder.ISscAuditOrderModel;
import com.tydic.dyc.ssc.model.auditorder.qrybo.SscAuditOrderQryBo;
import com.tydic.dyc.ssc.service.auditorder.bo.SscGetAuditObjReqBO;
import com.tydic.dyc.ssc.service.auditorder.bo.SscGetAuditObjRspBO;
import com.tydic.dyc.ssc.service.auditorder.bo.SscUocApprovalObjBo;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:SscGetAuditObjServiceImpl
 * 说明:TODO
 * 时间:2022/9/23 16:45
 * 作者:代愿愿
 */
@HTServiceImpl
public class SscGetAuditObjServiceImpl implements SscGetAuditObjService {
    @Autowired
    private ISscAuditOrderModel iSscAuditOrderModel;
    @Override
    public SscGetAuditObjRspBO getAuditObj(SscGetAuditObjReqBO reqBO) {
        SscAuditOrderQryBo sscAuditOrderQryBo = JSON.parseObject(JSON.toJSONString(reqBO), SscAuditOrderQryBo.class);
        SscAuditOrderDo sscAuditOrderDo = this.iSscAuditOrderModel.getAuditObj(sscAuditOrderQryBo);
        SscGetAuditObjRspBO rspBO = SscRu.success(SscGetAuditObjRspBO.class);
        rspBO.setUocApprovalObj(JSON.parseArray(JSON.toJSONString(sscAuditOrderDo.getUocApprovalObj()), SscUocApprovalObjBo.class));
        return rspBO;
    }
}
