/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscAccessory;
import com.tydic.dyc.ssc.service.scheme.SscAddSchemeChangeInfoService;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeChangeInfoReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeChangeInfoRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscAddSchemeChangeInfoService"})
public class SscAddSchemeChangeInfoServiceImpl
implements SscAddSchemeChangeInfoService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @PostMapping(value={"addSchemeChangeInfo"})
    public SscAddSchemeChangeInfoRspBO addSchemeChangeInfo(@RequestBody SscAddSchemeChangeInfoReqBO sscAddSchemeChangeInfoReqBO) {
        this.check(sscAddSchemeChangeInfoReqBO);
        SscAddSchemeChangeInfoRspBO rspBO = SscRu.success(SscAddSchemeChangeInfoRspBO.class);
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        SscSchemeChangeBO sscSchemeChangeBO = new SscSchemeChangeBO();
        sscSchemeChangeBO.setSchemeId(sscAddSchemeChangeInfoReqBO.getSchemeId());
        sscSchemeChangeBO.setOperType(sscAddSchemeChangeInfoReqBO.getOperType());
        sscSchemeChangeBO.setNewSchemeStatus(sscAddSchemeChangeInfoReqBO.getChangeStatus());
        sscSchemeChangeBO.setReason(sscAddSchemeChangeInfoReqBO.getReason());
        sscSchemeDo.setCreateUsername(sscAddSchemeChangeInfoReqBO.getUsername());
        sscSchemeDo.setCreateLoginId(sscAddSchemeChangeInfoReqBO.getUserId());
        sscSchemeDo.setCreateName(sscAddSchemeChangeInfoReqBO.getName());
        sscSchemeChangeBO.setSscAccessory(SscRu.jsl(sscAddSchemeChangeInfoReqBO.getSscAccessoryBO(), SscAccessory.class));
        sscSchemeDo.setSchemeId(sscAddSchemeChangeInfoReqBO.getSchemeId());
        sscSchemeDo.setSscSchemeChange(Collections.singletonList(sscSchemeChangeBO));
        this.iSscSchemeModel.addSchemeChangeInfo(sscSchemeDo);
        return rspBO;
    }

    private void check(SscAddSchemeChangeInfoReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getSchemeId())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[schemeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBO.getUserId())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)reqBO.getName())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[schemeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)reqBO.getOperType())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[operType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)reqBO.getChangeStatus())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[changeStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)reqBO.getUsername())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[username]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

