/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeMat;
import com.tydic.dyc.ssc.service.scheme.SscDeleteSchemeMatBatchService;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeMatBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeMatBatchRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscDeleteSchemeMatBatchService"})
public class SscDeleteSchemeMatBatchServiceImpl
implements SscDeleteSchemeMatBatchService {
    private static final Logger log = LoggerFactory.getLogger(SscDeleteSchemeMatBatchServiceImpl.class);
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscCommonModel iSscCommonModel;

    @PostMapping(value={"deleteSchemeMatBatch"})
    public SscDeleteSchemeMatBatchRspBO deleteSchemeMatBatch(@RequestBody SscDeleteSchemeMatBatchReqBO reqBO) {
        this.validationParam(reqBO);
        SscDeleteSchemeMatBatchRspBO rspBO = SscRu.success(SscDeleteSchemeMatBatchRspBO.class);
        SscSchemeDo reqBO1 = SscRu.js(reqBO, SscSchemeDo.class);
        reqBO1.setSscSchemeMat(SscRu.jsl(reqBO.getSscSchemeMat(), SscSchemeMat.class));
        this.iSscSchemeModel.deleteSchemeMatBatch(reqBO1);
        this.deleteExtInfo(reqBO);
        return rspBO;
    }

    private void validationParam(SscDeleteSchemeMatBatchReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getEnableDraft())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[enableDraft]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isNull((Object)reqBO.getSchemeId())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[schemeId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void deleteExtInfo(SscDeleteSchemeMatBatchReqBO reqBO) {
        List sscSchemeMat = reqBO.getSscSchemeMat();
        Boolean enableDraft = reqBO.getEnableDraft();
        if (CollectionUtil.isNotEmpty((Collection)sscSchemeMat)) {
            SscCommonDo sscCommonDo = new SscCommonDo();
            List<SscExtObjInfo> matObjInfoList = sscSchemeMat.stream().map(x -> {
                SscExtObjInfo objInfo = new SscExtObjInfo();
                objInfo.setObjId(x.getSchemeMatId());
                objInfo.setObjType(enableDraft != false ? "ssc_scheme_mat_ext_draft" : "ssc_scheme_mat_ext");
                objInfo.setExtInfo(SscRu.jsl(x.getExtFields(), SscExtInfo.class));
                return objInfo;
            }).collect(Collectors.toList());
            sscCommonDo.setExtObjInfos(matObjInfoList);
            this.iSscCommonModel.deleteExtInfo(sscCommonDo);
        }
    }
}

