/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeMat;
import com.tydic.dyc.ssc.service.scheme.SscSetSchemeMatNullValueBatchService;
import com.tydic.dyc.ssc.service.scheme.bo.SscSetSchemeMatNullValueBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSetSchemeMatNullValueBatchRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscSetSchemeMatNullValueBatchService"})
public class SscSetSchemeMatNullValueBatchServiceImpl
implements SscSetSchemeMatNullValueBatchService {
    private static final Logger log = LoggerFactory.getLogger(SscSetSchemeMatNullValueBatchServiceImpl.class);
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @PostMapping(value={"setSchemeMatNullValueBatch"})
    public SscSetSchemeMatNullValueBatchRspBO setSchemeMatNullValueBatch(@RequestBody SscSetSchemeMatNullValueBatchReqBO reqBO) {
        SscSetSchemeMatNullValueBatchRspBO rspBO = SscRu.success(SscSetSchemeMatNullValueBatchRspBO.class);
        log.info("----------------------\u7edf\u4e00\u7ef4\u62a4\u5f00\u59cb---------------------------");
        this.validationParam(reqBO);
        SscSchemeDo sscSchemeDo = SscRu.js(reqBO, SscSchemeDo.class);
        this.executeMethod(sscSchemeDo, reqBO.getUpdateType());
        SscSchemeDo schemeDo = this.iSscSchemeModel.setEsMount(reqBO);
        rspBO.setEstAmount(schemeDo.getEstAmount());
        return rspBO;
    }

    private void executeMethod(SscSchemeDo sscSchemeDo, String updateType) {
        Integer type = Integer.valueOf(updateType);
        List<SscSchemeMat> sscSchemeMat = sscSchemeDo.getSscSchemeMat();
        if (sscSchemeMat.size() != 1) {
            throw new BaseBusinessException("292001", "sscSchemeMat(\u65b9\u6848\u7269\u6599\u4fe1\u606f)\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u6761\u6570\u636e,\u5f53\u524d\u5b58\u5728" + sscSchemeMat.size());
        }
        if (type.equals(SscCommConstant.SCHEME_MAT_UPDATE_TYPE.APPLY_ALL_MAT)) {
            this.iSscSchemeModel.updateSchemeMatBatchUnNullValue(sscSchemeDo);
        }
        if (type.equals(SscCommConstant.SCHEME_MAT_UPDATE_TYPE.APPLY_CHECKED)) {
            if (CollectionUtils.isEmpty(sscSchemeMat.get(0).getSchemeMatIds())) {
                throw new BaseBusinessException("292001", "\u5165\u53c2schemeMatIds\u65b9\u6848\u7269\u6599ID\u96c6\u5408\u4e3a\u7a7a");
            }
            this.iSscSchemeModel.updateSchemeMatBatchUnNullValue(sscSchemeDo);
        }
        if (type.equals(SscCommConstant.SCHEME_MAT_UPDATE_TYPE.APPLY_NO_WRITE)) {
            this.iSscSchemeModel.setSchemeMatNullValue(sscSchemeDo);
        }
    }

    private void validationParam(SscSetSchemeMatNullValueBatchReqBO reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("292001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getSchemeId()) {
            throw new BaseBusinessException("292001", "\u5165\u53c2\u5bf9\u8c61[schemeId \u65b9\u6848id]\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSscSchemeMat())) {
            throw new BaseBusinessException("292001", "\u5165\u53c2\u5bf9\u8c61[sscSchemeMat \u65b9\u6848\u7269\u6599\u4fe1\u606f]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getEnableDraft())) {
            throw new BaseBusinessException("292001", "\u5165\u53c2\u5bf9\u8c61[enableDraft \u662f\u5426\u8349\u7a3f]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUpdateType())) {
            throw new BaseBusinessException("292001", "\u5165\u53c2\u5bf9\u8c61[updateType \u66f4\u65b0\u7c7b\u578b]\u4e3a\u7a7a");
        }
    }
}

