package com.tydic.dyc.ssc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoQryReqBO;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoQryRspBO;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoUpateReqBO;
import com.tydic.dyc.ssc.service.common.bo.SscExtObjInfoBo;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/**
 * @Description: SscExtInfoQryServiceImpl
 * @Author: the_xhl
 * @Date: 2023-03-21
 */
@HTServiceImpl
public class SscExtInfoQryServiceImpl implements SscExtInfoQryService {

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscExtInfoQryRspBO qryExtInfo(SscExtInfoQryReqBO sscExtInfoQryReqBO) {
        check(sscExtInfoQryReqBO);
        SscExtInfoQryRspBO rspBO = SscRu.success(SscExtInfoQryRspBO.class);
        SscCommonDo sscCommonDo = iSscCommonModel.qryExtInfo(SscRu.js(sscExtInfoQryReqBO, SscCommonDo.class));
        rspBO.setExtObjInfos(SscRu.jsl(sscCommonDo.getExtObjInfos(), SscExtObjInfoBo.class));
        return rspBO;
    }

    private void check(SscExtInfoQryReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象不能为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getExtObjInfos())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参extObjInfos不能为空");
        }
        reqBO.getExtObjInfos().forEach(sscExtObjInfoBo -> {
            if (sscExtObjInfoBo.getObjId() == null) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参objId不能为空");
            }
            if (StringUtils.isEmpty(sscExtObjInfoBo.getObjType())) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参ObjType不能为空");
            }
            if (sscExtObjInfoBo.getOrderId() == null) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参OrderId不能为空");
            }
        });


    }
}
