package com.tydic.dyc.ssc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoUpateReqBO;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoUpateRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/**
 * 标题:SscExtInfoUpateServiceImpl
 * 说明:TODO
 * 时间:2023/3/13 15:15
 * 作者:代愿愿
 */
@HTServiceImpl
public class SscExtInfoUpateServiceImpl implements SscExtInfoUpateService {
    @Autowired
    private ISscCommonModel iSscCommonModel;
    @Override
    public SscExtInfoUpateRspBO updateExtInfo(SscExtInfoUpateReqBO sscExtInfoUpateReqBO) {
        this.validParam(sscExtInfoUpateReqBO);
        SscCommonDo sscCommonDo = new SscCommonDo() ;
        sscCommonDo.setExtObjInfos(SscRu.jsl(sscExtInfoUpateReqBO.getExtObjInfos(), SscExtObjInfo.class));
        iSscCommonModel.updateExtInfo(sscCommonDo);
        SscExtInfoUpateRspBO rspBO = new SscExtInfoUpateRspBO();
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
    /**
     * 入参校验
     */
    private void validParam(SscExtInfoUpateReqBO sscExtInfoUpateReqBO){
        if(ObjectUtil.isEmpty(sscExtInfoUpateReqBO)){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象不能为空");
        }
        if(CollectionUtils.isEmpty(sscExtInfoUpateReqBO.getExtObjInfos())){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参extObjInfos不能为空");
        }
        sscExtInfoUpateReqBO.getExtObjInfos().forEach(sscExtObjInfoBo -> {
            if(sscExtObjInfoBo.getObjId()==null){
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参objId不能为空");
            }
            if(StringUtils.isEmpty(sscExtObjInfoBo.getObjType())){
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参ObjType不能为空");
            }
            if(sscExtObjInfoBo.getOrderId()==null){
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参OrderId不能为空");
            }
            if(CollectionUtils.isEmpty(sscExtObjInfoBo.getExtInfo())){
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参ExtInfo不能为空");
            }
            sscExtObjInfoBo.getExtInfo().forEach(sscExtInfoBo -> {
                if(StringUtils.isEmpty(sscExtInfoBo.getFieldCode())){
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参FieldCode不能为空");
                }
            });
        });


    }
}
