package com.tydic.dyc.ssc.service.domainserviece;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.project.ISscProjectModel;
import com.tydic.dyc.ssc.model.project.SscBidProjectDo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.domainservice.SscCopyBidProjectFromSchemeService;
import com.tydic.dyc.ssc.service.domainservice.bo.SscCopyBidProjectFromSchemeReqBO;
import com.tydic.dyc.ssc.service.domainservice.bo.SscCopyBidProjectFromSchemeRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * @Description: SscCopyBidProjectFromSchemeServiceImpl
 * @Author: the_xhl
 * @Date: 2022-12-28
 */
@HTServiceImpl
public class SscCopyBidProjectFromSchemeServiceImpl implements SscCopyBidProjectFromSchemeService {

    @Autowired
    private ISscProjectModel iSscProjectModel;

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Override
    public SscCopyBidProjectFromSchemeRspBO copyBidProjectFromScheme(SscCopyBidProjectFromSchemeReqBO sscCopyBidProjectFromSchemeReqBO) {
        // 参数校验
        check(sscCopyBidProjectFromSchemeReqBO);
        SscBidProjectDo sscBidProjectDo = JSON.parseObject(JSON.toJSONString(sscCopyBidProjectFromSchemeReqBO), SscBidProjectDo.class);
        iSscProjectModel.copyBidProjectFromScheme(sscBidProjectDo);

        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setSchemeId(sscCopyBidProjectFromSchemeReqBO.getSchemeId());
        sscSchemeDo.setSourcingStartTime(new Date());
        sscSchemeDo.setSourcingStatus(String.valueOf(SscCommConstant.SchemeSourcingStatus.IN_PROGRESS.getCode()));
        iSscSchemeModel.updateSchemeMain(sscSchemeDo);
        SscCopyBidProjectFromSchemeRspBO rspBO = new SscCopyBidProjectFromSchemeRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    private void check(SscCopyBidProjectFromSchemeReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getSchemeId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[schemeId]不能为空");
        }
        if (StrUtil.isEmpty(reqBO.getOrgPath())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[orgPath]不能为空");
        }
        if (ObjectUtil.isNull(reqBO.getUserId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[userId]不能为空");
        }
        if (StrUtil.isEmpty(reqBO.getUsername())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[username]不能为空");
        }
        if (ObjectUtil.isNull(reqBO.getOrgId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[orgId]不能为空");
        }
        if (StrUtil.isEmpty(reqBO.getOrgName())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[orgName]不能为空");
        }
        if (StrUtil.isEmpty(reqBO.getName())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[name]不能为空");
        }
    }
}
