package com.tydic.dyc.ssc.service.project;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.project.ISscProjectModel;
import com.tydic.dyc.ssc.model.project.SscBidProjectDo;
import com.tydic.dyc.ssc.model.project.qrybo.SscBidProjectQryBo;
import com.tydic.dyc.ssc.model.project.sub.SscQuotationItemTemplate;
import com.tydic.dyc.ssc.service.project.bo.SscQryQuotationItemTemplateListReqBO;
import com.tydic.dyc.ssc.service.project.bo.SscQryQuotationItemTemplateListRspBO;
import com.tydic.dyc.ssc.service.project.bo.SscQuotationItemTemplateBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: SscQryQuotationItemTemplatePageLIstServiceImpl
 * @Author: the_xhl
 * @Date: 2022-12-28
 */
@HTServiceImpl
public class SscQryQuotationItemTemplateListServiceImpl implements SscQryQuotationItemTemplateListService {

    @Autowired
    private ISscProjectModel iSscProjectModel;

    @Override
    public SscQryQuotationItemTemplateListRspBO qryQuotationItemTemplateList(SscQryQuotationItemTemplateListReqBO sscQryQuotationItemTemplateListReqBO) {
        SscQryQuotationItemTemplateListRspBO rspBO = SscRu.success(SscQryQuotationItemTemplateListRspBO.class);
        // 参数校验
        check(sscQryQuotationItemTemplateListReqBO);
        SscBidProjectDo sscBidProjectDo = iSscProjectModel.qryQuotationItemTemplateLIst(JUtil.js(sscQryQuotationItemTemplateListReqBO, SscBidProjectQryBo.class));
        List<SscQuotationItemTemplate> templateList = sscBidProjectDo.getSscQuotationItemTemplate();
        if (CollectionUtil.isEmpty(templateList)) {
            return rspBO;
        }
        List<SscQuotationItemTemplateBO> sscQuotationItemTemplateBOList = templateList.stream().map(e -> JUtil.js(e, SscQuotationItemTemplateBO.class)).collect(Collectors.toList());
        rspBO.setRows(sscQuotationItemTemplateBOList);
        return rspBO;
    }

    private void check(SscQryQuotationItemTemplateListReqBO reqBo) {
        if (ObjectUtil.isNull(reqBo.getProjectId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[projectId]不能为空");
        }
    }
}
