package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @desc： 方案邀请供应商批量删除服务
 * @author： wukb
 * @date： 2022/11/14
 **/

@HTServiceImpl
public class SscDeleteSchemeInviteSupBatchServiceImpl implements SscDeleteSchemeInviteSupBatchService{

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscDeleteSchemeInviteSupBatchRspBO deleteSchemeInviteSupBatch(SscDeleteSchemeInviteSupBatchReqBO reqBO) {
        SscDeleteSchemeInviteSupBatchRspBO rspBO = SscRu.success(SscDeleteSchemeInviteSupBatchRspBO.class);
        // 参数校验
        validationParam(reqBO);
        SscSchemeDo sscSchemeDo = SscRu.js(reqBO, SscSchemeDo.class);
        iSscSchemeModel.deleteSchemeInviteSupBatch(sscSchemeDo);
        // 删除扩展信息
        this.deleteExtInfo(reqBO);
        return rspBO;
    }

    private void validationParam(SscDeleteSchemeInviteSupBatchReqBO reqBO) {
        if (reqBO == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[SscDeleteSchemeInviteSupBatchReqBO]不能为空");
        }
        if (reqBO.getEnableDraft() == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[enableDraft]不能为空");
        }
    }

    private void deleteExtInfo(SscDeleteSchemeInviteSupBatchReqBO reqBO) {
        List<SscSchemeInviteSupDeleteBO> sscSchemeInviteSup = reqBO.getSscSchemeInviteSup();
        Boolean enableDraft = reqBO.getEnableDraft();
        if (CollectionUtil.isNotEmpty(sscSchemeInviteSup)) {
            SscCommonDo sscCommonDo = new SscCommonDo();
            List<SscExtObjInfo> matObjInfoList = sscSchemeInviteSup.stream()
                    .map(x -> {
                        SscExtObjInfo objInfo = new SscExtObjInfo();
                        objInfo.setObjId(x.getSchemeInviteSupId());
                        objInfo.setObjType(enableDraft ? SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT : SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT);
                        return objInfo;
                    }).collect(Collectors.toList());
            sscCommonDo.setExtObjInfos(matObjInfoList);
            iSscCommonModel.deleteExtInfo(sscCommonDo);
        }
    }
}
