package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.procinst.ISscProcInstModel;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeAcceptRecord;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeEntrustRecord;
import com.tydic.dyc.ssc.service.scheme.bo.SscImplementSchemeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscImplementSchemeRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePlantListReqBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 类名：SscImplementSchemeServiceImpl
 * 说明：描述一下类的作用
 * 时间：2022/11/11
 * 作者：pengyuqi
 */
@HTServiceImpl
public class SscImplementSchemeServiceImpl implements SscImplementSchemeService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscProcInstModel iSscProcInstModel;

    @Override
    public SscImplementSchemeRspBO acceptImplementScheme(SscImplementSchemeReqBO sscImplementSchemeReqBO) {
        validDate(sscImplementSchemeReqBO);
        //调用任务主体修改方法（改为已办）
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.FINISHED);
        uocOrderTaskInst.setFinishTime(new Date());
        uocOrderTaskInst.setDealOperId(sscImplementSchemeReqBO.getUserId());
        uocOrderTaskInst.setDealOperName(sscImplementSchemeReqBO.getUsername());
        uocOrderTaskInst.setOrderId(sscImplementSchemeReqBO.getSchemeId());
        uocOrderTaskInst.setTaskInstId(sscImplementSchemeReqBO.getTaskId());
        uocOrderTaskInst.setObjId(sscImplementSchemeReqBO.getSchemeId());
        uocOrderTaskInst.setObjType(1);
        SscProcInstDo sscProcInstDo = new SscProcInstDo();
        List<UocOrderTaskInst> taskList = new ArrayList<>();
        taskList.add(uocOrderTaskInst);
        sscProcInstDo.setSscUocOrderTaskInst(taskList);
        iSscProcInstModel.updateTask(sscProcInstDo);
        //调用受理记录新增方法
        List<SscSchemeAcceptRecord> sscSchemeAcceptRecords = new ArrayList<>();
        SscSchemeAcceptRecord sscSchemeAcceptRecord = new SscSchemeAcceptRecord();
        sscSchemeAcceptRecord.setSchemeId(sscImplementSchemeReqBO.getSchemeId());
        sscSchemeAcceptRecord.setAcceptUserId(sscImplementSchemeReqBO.getUserId());
        sscSchemeAcceptRecord.setAcceptUserName(sscImplementSchemeReqBO.getUsername());
        sscSchemeAcceptRecord.setRemark(sscImplementSchemeReqBO.getRemark());
        sscSchemeAcceptRecord.setCreateTime(new Date());
        if (sscImplementSchemeReqBO.getOperStatus()) {
            SscSchemeDo updateSscSchemeDo = new SscSchemeDo();
            updateSscSchemeDo.setSchemeId(sscImplementSchemeReqBO.getSchemeId());
            updateSscSchemeDo.setSchemeStatus(SscCommConstant.SchemeStatus.ACCEPTED.getCode());
            sscSchemeAcceptRecord.setStatus(SscCommConstant.AcceptStatusEnum.ACCEPT.getCode());
            iSscSchemeModel.updateSchemeMain(updateSscSchemeDo);
        } else {
            SscSchemeDo updateSscSchemeDo = new SscSchemeDo();
            updateSscSchemeDo.setSchemeId(sscImplementSchemeReqBO.getSchemeId());
            updateSscSchemeDo.setImplId(-1L);
            sscSchemeAcceptRecord.setStatus(SscCommConstant.AcceptStatusEnum.NO_ACCEPT.getCode());
            iSscSchemeModel.updateImpl(updateSscSchemeDo);
        }
        sscSchemeAcceptRecords.add(sscSchemeAcceptRecord);
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setSscSchemeAcceptRecord(sscSchemeAcceptRecords);
        iSscSchemeModel.addSchemeAcceptRecord(sscSchemeDo);
        //	调用委托记录新增方法
        List<SscSchemeEntrustRecord> sscSchemeEntrustRecords = new ArrayList<>();
        SscSchemeEntrustRecord sscSchemeEntrustRecord = new SscSchemeEntrustRecord();
        sscSchemeEntrustRecord.setSchemeId(sscImplementSchemeReqBO.getSchemeId());
        sscSchemeEntrustRecord.setAgencyCode(sscImplementSchemeReqBO.getAgencyCode());
        sscSchemeEntrustRecord.setAgencyName(sscImplementSchemeReqBO.getAgencyName());
        sscSchemeEntrustRecord.setRemark(sscImplementSchemeReqBO.getRemark());
        sscSchemeEntrustRecord.setCreateTime(new Date());

        if (sscImplementSchemeReqBO.getOperStatus()) {
            sscSchemeEntrustRecord.setSchemeStatus(String.valueOf(SscCommConstant.SchemeStatus.ACCEPTED.getCode()));
        } else {
            sscSchemeEntrustRecord.setSchemeStatus(String.valueOf(SscCommConstant.SchemeStatus.FORWARDING.getCode()));
        }
        sscSchemeEntrustRecords.add(sscSchemeEntrustRecord);
        sscSchemeDo.setSscSchemeEntrustRecord(sscSchemeEntrustRecords);
        iSscSchemeModel.addSchemeEntrustRecord(sscSchemeDo);


        return SscRu.success(SscImplementSchemeRspBO.class);
    }

    private void validDate(SscImplementSchemeReqBO reqBo) {
        if (!reqBo.getOperStatus() & reqBo.getRemark() == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "拒绝时，原因必填");
        }
    }
}
