package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeQryBo;
import com.tydic.dyc.ssc.service.common.SscExtInfoQryService;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoBo;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoQryReqBO;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoQryRspBO;
import com.tydic.dyc.ssc.service.common.bo.SscExtObjInfoBo;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 类名：SscQrySchemeMainInfoServiceImpl
 * 说明：描述一下类的作用
 * 时间：2022/11/10
 * 作者：pengyuqi
 */
@HTServiceImpl
public class SscQrySchemeMainInfoServiceImpl implements SscQrySchemeMainInfoService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscQrySchemeMainInfoRspBO qrySchemeMainInfo(SscQrySchemeMainInfoReqBO sscQrySchemeMainInfoReqBO0) {
        SscSchemeQryBo sscSchemeQryBo = SscRu.js(sscQrySchemeMainInfoReqBO0, SscSchemeQryBo.class);
        SscQrySchemeMainInfoRspBO sscQrySchemeMainInfoRspBO = SscRu.success(SscQrySchemeMainInfoRspBO.class);
        sscQrySchemeMainInfoRspBO.setSscQrySchemeMainInfoBO(SscRu.js(iSscSchemeModel.qrySchemeMainInfo(sscSchemeQryBo), SscQrySchemeMainInfoBO.class));
        this.setExtInfo(sscQrySchemeMainInfoRspBO);
        return sscQrySchemeMainInfoRspBO;
    }

    private void setExtInfo(SscQrySchemeMainInfoRspBO rspBO) {
        SscExtInfoQryReqBO qryReqBO = new SscExtInfoQryReqBO();
        SscExtObjInfoBo objInfoBo = new SscExtObjInfoBo();
        SscQrySchemeMainInfoBO sscQrySchemeMainInfoBO = rspBO.getSscQrySchemeMainInfoBO();
        if (ObjectUtil.isNotNull(sscQrySchemeMainInfoBO)) {
            objInfoBo.setObjId(sscQrySchemeMainInfoBO.getSchemeId());
            objInfoBo.setOrderId(sscQrySchemeMainInfoBO.getSchemeId());
            // 方案扩展字段
            objInfoBo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT);
            qryReqBO.setExtObjInfos(Collections.singletonList(objInfoBo));
            // 扩展字段信息
            SscCommonDo sscCommonDo = this.iSscCommonModel.qryExtInfo(SscRu.js(qryReqBO, SscCommonDo.class));
            List<SscExtObjInfo> infoBoList = sscCommonDo.getExtObjInfos();
            if (CollectionUtil.isNotEmpty(infoBoList)) {
                Map<Long, List<SscExtInfo>> objIdExtInfoMap = infoBoList.stream().collect(Collectors.toMap(SscExtObjInfo::getObjId, SscExtObjInfo::getExtInfo, (a, b) -> a));
                List<SscExtInfo> extInfoBos = objIdExtInfoMap.get(sscQrySchemeMainInfoBO.getSchemeId());
                sscQrySchemeMainInfoBO.setExtFields(SscRu.jsl(extInfoBos, BaseExtendFieldBo.class));
            }
        }
    }
}
