package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePackBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdatePackMainBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdatePackMainBatchRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: SscUpdatePackMainBatchServiceImpl
 * @Author: the_xhl
 * @Date: 2023-03-22
 */
@HTServiceImpl
public class SscUpdatePackMainBatchServiceImpl implements SscUpdatePackMainBatchService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscUpdatePackMainBatchRspBO updateSchemeBatchMain(SscUpdatePackMainBatchReqBO sscUpdatePackMainBatchReqBO) {
        check(sscUpdatePackMainBatchReqBO);
        SscUpdatePackMainBatchRspBO rspBO = SscRu.success(SscUpdatePackMainBatchRspBO.class);
        iSscSchemeModel.updatePackMain(SscRu.js(sscUpdatePackMainBatchReqBO, SscSchemeDo.class));
        // 修改扩展字段信息
        this.updateExtInfo(sscUpdatePackMainBatchReqBO);
        return rspBO;
    }

    private void check(SscUpdatePackMainBatchReqBO reqBO) {
        if (CollectionUtil.isEmpty(reqBO.getSscSchemePack())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[sscSchemePack]为空");
        }
        SscSchemePackBO sscSchemePackBO = reqBO.getSscSchemePack().stream().filter(e -> ObjectUtil.isNull(e.getPackId())).findAny().orElse(null);
        if (ObjectUtil.isNotNull(sscSchemePackBO)) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[packId]为空");
        }
    }

    private void updateExtInfo(SscUpdatePackMainBatchReqBO reqBO) {
        List<SscSchemePackBO> sscSchemePack = reqBO.getSscSchemePack();
        SscCommonDo sscCommonDo = new SscCommonDo();
        List<SscExtObjInfo> packObjInfoList = sscSchemePack
                .stream()
                .filter(e -> CollectionUtil.isNotEmpty(e.getExtFields()))
                .map(e -> {
                    SscExtObjInfo objInfo = new SscExtObjInfo();
                    objInfo.setObjId(e.getPackId());
                    objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT);
                    objInfo.setExtInfo(SscRu.jsl(e.getExtFields(), SscExtInfo.class));
                    return objInfo;
                }).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(packObjInfoList)) {
            sscCommonDo.setExtObjInfos(packObjInfoList);
            iSscCommonModel.updateExtInfo(sscCommonDo);
        }
    }
}
