/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscAccessory;
import com.tydic.dyc.ssc.service.scheme.SscSchemePutUpService;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePutUpReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePutUpRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscSchemePutUpService"})
public class SscSchemePutUpServiceImpl
implements SscSchemePutUpService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @PostMapping(value={"dealSchemePutUp"})
    public SscSchemePutUpRspBO dealSchemePutUp(@RequestBody SscSchemePutUpReqBO sscSchemePutUpReqBO) {
        this.check(sscSchemePutUpReqBO);
        SscSchemePutUpRspBO rspBO = SscRu.success(SscSchemePutUpRspBO.class);
        SscSchemeChangeBO changeBO = SscRu.js(sscSchemePutUpReqBO, SscSchemeChangeBO.class);
        changeBO.setOperType(SscCommConstant.OperTypeEnum.PUT_UP.getCode());
        changeBO.setSscAccessory(SscRu.jsl(sscSchemePutUpReqBO.getSscAccessory(), SscAccessory.class));
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setSchemeId(sscSchemePutUpReqBO.getSchemeId());
        sscSchemeDo.setSchemeStatus(SscCommConstant.SchemeStatus.PUT_UP.getCode());
        sscSchemeDo.setCreateLoginId(sscSchemePutUpReqBO.getUserId());
        sscSchemeDo.setCreateName(sscSchemePutUpReqBO.getName());
        sscSchemeDo.setCreateUsername(sscSchemePutUpReqBO.getUsername());
        sscSchemeDo.setSscSchemeChange(Collections.singletonList(changeBO));
        this.iSscSchemeModel.dealSchemePutUp(sscSchemeDo);
        return rspBO;
    }

    private void check(SscSchemePutUpReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getSchemeId())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[schemeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

