package com.tydic.dyc.ssc.service.auditorder;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.procinst.ISscProcInstModel;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.model.procinst.qrybo.SscTaskQryBo;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.ssc.service.auditorder.bo.SscQryApproverListReqBO;
import com.tydic.dyc.ssc.service.auditorder.bo.SscQryApproverListRspBO;
import com.tydic.dyc.ssc.service.procinst.bo.SscUocOrderTaskInstBo;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: SscQryApproverListServiceImpl
 * @Author: the_xhl
 * @Date: 2023-04-10
 */
@HTServiceImpl
public class SscQryApproverListServiceImpl implements SscQryApproverListService {

    @Autowired
    private ISscProcInstModel iSscProcInstModel;

    @Override
    public SscQryApproverListRspBO qryApproverListService(SscQryApproverListReqBO reqBO) {
        check(reqBO);
        SscQryApproverListRspBO rspBO = SscRu.success(SscQryApproverListRspBO.class);
        // 根据任务实例id查询流程实例id
        SscTaskQryBo param0 = new SscTaskQryBo();
        param0.setTaskInstId(reqBO.getTaskInstId());
        param0.setOrderId(reqBO.getOrderId());
        SscProcInstDo taskList = iSscProcInstModel.getTaskList(param0);
        UocOrderTaskInst uocOrderTaskInst = taskList.getSscUocOrderTaskInst().get(0);
        String procInstId = uocOrderTaskInst.getProcInstId();
        // 根据流程实例id查询审批人员列表
        SscTaskQryBo sscTaskQryBo = new SscTaskQryBo();
        sscTaskQryBo.setProcInstId(procInstId);
        sscTaskQryBo.setOrderId(reqBO.getOrderId());
        sscTaskQryBo.setFinishTag(reqBO.getFinishTag());
        SscProcInstDo sscProcInstDo = iSscProcInstModel.getTaskList(sscTaskQryBo);
        rspBO.setRows(SscRu.jsl(sscProcInstDo.getSscUocOrderTaskInst(), SscUocOrderTaskInstBo.class));
        return rspBO;
    }

    private void check(SscQryApproverListReqBO reqBO) {
        if (StrUtil.isEmpty(reqBO.getTaskInstId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[taskInstId] 不能为空");
        }
        if (ObjectUtil.isNull(reqBO.getFinishTag())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[finishTag] 不能为空");
        }
    }
}
