package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SchemeAcceptRecordQryBo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeEntrustRecordQryBo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeAcceptRecord;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 标题：SscQrySchemeAcceptRecordListServiceImpl
 * 时间：2022/11/14
 * 说明：方案受理记录列表查询服务
 * @author hechenze
 */
@HTServiceImpl
public class SscQrySchemeAcceptRecordListServiceImpl implements SscQrySchemeAcceptRecordListService{
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Override
    public SscQrySchemeAcceptRecordListRspBO qrySchemeAcceptRecordList(SscQrySchemeAcceptRecordListReqBO sscQrySchemeAcceptRecordListReqBO) {
        SscQrySchemeAcceptRecordListRspBO rspBo = SscRu.success(SscQrySchemeAcceptRecordListRspBO.class);
        //入参必填校验
        validateArg(sscQrySchemeAcceptRecordListReqBO);
        //调用方案受理记录列表查询
        SchemeAcceptRecordQryBo qryBo = SscRu.js(sscQrySchemeAcceptRecordListReqBO, SchemeAcceptRecordQryBo.class);
        SscSchemeDo sscSchemeDo = iSscSchemeModel.qrySchemeAcceptRecordList(qryBo);
        if (sscSchemeDo == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_QUERY_SCHEME_ACCEPT_RECORD_ERROR, "方案受理记录列表查询为空");
        }
        List<SscSchemeAcceptRecord> list = sscSchemeDo.getSscSchemeAcceptRecord();
        List<SscQrySchemeAcceptRecordBO> recordBOList = new ArrayList<>();
        for (SscSchemeAcceptRecord sscSchemeAcceptRecord : list) {
            SscQrySchemeAcceptRecordBO detailBO = SscRu.js(sscSchemeAcceptRecord, SscQrySchemeAcceptRecordBO.class);
            if (sscSchemeAcceptRecord.getStatus()!=null){
                //statusStr字段翻译，创建枚举类做字典翻译
                detailBO.setStatusStr(Objects.requireNonNull(SscCommConstant.SchemeAcceptRecordStatus.getInstance(sscSchemeAcceptRecord.getStatus())).getDesc());
            }
            recordBOList.add(detailBO);
        }
        rspBo.setRows(recordBOList);
        return rspBo;
    }

    private void validateArg(SscQrySchemeAcceptRecordListReqBO reqBO){
        if (reqBO == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[SscQrySchemeAcceptRecordListReqBO]不能为空");
        }
        if (reqBO.getSchemeId() == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[方案ID]不能为空");
        }
    }
}
