package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoListReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoListRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description: SscQrySchemeMainInfoListServiceImpl
 * @Author: the_xhl
 * @Date: 2023-04-03
 */
@HTServiceImpl
public class SscQrySchemeMainInfoListServiceImpl implements SscQrySchemeMainInfoListService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscQrySchemeMainInfoListRspBO qrySchemeMainInfoList(SscQrySchemeMainInfoListReqBO sscQrySchemeMainInfoListReqBO) {
        check(sscQrySchemeMainInfoListReqBO);
        SscQrySchemeMainInfoListRspBO rspBO = SscRu.success(SscQrySchemeMainInfoListRspBO.class);
        SscQrySchemeMainInfoListRspBO schemeMainInfoList = iSscSchemeModel.qrySchemeMainInfoList(sscQrySchemeMainInfoListReqBO);
        rspBO.setSscQrySchemeMainInfoList(schemeMainInfoList.getSscQrySchemeMainInfoList());
        // 查询扩展字段信息
        this.setExtInfo(rspBO);
        return rspBO;
    }

    private void check(SscQrySchemeMainInfoListReqBO reqBO) {
        if (CollectionUtil.isEmpty(reqBO.getSchemeIdList())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[schemeIdList]不能为空");
        }
    }

    private void setExtInfo(SscQrySchemeMainInfoListRspBO rspBO) {
        List<SscQrySchemeMainInfoBO> sscQrySchemeMainInfoList = rspBO.getSscQrySchemeMainInfoList();
        if (CollectionUtil.isNotEmpty(sscQrySchemeMainInfoList)) {
            List<SscExtObjInfo> objInfoList = sscQrySchemeMainInfoList.stream().map(e -> {
                SscExtObjInfo objInfo = new SscExtObjInfo();
                objInfo.setObjId(e.getSchemeId());
                objInfo.setOrderId(e.getSchemeId());
                objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT);
                return objInfo;
            }).collect(Collectors.toList());
            SscCommonDo sscCommonDo = new SscCommonDo();
            sscCommonDo.setExtObjInfos(objInfoList);
            SscCommonDo extInfoResult = iSscCommonModel.qryExtInfo(sscCommonDo);
            List<SscExtObjInfo> extObjInfoList = extInfoResult.getExtObjInfos();
            if (CollectionUtil.isNotEmpty(extObjInfoList)) {
                Map<Long, List<SscExtInfo>> objIdInfoListMap = extObjInfoList.stream().collect(Collectors.toMap(SscExtObjInfo::getObjId, SscExtObjInfo::getExtInfo, (a, b) -> a));
                sscQrySchemeMainInfoList.forEach(e -> e.setExtFields(SscRu.jsl(objIdInfoListMap.get(e.getSchemeId()), BaseExtendFieldBo.class)));
            }
        }
    }
}
