/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.project;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.project.ISscProjectModel;
import com.tydic.dyc.ssc.model.project.SscBidProjectDo;
import com.tydic.dyc.ssc.model.project.qrybo.SscBidProjectQryBo;
import com.tydic.dyc.ssc.model.project.sub.SscProjectChange;
import com.tydic.dyc.ssc.model.project.sub.SscProjectNotice;
import com.tydic.dyc.ssc.service.project.SscQryProjectNoticeDetailService;
import com.tydic.dyc.ssc.service.project.bo.SscProjectChangeBO;
import com.tydic.dyc.ssc.service.project.bo.SscQryProjectNoticeDetailReqBO;
import com.tydic.dyc.ssc.service.project.bo.SscQryProjectNoticeDetailRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.project.SscQryProjectNoticeDetailService"})
public class SscQryProjectNoticeDetailServiceImpl
implements SscQryProjectNoticeDetailService {
    @Autowired
    private ISscProjectModel iSscProjectModel;

    @PostMapping(value={"qryProjectNoticeDetail"})
    public SscQryProjectNoticeDetailRspBO qryProjectNoticeDetail(@RequestBody SscQryProjectNoticeDetailReqBO sscQryProjectNoticeDetailReqBO) {
        SscQryProjectNoticeDetailRspBO rspBO = SscRu.success(SscQryProjectNoticeDetailRspBO.class);
        this.check(sscQryProjectNoticeDetailReqBO);
        SscBidProjectDo sscBidProjectDo = this.iSscProjectModel.qryProjectNoticeDetail((SscBidProjectQryBo)JUtil.js((Object)sscQryProjectNoticeDetailReqBO, SscBidProjectQryBo.class));
        List<SscProjectNotice> sscProjectNotice = sscBidProjectDo.getSscProjectNotice();
        if (CollectionUtil.isEmpty(sscProjectNotice)) {
            return rspBO;
        }
        BeanUtil.copyProperties((Object)sscProjectNotice.get(0), (Object)rspBO);
        Integer noticeType = rspBO.getNoticeType();
        if (SscCommConstant.NoticeTypeEnum.BID_NOTICE.getCode().equals(noticeType) || SscCommConstant.NoticeTypeEnum.INVITATION.getCode().equals(noticeType) || SscCommConstant.NoticeTypeEnum.CHANGE_NOTICE.getCode().equals(noticeType)) {
            SscBidProjectQryBo sscBidProjectQryBo = new SscBidProjectQryBo();
            sscBidProjectQryBo.setProjectId(rspBO.getProjectId());
            sscBidProjectQryBo.setNoticeId(rspBO.getNoticeId());
            SscBidProjectDo bidProjectDo = this.iSscProjectModel.qryProjectChangeList(sscBidProjectQryBo);
            List<SscProjectChange> sscProjectChangeList = bidProjectDo.getSscProjectChange();
            if (CollectionUtil.isNotEmpty(sscProjectChangeList)) {
                List sscProjectChangeBOList = sscProjectChangeList.stream().map(e -> {
                    SscProjectChangeBO sscProjectChangeBO = (SscProjectChangeBO)BeanUtil.toBean((Object)e, SscProjectChangeBO.class);
                    sscProjectChangeBO.setBidEvalMethodStr(SscCommConstant.BidEvalMethodEnum.findDescByCode((Integer)sscProjectChangeBO.getBidEvalMethod()).getDesc());
                    return sscProjectChangeBO;
                }).collect(Collectors.toList());
                rspBO.setSscProjectChangeList(sscProjectChangeBOList);
            }
        }
        rspBO.setNoticeTypeStr(SscCommConstant.NoticeTypeEnum.findDescByCode((Integer)rspBO.getNoticeType()).getDesc());
        return rspBO;
    }

    private void check(SscQryProjectNoticeDetailReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getProjectId())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[projectId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

