/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemePack;
import com.tydic.dyc.ssc.service.scheme.SscUpdatePackMainService;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdatePackMainReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdatePackMainRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscUpdatePackMainService"})
public class SscUpdatePackMainServiceImpl
implements SscUpdatePackMainService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscCommonModel iSscCommonModel;

    @PostMapping(value={"updatePackMain"})
    public SscUpdatePackMainRspBO updatePackMain(@RequestBody SscUpdatePackMainReqBO sscUpdatePackMainReqBO) {
        this.check(sscUpdatePackMainReqBO);
        SscUpdatePackMainRspBO rspBO = SscRu.success(SscUpdatePackMainRspBO.class);
        SscSchemePack schemePack = SscRu.js(sscUpdatePackMainReqBO, SscSchemePack.class);
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setSscSchemePack(Collections.singletonList(schemePack));
        this.iSscSchemeModel.updatePackMain(sscSchemeDo);
        this.updateExtInfo(sscUpdatePackMainReqBO);
        return rspBO;
    }

    private void check(SscUpdatePackMainReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getPackId())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[packId]\u4e3a\u7a7a");
        }
    }

    private void updateExtInfo(SscUpdatePackMainReqBO reqBO) {
        List extFieldList = reqBO.getExtFields();
        if (CollectionUtil.isNotEmpty((Collection)extFieldList)) {
            SscCommonDo sscCommonDo = new SscCommonDo();
            SscExtObjInfo objInfo = new SscExtObjInfo();
            objInfo.setObjId(reqBO.getPackId());
            objInfo.setObjType("ssc_scheme_pack_ext");
            objInfo.setExtInfo(SscRu.jsl(extFieldList, SscExtInfo.class));
            sscCommonDo.setExtObjInfos(Collections.singletonList(objInfo));
            this.iSscCommonModel.updateExtInfo(sscCommonDo);
        }
    }
}

