package com.tydic.dyc.ssc.model.procinst.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.procinst.ISscProcInstModel;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.model.procinst.qrybo.SscTaskQryBo;
import com.tydic.dyc.ssc.repository.SscProcInstRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Date;

/**
 * 标题:ISscProcInstModelImpl
 * 说明:TODO
 * 时间:2022/8/24 10:13
 * 作者:王洪港
 */
@Service
public class ISscProcInstModelImpl implements ISscProcInstModel {

    @Autowired
    private SscProcInstRepository sscProcInstRepository;

    @Override
    public SscProcInstDo getTaskList(SscTaskQryBo param0) {
        //入参校验
        validateSscTask(param0);
        return sscProcInstRepository.getTaskList(param0);
    }

    private void validateSscTask(SscTaskQryBo sscTaskQryBo) {
        if (ObjectUtil.isEmpty(sscTaskQryBo)) {
            throw new BaseBusinessException("0001", "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(sscTaskQryBo.getOrderId())) {
            throw new BaseBusinessException("0001", "入参对象属性[订单id]不能为空");
        }
    }

    @Override
    public void updateTask(SscProcInstDo sscProcInstDo) {
        // 必填校验
        if (sscProcInstDo == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参对象不能为空");
        }
        if (CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskInst())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参sscUocOrderTaskInst不能为空");
        }
        sscProcInstDo.getSscUocOrderTaskInst().forEach(uocOrderTaskInst -> {
            if (uocOrderTaskInst.getOrderId() == null) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参orderId不能为空");
            }
            if (uocOrderTaskInst.getObjId() == null) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参objId不能为空");
            }
            if (StringUtils.isEmpty(uocOrderTaskInst.getTaskInstId())) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参taskInstId不能为空");
            }
        });
        sscProcInstRepository.updateTask(sscProcInstDo);

    }

    @Override
    public SscProcInstDo getProcInst(SscProcInstDo sscProcInstDo) {
        if (sscProcInstDo == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参对象不能为空");
        }
        if (StringUtils.isEmpty(sscProcInstDo.getProcInstId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参procInstId不能为空");

        }
        return sscProcInstRepository.getProInst(sscProcInstDo);
    }

    @Override
    public void saveProcInst(SscProcInstDo sscProcInstDo) {
        if (sscProcInstDo == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参对象不能为空");
        }
        if (StringUtils.isEmpty(sscProcInstDo.getProcInstId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参procInstId不能为空");

        }
        if (sscProcInstDo.getObjId() == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参objId不能为空");

        }
        if (sscProcInstDo.getOrderId() == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参orderId不能为空");

        }
        if (sscProcInstDo.getObjType() == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参ObjType不能为空");

        }
        sscProcInstDo.setOperTime(new Date());
        sscProcInstRepository.saveProcInst(sscProcInstDo);
    }

    @Override
    public void saveTask(SscProcInstDo sscProcInstDo) {
        if (sscProcInstDo == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参对象不能为空");
        }
        if (CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskInst())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参sscUocOrderTaskInst不能为空");
        }
        sscProcInstDo.getSscUocOrderTaskInst().forEach(uocOrderTaskInst -> {
            if (StringUtils.isEmpty(uocOrderTaskInst.getProcInstId())) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参procInstId不能为空");
            }
            if (StringUtils.isEmpty(uocOrderTaskInst.getTaskInstId())) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参taskInstId不能为空");
            }
            if (uocOrderTaskInst.getObjId() == null) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参objId不能为空");

            }
            if (uocOrderTaskInst.getOrderId() == null) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参orderId不能为空");

            }
            if (uocOrderTaskInst.getObjType() == null) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参ObjType不能为空");

            }
        });
        if (!CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskDeal())) {
            sscProcInstDo.getSscUocOrderTaskDeal().forEach(uocOrderTaskDeal -> {
                if (StringUtils.isEmpty(uocOrderTaskDeal.getTaskInstId())) {
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参taskInstId不能为空");
                }
                if (uocOrderTaskDeal.getObjId() == null) {
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参objId不能为空");

                }
                if (uocOrderTaskDeal.getOrderId() == null) {
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参orderId不能为空");

                }
                if (uocOrderTaskDeal.getObjType() == null) {
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参ObjType不能为空");

                }
                if (StringUtils.isEmpty(uocOrderTaskDeal.getDealId())) {
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参dealId不能为空");
                }
                if (StringUtils.isEmpty(uocOrderTaskDeal.getDealName())) {
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参dealName不能为空");
                }
            });
        }
        sscProcInstDo.setOperTime(new Date());
        sscProcInstRepository.saveTask(sscProcInstDo);
    }

    @Override
    public void updateTaskDeal(SscProcInstDo sscProcInstDo) {
        if (sscProcInstDo == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参对象不能为空");
        }
        if (CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskDeal())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参sscUocOrderTaskDeal不能为空");
        }
        sscProcInstDo.getSscUocOrderTaskDeal().forEach(uocOrderTaskDeal -> {
            if (StringUtils.isEmpty(uocOrderTaskDeal.getTaskInstId())) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参taskInstId不能为空");
            }
            if (uocOrderTaskDeal.getObjType() == null) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参ObjType不能为空");
            }
            if (StringUtils.isEmpty(uocOrderTaskDeal.getDealId())) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参dealId不能为空");
            }
            if (StringUtils.isEmpty(uocOrderTaskDeal.getDealName())) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参dealName不能为空");
            }
            if (uocOrderTaskDeal.getObjId() == null) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参objId不能为空");

            }
            if (uocOrderTaskDeal.getOrderId() == null) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参orderId不能为空");

            }
        });
        sscProcInstRepository.updateTaskDeal(sscProcInstDo);
    }

    @Override
    public void deleteTask(SscProcInstDo sscProcInstDo) {
        if (sscProcInstDo == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参对象不能为空");
        }
        if (CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskInst())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参sscUocOrderTaskInst不能为空");
        }
        sscProcInstDo.getSscUocOrderTaskInst().forEach(uocOrderTaskInst -> {
            if (uocOrderTaskInst.getObjId() == null) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参objId不能为空");
            }
            if (uocOrderTaskInst.getOrderId() == null) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参orderId不能为空");
            }
        });
        sscProcInstRepository.deleteTask(sscProcInstDo);
    }

    @Override
    public void saveTaskLog(SscProcInstDo param0) {

    }

    @Override
    public void getTaskDeal(SscProcInstDo param0) {

    }

    @Override
    public SscProcInstDo getProcInstList(SscProcInstDo sscProcInstDo) {
        return sscProcInstRepository.getProInstList(sscProcInstDo);
    }

    @Override
    public void updateProcInst(SscProcInstDo param0) {
        this.sscProcInstRepository.updateProcInst(param0);
    }
}
