package com.tydic.dyc.ssc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoDeleteReqBO;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoDeleteRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/**
 * 标题:SscExtInfoDeleteServiceImpl
 * 说明:TODO
 * 时间:2023/3/13 15:06
 * 作者:代愿愿
 */
@HTServiceImpl
public class SscExtInfoDeleteServiceImpl implements SscExtInfoDeleteService {
    @Autowired
    private ISscCommonModel iSscCommonModel;
    @Override
    public SscExtInfoDeleteRspBO deleteExtInfo(SscExtInfoDeleteReqBO sscExtInfoDeleteReqBO) {
        this.validParam(sscExtInfoDeleteReqBO);
        SscCommonDo sscCommonDo = new SscCommonDo() ;
        sscCommonDo.setExtObjInfos(SscRu.jsl(sscExtInfoDeleteReqBO.getExtObjInfos(), SscExtObjInfo.class));
        iSscCommonModel.deleteExtInfo(sscCommonDo);
        SscExtInfoDeleteRspBO rspBO = new SscExtInfoDeleteRspBO();
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
    /**
     * 入参校验
     */
    private void validParam(SscExtInfoDeleteReqBO sscExtInfoDeleteReqBO){
        if(ObjectUtil.isEmpty(sscExtInfoDeleteReqBO)){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象不能为空");
        }
        if(CollectionUtils.isEmpty(sscExtInfoDeleteReqBO.getExtObjInfos())){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参extObjInfos不能为空");
        }
        sscExtInfoDeleteReqBO.getExtObjInfos().forEach(sscExtObjInfoBo -> {
            if(StringUtils.isEmpty(sscExtObjInfoBo.getObjType())){
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参ObjType不能为空");
            }
            if(sscExtObjInfoBo.getOrderId()==null){
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参OrderId不能为空");
            }
            if(!CollectionUtils.isEmpty(sscExtObjInfoBo.getExtInfo())){
                sscExtObjInfoBo.getExtInfo().forEach(sscExtInfoBo -> {
                    if(StringUtils.isEmpty(sscExtInfoBo.getFieldCode())){
                        throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参FieldCode不能为空");
                    }
                });
            }

        });
    }
}
