package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeInviteSupBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeInviteSupBatchRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeInviteSupBO;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * SscAddSchemeInviteSupBatchServiceImpl
 * 2022/11/11
 * Project:work
 * Creator:千雪
 * Create Time:2022/11/11-18-29
 * IDE: IntelliJ IDEA
 */
@HTServiceImpl
public class SscAddSchemeInviteSupBatchServiceImpl implements SscAddSchemeInviteSupBatchService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscAddSchemeInviteSupBatchRspBO addSchemeInviteSupBatch(SscAddSchemeInviteSupBatchReqBO sscAddSchemeInviteSupBatchReqBO) {
        // 设置供应商id
        sscAddSchemeInviteSupBatchReqBO.getSscSchemeInviteSup().forEach(e -> e.setSchemeInviteSupId(IdUtil.nextId()));
        SscSchemeDo sscSchemeDo = JSON.parseObject(JSON.toJSONString(sscAddSchemeInviteSupBatchReqBO), SscSchemeDo.class);
        iSscSchemeModel.addSchemeInviteSupBatch(sscSchemeDo);
        // 新增扩展信息
        this.addExtInfo(sscAddSchemeInviteSupBatchReqBO);
        return SscRu.success(SscAddSchemeInviteSupBatchRspBO.class);
    }

    public void addExtInfo(SscAddSchemeInviteSupBatchReqBO reqBO) {
        List<SscSchemeInviteSupBO> sscSchemeInviteSup = reqBO.getSscSchemeInviteSup();
        if (CollectionUtil.isNotEmpty(sscSchemeInviteSup)) {
            Boolean enableDraft = reqBO.getEnableDraft();
            SscCommonDo sscCommonDo = new SscCommonDo();
            List<SscExtObjInfo> supObjInfoList = sscSchemeInviteSup.stream()
                    .map(x -> {
                        SscExtObjInfo objInfo = new SscExtObjInfo();
                        objInfo.setObjId(x.getSchemeInviteSupId());
                        objInfo.setOrderId(reqBO.getSchemeId());
                        objInfo.setObjType(enableDraft ? SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT : SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT);
                        objInfo.setExtInfo(SscRu.jsl(x.getExtFields(), SscExtInfo.class));
                        return objInfo;
                    }).collect(Collectors.toList());
            sscCommonDo.setExtObjInfos(supObjInfoList);
            iSscCommonModel.addExtInfo(sscCommonDo);
        }
    }
}
