package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailReqBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 标题：SscDeleteSchemeServiceImpl
 * 时间：2022/11/10
 * 说明：方案删除服务
 * @author hechenze
 */
@HTServiceImpl
public class SscDeleteSchemeServiceImpl implements SscDeleteSchemeService{
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscDeleteSchemeRspBO deleteScheme(SscDeleteSchemeReqBO sscDeleteSchemeReqBO0) {
        SscDeleteSchemeRspBO rspBo = SscRu.success(SscDeleteSchemeRspBO.class);
        //入参校验
        validateArg(sscDeleteSchemeReqBO0);
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setEnableDraft(sscDeleteSchemeReqBO0.getEnableDraft());
        sscSchemeDo.setSchemeId(sscDeleteSchemeReqBO0.getSchemeId());
        iSscSchemeModel.deleteScheme(sscSchemeDo);
        // 删除扩展字段信息
        this.deleteExtInfo(sscDeleteSchemeReqBO0);
        return rspBo;
    }

    private void validateArg(SscDeleteSchemeReqBO reqBO){
        if (reqBO == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[SscDeleteSchemeReqBO不能为空");
        }
        if (reqBO.getSchemeId() == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[schemeId]不能为空");
        }
        if (reqBO.getEnableDraft() == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[enableDraft]不能为空");
        }
    }

    private void deleteExtInfo(SscDeleteSchemeReqBO reqBO) {
        SscCommonDo sscCommonDo = new SscCommonDo();
        List<SscExtObjInfo> extObjInfos = new ArrayList<>();
        // 方案
        extObjInfos.add(createObjInfo(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT, reqBO.getSchemeId()));
        // 标段
        extObjInfos.add(createObjInfo(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT, reqBO.getSchemeId()));
        // 明细
        extObjInfos.add(createObjInfo(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT, reqBO.getSchemeId()));
        // 供应商
        extObjInfos.add(createObjInfo(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT, reqBO.getSchemeId()));
        sscCommonDo.setExtObjInfos(extObjInfos);
        iSscCommonModel.deleteExtInfo(sscCommonDo);
    }

    private SscExtObjInfo createObjInfo(String objType, Long schemeId) {
        SscExtObjInfo objInfo = new SscExtObjInfo();
        objInfo.setOrderId(schemeId);
        objInfo.setObjType(objType);
        return objInfo;
    }
}
