package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeCancelPutUpReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeCancelPutUpRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: SscSchemeCancelPutUpServiceImpl
 * @Author: the_xhl
 * @Date: 2023-01-16
 */
@HTServiceImpl
public class SscSchemeCancelPutUpServiceImpl implements SscSchemeCancelPutUpService{

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Override
    public SscSchemeCancelPutUpRspBO dealSchemeCancelPutUp(SscSchemeCancelPutUpReqBO sscSchemeCancelPutUpReqBO) {
        check(sscSchemeCancelPutUpReqBO);
        SscSchemeCancelPutUpRspBO rspBO = SscRu.success(SscSchemeCancelPutUpRspBO.class);
        iSscSchemeModel.dealSchemeCancelPutUp(JUtil.js(sscSchemeCancelPutUpReqBO, SscSchemeDo.class));
        return rspBO;
    }

    private void check(SscSchemeCancelPutUpReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getSchemeId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[schemeId]不能为空");
        }
    }
}
