package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscAccessory;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePutUpReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePutUpRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;

/**
 * @Description: SscSchemePutUpServiceImpl
 * @Author: the_xhl
 * @Date: 2023-01-16
 */
@HTServiceImpl
public class SscSchemePutUpServiceImpl implements SscSchemePutUpService{

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Override
    public SscSchemePutUpRspBO dealSchemePutUp(SscSchemePutUpReqBO sscSchemePutUpReqBO) {
        check(sscSchemePutUpReqBO);
        SscSchemePutUpRspBO rspBO = SscRu.success(SscSchemePutUpRspBO.class);
        SscSchemeChangeBO changeBO = SscRu.js(sscSchemePutUpReqBO, SscSchemeChangeBO.class);
        changeBO.setOperType(SscCommConstant.OperTypeEnum.PUT_UP.getCode());
        changeBO.setSscAccessory(SscRu.jsl(sscSchemePutUpReqBO.getSscAccessory(), SscAccessory.class));
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setSchemeId(sscSchemePutUpReqBO.getSchemeId());
        sscSchemeDo.setSchemeStatus(SscCommConstant.SchemeStatus.PUT_UP.getCode());
        sscSchemeDo.setCreateLoginId(sscSchemePutUpReqBO.getUserId());
        sscSchemeDo.setCreateName(sscSchemePutUpReqBO.getName());
        sscSchemeDo.setCreateUsername(sscSchemePutUpReqBO.getUsername());
        sscSchemeDo.setSscSchemeChange(Collections.singletonList(changeBO));
        iSscSchemeModel.dealSchemePutUp(sscSchemeDo);
        return rspBO;
    }

    private void check(SscSchemePutUpReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getSchemeId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[schemeId]不能为空");
        }
    }
}
