package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 类名：SscUpdateSchemeServiceImpl
 * 说明：描述一下类的作用
 * 时间：2022/11/10
 * 作者：pengyuqi
 */
@HTServiceImpl
public class SscUpdateSchemeServiceImpl implements SscUpdateSchemeService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscUpdateSchemeRspBO updateScheme(SscUpdateSchemeReqBO sscUpdateSchemeReqBO0) {
        SscUpdateSchemeRspBO rspBO = SscRu.success(SscUpdateSchemeRspBO.class);
        SscSchemeDo updateDo = SscRu.js(sscUpdateSchemeReqBO0, SscSchemeDo.class);
        updateDo.setOperTime(new Date());
        iSscSchemeModel.updateScheme(updateDo);
        //调用方案草稿到主表复制方法
        SscSchemeDo copyDo = new SscSchemeDo();
        copyDo.setSchemeId(sscUpdateSchemeReqBO0.getSchemeId());
        iSscSchemeModel.copyScheme(copyDo);
        // 删除方案所有扩展字段
        this.deleteExtInfo(sscUpdateSchemeReqBO0);
        // 新增扩展字段信息
        this.addExtInfo(sscUpdateSchemeReqBO0);
        return rspBO;
    }

    private void addExtInfo(SscUpdateSchemeReqBO reqBO) {
        // 方案扩展字段信息
        List<BaseExtendFieldBo> extFieldList = reqBO.getExtFields();
        List<SscExtObjInfo> extObjInfoList = new ArrayList<>();
        SscCommonDo sscCommonDo = new SscCommonDo();
        if (CollectionUtil.isNotEmpty(extFieldList)) {
            SscExtObjInfo objInfo = new SscExtObjInfo();
            objInfo.setObjId(reqBO.getSchemeId());
            objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT);
            objInfo.setExtInfo(SscRu.jsl(extFieldList, SscExtInfo.class));
            extObjInfoList.add(objInfo);
        }

        // 方案包扩展字段信息
        List<SscSchemePackBO> packList = reqBO.getSscSchemePack();
        if (CollectionUtil.isNotEmpty(packList)) {
            List<SscExtObjInfo> packExtObjInfoList = packList.stream()
                    .filter(e -> CollectionUtil.isNotEmpty(e.getExtFields()))
                    .map(e -> {
                        List<BaseExtendFieldBo> packExtFieldList = e.getExtFields();
                        SscExtObjInfo objInfo = new SscExtObjInfo();
                        objInfo.setObjId(e.getPackId());
                        objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT);
                        objInfo.setExtInfo(SscRu.jsl(packExtFieldList, SscExtInfo.class));
                        return objInfo;
                    }).collect(Collectors.toList());
            extObjInfoList.addAll(packExtObjInfoList);
        }

        if (CollectionUtil.isNotEmpty(extObjInfoList)) {
            sscCommonDo.setExtObjInfos(extObjInfoList);
            iSscCommonModel.addExtInfo(sscCommonDo);
        }

    }

    private void deleteExtInfo(SscUpdateSchemeReqBO reqBO) {
        SscExtObjInfo objInfo = new SscExtObjInfo();
        objInfo.setOrderId(reqBO.getSchemeId());
        objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT);
        SscCommonDo sscCommonDo = new SscCommonDo();
        sscCommonDo.setExtObjInfos(Collections.singletonList(objInfo));
        iSscCommonModel.deleteExtInfo(sscCommonDo);
    }

}
