/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.repository.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.auditorder.SscAuditOrderDo;
import com.tydic.dyc.ssc.model.auditorder.qrybo.SscAuditOrderQryBo;
import com.tydic.dyc.ssc.model.auditorder.sub.UocApprovalObj;
import com.tydic.dyc.ssc.repository.SscAuditOrderRepository;
import com.tydic.dyc.ssc.repository.dao.SscSchemeMapper;
import com.tydic.dyc.ssc.repository.dao.UocApprovalObjMapper;
import com.tydic.dyc.ssc.repository.dao.UocAuditOrderMapper;
import com.tydic.dyc.ssc.repository.dao.UocOrderProcInstMapper;
import com.tydic.dyc.ssc.repository.dao.UocOrderTaskInstMapper;
import com.tydic.dyc.ssc.repository.po.SscSchemePO;
import com.tydic.dyc.ssc.repository.po.UocApprovalObjPO;
import com.tydic.dyc.ssc.repository.po.UocAuditOrderPO;
import com.tydic.dyc.ssc.repository.po.UocOrderProcInstPO;
import com.tydic.dyc.ssc.repository.po.UocOrderTaskInstPO;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscAuditOrderRepositoryImpl
implements SscAuditOrderRepository {
    private static final Logger log = LoggerFactory.getLogger(SscAuditOrderRepositoryImpl.class);
    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private SscSchemeMapper sscSchemeMapper;
    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;

    public void saveAuditOrder(SscAuditOrderDo sscAuditOrderDo) {
        UocAuditOrderPO uocAuditOrderPO = (UocAuditOrderPO)SscRu.js((Object)sscAuditOrderDo, UocAuditOrderPO.class);
        this.uocAuditOrderMapper.insert(uocAuditOrderPO);
        if (!CollectionUtils.isEmpty((Collection)sscAuditOrderDo.getUocApprovalObj())) {
            ArrayList<UocApprovalObjPO> uocApprovalObjPOS = new ArrayList<UocApprovalObjPO>();
            sscAuditOrderDo.getUocApprovalObj().forEach(uocApprovalObj -> {
                UocApprovalObjPO po = (UocApprovalObjPO)SscRu.js((Object)uocApprovalObj, UocApprovalObjPO.class);
                if (SscCommConstant.OBJ_BUSI_TYPE.SCHEME.equals(po.getObjBusiType())) {
                    SscSchemePO where = new SscSchemePO();
                    where.setSchemeId(sscAuditOrderDo.getOrderId());
                    SscSchemePO schemePO = this.sscSchemeMapper.getModelBy(where);
                    if (ObjectUtil.isNull((Object)schemePO)) {
                        log.error("\u65b9\u6848\u4fe1\u606f\u4e3a\u7a7a, \u65b9\u6848id\u4e3a: {}", (Object)po.getOrderId());
                    } else {
                        po.setObjVersion(schemePO.getSchemeVersion());
                    }
                }
                po.setAuditOrderId(sscAuditOrderDo.getAuditOrderId());
                po.setId(IdUtil.nextId());
                po.setOrderId(sscAuditOrderDo.getOrderId());
                po.setCreateTime(new Date());
                uocApprovalObjPOS.add(po);
            });
            this.uocApprovalObjMapper.insertBatch(uocApprovalObjPOS);
        }
    }

    public SscAuditOrderDo getAuditObj(SscAuditOrderQryBo sscAuditOrderQryBo) {
        UocApprovalObjPO uocApprovalObjPO = (UocApprovalObjPO)SscRu.js((Object)sscAuditOrderQryBo, UocApprovalObjPO.class);
        List<UocApprovalObjPO> pos = this.uocApprovalObjMapper.getList(uocApprovalObjPO);
        List uocApprovalObj = SscRu.jsl(pos, UocApprovalObj.class);
        SscAuditOrderDo sscAuditOrderDo = new SscAuditOrderDo();
        sscAuditOrderDo.setUocApprovalObj(uocApprovalObj);
        return sscAuditOrderDo;
    }

    public void deleteAuditObj(SscAuditOrderDo param0) {
        List objList = param0.getUocApprovalObj();
        if (CollectionUtil.isNotEmpty((Collection)objList)) {
            ArrayList<Long> auditOrderIdList = new ArrayList<Long>();
            objList.forEach(e -> {
                UocApprovalObjPO uocapprovalobjpo = new UocApprovalObjPO();
                uocapprovalobjpo.setObjId(e.getObjId());
                uocapprovalobjpo.setObjBusiType(e.getObjBusiType());
                uocapprovalobjpo.setObjVersion(e.getObjVersion());
                List<UocApprovalObjPO> list = this.uocApprovalObjMapper.getList(uocapprovalobjpo);
                if (CollectionUtil.isNotEmpty(list)) {
                    auditOrderIdList.addAll(list.stream().map(UocApprovalObjPO::getAuditOrderId).collect(Collectors.toList()));
                }
            });
            if (CollectionUtil.isNotEmpty(auditOrderIdList)) {
                UocOrderProcInstPO uocorderprocinstpo = new UocOrderProcInstPO();
                uocorderprocinstpo.setObjIdList(auditOrderIdList);
                this.uocOrderProcInstMapper.deleteBy(uocorderprocinstpo);
                UocOrderTaskInstPO uocordertaskinstpo = new UocOrderTaskInstPO();
                uocordertaskinstpo.setObjIdList(auditOrderIdList);
                this.uocOrderTaskInstMapper.deleteBy(uocordertaskinstpo);
                UocApprovalObjPO uocapprovalobjpo = new UocApprovalObjPO();
                uocapprovalobjpo.setAuditOrderIdList(auditOrderIdList);
                this.uocApprovalObjMapper.deleteBy(uocapprovalobjpo);
                UocAuditOrderPO uocauditorderpo = new UocAuditOrderPO();
                uocauditorderpo.setAuditOrderIdList(auditOrderIdList);
                this.uocAuditOrderMapper.deleteBy(uocauditorderpo);
            }
        }
    }
}

