package com.tydic.dyc.ssc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.ssc.repository.aop.BatchInsert;
import com.tydic.dyc.ssc.repository.po.SscSchemeHisExtPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：ssc_scheme_his_ext
 * 
 * @author auto_gen
 * @date 2023-03-13 17:30
 **/
@Mapper
@Repository
public interface SscSchemeHisExtMapper {

	/**
	 * 插入单条数据
	 *
	 * @param sscschemehisextpo 参数对象
	 * @return int 影响数量
	 */
	int insert(SscSchemeHisExtPO sscschemehisextpo);

	/**
	 * 根据条件删除数据
	 *
	 * @param sscschemehisextpo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(SscSchemeHisExtPO sscschemehisextpo);

	/**
	 * 根据主键更新数据
	 *
	 * @param sscschemehisextpo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(SscSchemeHisExtPO sscschemehisextpo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") SscSchemeHisExtPO set, @Param("where") SscSchemeHisExtPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param sscschemehisextpo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(SscSchemeHisExtPO sscschemehisextpo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param sscschemehisextpo 参数对象
	 * @return SscSchemeHisExtPO 结果对象
	 */
	SscSchemeHisExtPO getModelBy(SscSchemeHisExtPO sscschemehisextpo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param sscschemehisextpo 参数对象
	 * @return List<SscSchemeHisExtPO> 结果对象
	 */
	List<SscSchemeHisExtPO> getList(SscSchemeHisExtPO sscschemehisextpo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param sscschemehisextpo 参数对象
	 * @param page 分页参数
	 * @return List<SscSchemeHisExtPO> 结果对象
	 */
	List<SscSchemeHisExtPO> getListPage(SscSchemeHisExtPO sscschemehisextpo, Page<SscSchemeHisExtPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	/**
	 * 直接在Mapper方法上添加@BatchInsert注解
	 * 参数位置为0（第一个参数）
	 */
	@BatchInsert(batchSize = "${batch.insert.size:500}")
	void insertBatch(List<SscSchemeHisExtPO> list);

}
