package com.tydic.dyc.ssc.repository.aop;
import java.lang.annotation.*;

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface BatchInsert {
    /**
     * 批次大小，支持SpEL表达式
     * 可以直接写数字，也可以写配置表达式如 "${batch.insert.size}"
     */
    String batchSize() default "100";

    /**
     * 参数中集合参数的索引位置，默认为0（第一个参数）
     */
    int paramIndex() default 0;
}