package com.tydic.dyc.ssc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.ssc.repository.po.SscSchemePO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：采购方案
 * 
 * @author auto_gen
 * @date 2023-04-03 10:47
 **/
@Mapper
@Repository
public interface SscSchemeMapper {

	/**
	 * 插入单条数据
	 *
	 * @param sscschemepo 参数对象
	 * @return int 影响数量
	 */
	int insert(SscSchemePO sscschemepo);

	/**
	 * 根据条件删除数据
	 *
	 * @param sscschemepo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(SscSchemePO sscschemepo);

	/**
	 * 根据主键更新数据
	 *
	 * @param sscschemepo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(SscSchemePO sscschemepo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") SscSchemePO set, @Param("where") SscSchemePO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param sscschemepo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(SscSchemePO sscschemepo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param sscschemepo 参数对象
	 * @return SscSchemePO 结果对象
	 */
	SscSchemePO getModelBy(SscSchemePO sscschemepo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param sscschemepo 参数对象
	 * @return List<SscSchemePO> 结果对象
	 */
	List<SscSchemePO> getList(SscSchemePO sscschemepo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param sscschemepo 参数对象
	 * @param page 分页参数
	 * @return List<SscSchemePO> 结果对象
	 */
	List<SscSchemePO> getListPage(SscSchemePO sscschemepo, Page<SscSchemePO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<SscSchemePO> list);

}
