package com.tydic.dyc.ssc.repository.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.auditorder.SscAuditOrderDo;
import com.tydic.dyc.ssc.model.auditorder.qrybo.SscAuditOrderQryBo;
import com.tydic.dyc.ssc.model.auditorder.sub.UocApprovalObj;
import com.tydic.dyc.ssc.repository.SscAuditOrderRepository;
import com.tydic.dyc.ssc.repository.dao.*;
import com.tydic.dyc.ssc.repository.po.*;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题:SscAuditOrderRepositoryImpl
 * 说明:TODO
 * 时间:2022/9/2 11:59
 * 作者:代愿愿
 */
@Slf4j
@Service
public class SscAuditOrderRepositoryImpl implements SscAuditOrderRepository {

    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;

    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;

    @Autowired
    private SscSchemeMapper sscSchemeMapper;

    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;

    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;


    @Override
    public void saveAuditOrder(SscAuditOrderDo sscAuditOrderDo) {
        UocAuditOrderPO uocAuditOrderPO = SscRu.js(sscAuditOrderDo, UocAuditOrderPO.class);
        uocAuditOrderMapper.insert(uocAuditOrderPO);
        if(!CollectionUtils.isEmpty(sscAuditOrderDo.getUocApprovalObj())){
            List<UocApprovalObjPO> uocApprovalObjPOS = new ArrayList<>();
            sscAuditOrderDo.getUocApprovalObj().forEach(uocApprovalObj -> {
                UocApprovalObjPO po = SscRu.js(uocApprovalObj,UocApprovalObjPO.class);
                if (SscCommConstant.OBJ_BUSI_TYPE.SCHEME.equals(po.getObjBusiType())) {
                    // 查询方案版本信息
                    SscSchemePO where = new SscSchemePO();
                    where.setSchemeId(sscAuditOrderDo.getOrderId());
                    SscSchemePO schemePO = sscSchemeMapper.getModelBy(where);
                    if (ObjectUtil.isNull(schemePO)) {
                        log.error("方案信息为空, 方案id为: {}", po.getOrderId());
                    } else {
                        po.setObjVersion(schemePO.getSchemeVersion());
                    }
                }
                po.setAuditOrderId(sscAuditOrderDo.getAuditOrderId());
                po.setId(IdUtil.nextId());
                po.setOrderId(sscAuditOrderDo.getOrderId());
                po.setCreateTime(new Date());
                uocApprovalObjPOS.add(po);
            });
            uocApprovalObjMapper.insertBatch(uocApprovalObjPOS);
        }
    }

    @Override
    public SscAuditOrderDo getAuditObj(SscAuditOrderQryBo sscAuditOrderQryBo) {
        UocApprovalObjPO uocApprovalObjPO = SscRu.js(sscAuditOrderQryBo,UocApprovalObjPO.class) ;
        List<UocApprovalObjPO> pos =  uocApprovalObjMapper.getList(uocApprovalObjPO);
        List<UocApprovalObj> uocApprovalObj = SscRu.jsl(pos,UocApprovalObj.class);
        SscAuditOrderDo sscAuditOrderDo = new SscAuditOrderDo();
        sscAuditOrderDo.setUocApprovalObj(uocApprovalObj);
        return sscAuditOrderDo;
    }

    @Override
    public void deleteAuditObj(SscAuditOrderDo param0) {
        List<UocApprovalObj> objList = param0.getUocApprovalObj();
        if (CollectionUtil.isNotEmpty(objList)) {
            List<Long> auditOrderIdList = new ArrayList<>();
            objList.forEach(e -> {
                UocApprovalObjPO uocapprovalobjpo = new UocApprovalObjPO();
                uocapprovalobjpo.setObjId(e.getObjId());
                uocapprovalobjpo.setObjBusiType(e.getObjBusiType());
                uocapprovalobjpo.setObjVersion(e.getObjVersion());
                List<UocApprovalObjPO> list = this.uocApprovalObjMapper.getList(uocapprovalobjpo);
                if (CollectionUtil.isNotEmpty(list)) {
                    auditOrderIdList.addAll(list.stream().map(UocApprovalObjPO::getAuditOrderId).collect(Collectors.toList()));
                }
            });
            if (CollectionUtil.isNotEmpty(auditOrderIdList)) {
                // 删除流程实例
                UocOrderProcInstPO uocorderprocinstpo = new UocOrderProcInstPO();
                uocorderprocinstpo.setObjIdList(auditOrderIdList);
                this.uocOrderProcInstMapper.deleteBy(uocorderprocinstpo);

                // 删除任务实例
                UocOrderTaskInstPO uocordertaskinstpo = new UocOrderTaskInstPO();
                uocordertaskinstpo.setObjIdList(auditOrderIdList);
                this.uocOrderTaskInstMapper.deleteBy(uocordertaskinstpo);

                // 删除审批对象
                UocApprovalObjPO uocapprovalobjpo = new UocApprovalObjPO();
                uocapprovalobjpo.setAuditOrderIdList(auditOrderIdList);
                this.uocApprovalObjMapper.deleteBy(uocapprovalobjpo);

                // 删除审批单
                UocAuditOrderPO uocauditorderpo = new UocAuditOrderPO();
                uocauditorderpo.setAuditOrderIdList(auditOrderIdList);
                this.uocAuditOrderMapper.deleteBy(uocauditorderpo);
            }
        }
    }
}
