package com.tydic.dyc.ssc.repository.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.project.SscBidProjectDo;
import com.tydic.dyc.ssc.model.project.qrybo.*;
import com.tydic.dyc.ssc.model.project.sub.SscProjectChange;
import com.tydic.dyc.ssc.model.project.sub.SscProjectNotice;
import com.tydic.dyc.ssc.model.project.sub.SscQuotationItemAdd;
import com.tydic.dyc.ssc.model.project.sub.SscQuotationItemTemplate;
import com.tydic.dyc.ssc.repository.SscProjectRepository;
import com.tydic.dyc.ssc.repository.dao.*;
import com.tydic.dyc.ssc.repository.po.*;
import com.tydic.dyc.ssc.utils.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: SscProjectRepositoryImpl
 * @Author: the_xhl
 * @Date: 2022-12-27
 */
@Service
public class SscProjectRepositoryImpl implements SscProjectRepository {

    @Autowired
    private SscSchemeMapper sscSchemeMapper;

    @Autowired
    private SscBidProjectMapper sscBidProjectMapper;

    @Autowired
    private SscQuotationItemAddMapper sscQuotationItemAddMapper;

    @Autowired
    private SscQuotationItemTemplateMapper sscQuotationItemTemplateMapper;

    @Autowired
    private SscProjectNoticeMapper sscProjectNoticeMapper;

    @Autowired
    private SscProjectNoticeContentMapper sscProjectNoticeContentMapper;

    @Autowired
    private SscProjectChangeMapper sscProjectChangeMapper;

    @Override
    public void copyBidProjectFromScheme(SscBidProjectDo sscBidProjectDo) {
        // schemeId为入参查询采购方案表数据
        SscSchemePO where = new SscSchemePO();
        where.setSchemeId(sscBidProjectDo.getSchemeId());
        SscSchemePO sscSchemePO = sscSchemeMapper.getModelBy(where);
        if (ObjectUtil.isNull(sscSchemePO)) {
            throw new ZTBusinessException("方案查询为空!");
        }
        // TODO 将采购方案表对应字段往招标项目表复制
        SscBidProjectPO sscBidProjectPO = new SscBidProjectPO();
        sscBidProjectPO.setSchemeId(sscSchemePO.getSchemeId());
    }

    @Override
    public SscBidProjectDo qryQuotationItemTemplateLIst(SscBidProjectQryBo sscBidProjectQryBo) {
        if (ObjectUtil.isNull(sscBidProjectQryBo.getProjectId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_REPOSITORY_EMPTY_ERROR, "入参对象属性[projectId]为空");
        }
        SscQuotationItemTemplatePO sscQuotationItemTemplatePO = JUtil.js(sscBidProjectQryBo, SscQuotationItemTemplatePO.class);
        List<SscQuotationItemTemplatePO> templatePOList = sscQuotationItemTemplateMapper.getList(sscQuotationItemTemplatePO);
        List<SscQuotationItemTemplate> resultList = templatePOList.stream().map(e -> JUtil.js(e, SscQuotationItemTemplate.class)).collect(Collectors.toList());
        SscBidProjectDo rspBO = new SscBidProjectDo();
        rspBO.setSscQuotationItemTemplate(resultList);
        return rspBO;
    }

    @Override
    public SscBidProjectDo qryProjectNoticeDetail(SscBidProjectQryBo sscBidProjectQryBo) {
        if (ObjectUtil.isNull(sscBidProjectQryBo.getProjectId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_REPOSITORY_EMPTY_ERROR, "入参对象属性[projectId]不能为空");
        }
        SscBidProjectDo rsp = new SscBidProjectDo();
        // 根据公告id查询公告信息
        SscProjectNoticePO noticeWhere = new SscProjectNoticePO();
        noticeWhere.setNoticeId(sscBidProjectQryBo.getNoticeId());
        SscProjectNoticePO noticePO = sscProjectNoticeMapper.getModelBy(noticeWhere);
        SscProjectNotice sscProjectNotice = JUtil.js(noticePO, SscProjectNotice.class);

        // 根据公告id查询公告内容
        SscProjectNoticeContentPO contentWhere = new SscProjectNoticeContentPO();
        contentWhere.setNoticeId(noticePO.getNoticeId());
        SscProjectNoticeContentPO contentPO = sscProjectNoticeContentMapper.getModelBy(contentWhere);
        sscProjectNotice.setNoticeContent(contentPO.getNoticeContent());
        rsp.setSscProjectNotice(Collections.singletonList(sscProjectNotice));
        return rsp;
    }

    @Override
    public SscBidProjectDo qryProjectChangeList(SscBidProjectQryBo sscBidProjectQryBo) {
        if (ObjectUtil.isNull(sscBidProjectQryBo.getProjectId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_REPOSITORY_EMPTY_ERROR, "入参对象属性[projectId]不能为空");
        }
        if (ObjectUtil.isNull(sscBidProjectQryBo.getNoticeId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_REPOSITORY_EMPTY_ERROR, "入参对象属性[noticeId]不能为空");
        }
        SscProjectChangePO sscProjectChangePO = JUtil.js(sscBidProjectQryBo, SscProjectChangePO.class);
        List<SscProjectChangePO> poList = sscProjectChangeMapper.getList(sscProjectChangePO);
        List<SscProjectChange> sscProjectChangeList = poList.stream().map(e -> JUtil.js(e, SscProjectChange.class)).collect(Collectors.toList());
        SscBidProjectDo rspBO = new SscBidProjectDo();
        rspBO.setSscProjectChange(sscProjectChangeList);
        return rspBO;
    }

    @Override
    public SscBidProjectDo qryQuotationItemAddLIst(SscBidProjectQryBo sscBidProjectQryBo) {
        if (ObjectUtil.isNull(sscBidProjectQryBo.getProjectId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_REPOSITORY_EMPTY_ERROR, "入参对象属性[projectId]不能为空");
        }
        SscQuotationItemAddPO sscQuotationItemAddPO = JUtil.js(sscBidProjectQryBo, SscQuotationItemAddPO.class);
        List<SscQuotationItemAddPO> list = sscQuotationItemAddMapper.getList(sscQuotationItemAddPO);
        List<SscQuotationItemAdd> resultList = list.stream().map(e -> JUtil.js(e, SscQuotationItemAdd.class)).collect(Collectors.toList());
        SscBidProjectDo rspBO = new SscBidProjectDo();
        rspBO.setSscQuotationItemAdd(resultList);
        return rspBO;
    }

    @Override
    public void addQuotationItemAddBatch(SscBidProjectDo sscBidProjectDo) {
        if (ObjectUtil.isNotNull(sscBidProjectDo)) {
            List<SscQuotationItemAdd> sscQuotationItemAddList = sscBidProjectDo.getSscQuotationItemAdd();
            if (CollectionUtil.isNotEmpty(sscQuotationItemAddList)) {
                List<SscQuotationItemAddPO> addPOList = sscQuotationItemAddList.stream().map(e -> {
                    SscQuotationItemAddPO sscQuotationItemAddPO = BeanUtil.toBean(e, SscQuotationItemAddPO.class);
                    sscQuotationItemAddPO.setCreateLoginId(sscBidProjectDo.getUserId());
                    sscQuotationItemAddPO.setCreateUsername(sscBidProjectDo.getUsername());
                    sscQuotationItemAddPO.setCreateName(sscBidProjectDo.getName());
                    sscQuotationItemAddPO.setCreateTime(new Date());
                    sscQuotationItemAddPO.setId(IdUtil.nextId());
                    return sscQuotationItemAddPO;
                }).collect(Collectors.toList());
                sscQuotationItemAddMapper.insertBatch(addPOList);
            }
        }
    }

    @Override
    public void updateQuotationItemTemplateBatch(SscBidProjectDo sscBidProjectDo) {
        if (ObjectUtil.isNotNull(sscBidProjectDo)) {
            List<SscQuotationItemTemplate> templateList = sscBidProjectDo.getSscQuotationItemTemplate();
            if (CollectionUtil.isNotEmpty(templateList)) {
                templateList.forEach(e -> {
                    SscQuotationItemTemplatePO set = JSON.parseObject(JSON.toJSONString(e), SscQuotationItemTemplatePO.class);
                    set.setUpdateLoginId(sscBidProjectDo.getUserId());
                    set.setUpdateUsername(sscBidProjectDo.getUsername());
                    set.setUpdateName(sscBidProjectDo.getName());
                    set.setUpdateTime(new Date());
                    SscQuotationItemTemplatePO where = new SscQuotationItemTemplatePO();
                    where.setItemTemplateId(e.getItemTemplateId());
                    where.setPackId(e.getPackId());
                    where.setProjectId(sscBidProjectDo.getProjectId());
                    sscQuotationItemTemplateMapper.updateBy(set, where);
                });
            }
        }
    }

    @Override
    public void addQuotationItemTemplateBatch(SscBidProjectDo sscBidProjectDo) {
        if (ObjectUtil.isNotNull(sscBidProjectDo)) {
            List<SscQuotationItemTemplate> templateList = sscBidProjectDo.getSscQuotationItemTemplate();
            if (CollectionUtil.isNotEmpty(templateList)) {
                List<SscQuotationItemTemplatePO> poList = templateList.stream().map(e -> {
                    SscQuotationItemTemplatePO templatePO = JSON.parseObject(JSON.toJSONString(e), SscQuotationItemTemplatePO.class);
                    templatePO.setCreateLoginId(sscBidProjectDo.getUserId());
                    templatePO.setCreateUsername(sscBidProjectDo.getUsername());
                    templatePO.setCreateName(sscBidProjectDo.getName());
                    templatePO.setCreateTime(new Date());
                    templatePO.setItemTemplateId(IdUtil.nextId());
                    return templatePO;
                }).collect(Collectors.toList());
                sscQuotationItemTemplateMapper.insertBatch(poList);
            }
        }
    }
}
