/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.repository.aop;

import com.tydic.dyc.ssc.repository.aop.BatchInsert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class BatchInsertAspect {
    private static final Logger log = LoggerFactory.getLogger(BatchInsertAspect.class);
    private final Environment environment;

    public BatchInsertAspect(Environment environment) {
        this.environment = environment;
    }

    @Around(value="@annotation(batchInsert)")
    public Object aroundBatchInsert(ProceedingJoinPoint joinPoint, BatchInsert batchInsert) throws Throwable {
        log.error("BatchInsertAspect>\u8fdb\u5165\u5207\u9762");
        int batchSize = this.parseBatchSize(batchInsert.batchSize());
        log.error("BatchInsertAspect>\u6279\u6b21\u5927\u5c0f" + batchSize);
        Object[] args = joinPoint.getArgs();
        int paramIndex = batchInsert.paramIndex();
        this.validateParameters(paramIndex, args);
        Collection<?> collection = this.getCollectionParameter(args, paramIndex);
        if (CollectionUtils.isEmpty(collection)) {
            return joinPoint.proceed();
        }
        if (collection.size() <= batchSize) {
            return joinPoint.proceed();
        }
        return this.processInBatches(joinPoint, args, paramIndex, collection, batchSize);
    }

    private int parseBatchSize(String batchSizeExpression) {
        try {
            if (batchSizeExpression.startsWith("${") && batchSizeExpression.endsWith("}")) {
                String configKey = batchSizeExpression.substring(2, batchSizeExpression.length() - 1);
                if (configKey.contains(":")) {
                    String[] parts = configKey.split(":");
                    String key = parts[0].trim();
                    String defaultValue = parts[1].trim();
                    String value = this.environment.getProperty(key);
                    return value != null ? Integer.parseInt(value) : Integer.parseInt(defaultValue);
                }
                String value = this.environment.getProperty(configKey);
                if (value == null) {
                    throw new IllegalArgumentException("\u914d\u7f6e\u9879\u4e0d\u5b58\u5728: " + configKey);
                }
                return Integer.parseInt(value);
            }
            return Integer.parseInt(batchSizeExpression);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u6279\u6b21\u5927\u5c0f\u914d\u7f6e: " + batchSizeExpression, e);
        }
    }

    private void validateParameters(int paramIndex, Object[] args) {
        if (paramIndex < 0 || paramIndex >= args.length) {
            throw new IllegalArgumentException("\u53c2\u6570\u7d22\u5f15\u8d85\u51fa\u8303\u56f4");
        }
    }

    private Collection<?> getCollectionParameter(Object[] args, int paramIndex) {
        Object param = args[paramIndex];
        if (param instanceof Collection) {
            return (Collection)param;
        }
        throw new IllegalArgumentException("\u88ab@BatchInsert\u6ce8\u89e3\u7684\u53c2\u6570\u5fc5\u987b\u662fCollection\u7c7b\u578b");
    }

    private Object processInBatches(ProceedingJoinPoint joinPoint, Object[] args, int paramIndex, Collection<?> collection, int batchSize) throws Throwable {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<Object> batchList = new ArrayList<Object>(batchSize);
        log.error("BatchInsertAspect>\u8fdb\u5165\u5206\u6279\u5904\u7406");
        for (Object item : collection) {
            batchList.add(item);
            if (batchList.size() < batchSize) continue;
            log.error("BatchInsertAspect>\u8fdb\u5165\u5206\u6279\u5904\u7406>for\u5faa\u73af");
            Object batchResult = this.executeBatch(joinPoint, args, paramIndex, batchList);
            this.collectResult(result, batchResult);
            batchList.clear();
        }
        if (!batchList.isEmpty()) {
            log.error("BatchInsertAspect>\u8fdb\u5165\u5206\u6279\u5904\u7406>\u5904\u7406\u6700\u540e\u4e00\u6279");
            Object batchResult = this.executeBatch(joinPoint, args, paramIndex, batchList);
            this.collectResult(result, batchResult);
        }
        log.error("BatchInsertAspect>\u5904\u7406\u7ed3\u675f");
        return this.mergeResults(result);
    }

    private Object executeBatch(ProceedingJoinPoint joinPoint, Object[] originalArgs, int paramIndex, List<Object> batch) throws Throwable {
        Object[] newArgs = (Object[])originalArgs.clone();
        newArgs[paramIndex] = batch;
        return joinPoint.proceed(newArgs);
    }

    private void collectResult(List<Object> result, Object batchResult) {
        if (batchResult != null) {
            result.add(batchResult);
        }
    }

    private Object mergeResults(List<Object> results) {
        if (results.isEmpty()) {
            return null;
        }
        if (results.get(0) instanceof Integer) {
            return results.stream().mapToInt(r -> (Integer)r).sum();
        }
        if (results.get(0) instanceof Long) {
            return results.stream().mapToLong(r -> (Long)r).sum();
        }
        if (results.get(0) instanceof Boolean) {
            return results.stream().allMatch(r -> (Boolean)r);
        }
        return results.get(results.size() - 1);
    }
}

