package com.tydic.dyc.ssc.repository.impl;


import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.model.procinst.qrybo.SscTaskQryBo;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderProcInst;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderTaskDeal;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.ssc.repository.SscProcInstRepository;
import com.tydic.dyc.ssc.repository.dao.UocOrderProcInstMapper;
import com.tydic.dyc.ssc.repository.dao.UocOrderTaskDealMapper;
import com.tydic.dyc.ssc.repository.dao.UocOrderTaskInstMapper;
import com.tydic.dyc.ssc.repository.po.UocOrderProcInstPO;
import com.tydic.dyc.ssc.repository.po.UocOrderTaskDealPO;
import com.tydic.dyc.ssc.repository.po.UocOrderTaskInstPO;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:SscProcInstRepositoryImpl
 * 说明:TODO
 * 时间:2022/8/24 17:40
 * 作者:代愿愿
 */
@Service
public class SscProcInstRepositoryImpl implements SscProcInstRepository {

    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;

    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;

    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;

    @Override
    public SscProcInstDo getTaskList(SscTaskQryBo param0) {
        SscProcInstDo sscProcInstDo = new SscProcInstDo();
        List<UocOrderTaskInstPO> uocOrderTaskInstPOList = uocOrderTaskInstMapper.getList(SscRu.js(param0,UocOrderTaskInstPO.class));
        sscProcInstDo.setSscUocOrderTaskInst(SscRu.jsl(uocOrderTaskInstPOList, UocOrderTaskInst.class));
        return sscProcInstDo;
    }

    @Override
    public void updateTask(SscProcInstDo sscProcInstDo) {
        //获取任务实例
        List<UocOrderTaskInstPO> taskInstPOList = SscRu.jsl(sscProcInstDo.getSscUocOrderTaskInst(), UocOrderTaskInstPO.class);
        taskInstPOList.forEach(uocOrderTaskInstPO -> {
            //创建修改条件
            UocOrderTaskInstPO where = new UocOrderTaskInstPO();
            //设置任务实例id
            where.setTaskInstId(uocOrderTaskInstPO.getTaskInstId());
            //根据条件更新数据
            uocOrderTaskInstMapper.updateBy(uocOrderTaskInstPO,where);
        });
    }

    @Override
    public SscProcInstDo getProInst(SscProcInstDo sscProcInstDo) {
        UocOrderProcInstPO reqPo =  SscRu.js(sscProcInstDo,UocOrderProcInstPO.class);
        UocOrderProcInstPO rspPo =  uocOrderProcInstMapper.getModelBy(reqPo);
        return SscRu.js(rspPo, SscProcInstDo.class);
    }

    @Override
    public void saveProcInst(SscProcInstDo sscProcInstDo) {
        UocOrderProcInstPO uocOrderProcInstPO = SscRu.js(sscProcInstDo,UocOrderProcInstPO.class);
        uocOrderProcInstPO.setId(IdUtil.nextId());
        uocOrderProcInstPO.setCreateTime(sscProcInstDo.getOperTime());
        uocOrderProcInstMapper.insert(uocOrderProcInstPO);
    }

    @Override
    public void saveTask(SscProcInstDo sscProcInstDo) {
        if(!CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskInst())){
            List<UocOrderTaskInstPO> uocOrderTaskInstPOS =  new ArrayList<>();
            sscProcInstDo.getSscUocOrderTaskInst().forEach(uocOrderTaskInst -> {
                UocOrderTaskInstPO po = SscRu.js(uocOrderTaskInst,UocOrderTaskInstPO.class);
                po.setCreateTime(sscProcInstDo.getOperTime());
                po.setId(IdUtil.nextId());
                uocOrderTaskInstPOS.add(po);
            });
            uocOrderTaskInstMapper.insertBatch(uocOrderTaskInstPOS);
        }
        if(!CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskDeal())){
            List<UocOrderTaskDealPO> uocOrderTaskDealPOS = new ArrayList<>() ;
            sscProcInstDo.getSscUocOrderTaskDeal().forEach(uocOrderTaskDeal -> {
                UocOrderTaskDealPO po = SscRu.js(uocOrderTaskDeal,UocOrderTaskDealPO.class);
                po.setId(IdUtil.nextId());
                uocOrderTaskDealPOS.add(po);
            });
            uocOrderTaskDealMapper.insertBatch(uocOrderTaskDealPOS);
        }
    }

    @Override
    public void updateTaskDeal(SscProcInstDo sscProcInstDo) {
        if(!CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskDeal())){
            sscProcInstDo.getSscUocOrderTaskDeal().forEach(uocOrderTaskDeal -> {
                // where
                UocOrderTaskDealPO wherePo = new UocOrderTaskDealPO();
                wherePo.setTaskInstId(uocOrderTaskDeal.getTaskInstId());
                wherePo.setTaskInstIds(uocOrderTaskDeal.getTaskInstIds());
                wherePo.setOrderId(uocOrderTaskDeal.getOrderId());
                wherePo.setObjId(uocOrderTaskDeal.getObjId());
                // set
                UocOrderTaskDealPO setPo = new UocOrderTaskDealPO();
                setPo.setDealId(uocOrderTaskDeal.getDealId());
                setPo.setDealName(uocOrderTaskDeal.getDealName());
                setPo.setDealType(uocOrderTaskDeal.getDealType());
                setPo.setDealClass(uocOrderTaskDeal.getDealClass());
                uocOrderTaskDealMapper.updateBy(setPo,wherePo);
            });
        }

    }

    @Override
    public void deleteTask(SscProcInstDo sscProcInstDo) {
        if(!CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskInst())){
            sscProcInstDo.getSscUocOrderTaskInst().forEach(uocOrderTaskInst -> {
                UocOrderTaskInstPO uocOrderTaskInstPO = SscRu.js(uocOrderTaskInst,UocOrderTaskInstPO.class);
                uocOrderTaskInstMapper.deleteBy(uocOrderTaskInstPO);
            });
        }
    }

    @Override
    public SscProcInstDo getTaskDealList(SscProcInstDo sscProcInstDo) {
        if(!CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskDeal())){
            UocOrderTaskDealPO uocOrderTaskDealPO = SscRu.js(sscProcInstDo.getSscUocOrderTaskDeal().get(0),UocOrderTaskDealPO.class);
            List<UocOrderTaskDealPO> pos = uocOrderTaskDealMapper.getList(uocOrderTaskDealPO);
            if(!CollectionUtils.isEmpty(pos)){
                SscProcInstDo sscProcInstDo1 = new SscProcInstDo();
                sscProcInstDo1.setSscUocOrderTaskDeal(SscRu.jsl(pos, UocOrderTaskDeal.class));
                return sscProcInstDo1;
            }
        }
        return null;
    }

    @Override
    public void saveTaskLog(SscProcInstDo param0) {

    }

    @Override
    public SscProcInstDo getProInstList(SscProcInstDo sscProcInstDo) {
        SscProcInstDo sscProcInstDo1 = new SscProcInstDo();
        UocOrderProcInstPO uocOrderProcInstPO = SscRu.js(sscProcInstDo,UocOrderProcInstPO.class);
        uocOrderProcInstPO.setOrderBy("create_time desc");
        List<UocOrderProcInstPO> pos = uocOrderProcInstMapper.getList(uocOrderProcInstPO);
        if(!CollectionUtils.isEmpty(pos)){
            sscProcInstDo1.setSscUocOrderProcInst(SscRu.jsl(pos, UocOrderProcInst.class));
        }
        return sscProcInstDo1;
    }

}
