package com.tydic.dyc.ssc.repository.impl;

import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.repository.SscCommonRepository;
import com.tydic.dyc.ssc.repository.dao.*;
import com.tydic.dyc.ssc.repository.po.*;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:SscCommonRepositoryImpl
 * 说明:TODO
 * 时间:2023/3/13 11:16
 * 作者:代愿愿
 */
@Service
public class SscCommonRepositoryImpl implements SscCommonRepository {
    @Autowired
    private SscSchemeExtMapper sscSchemeExtMapper;
    @Autowired
    private SscSchemeMatExtMapper sscSchemeMatExtMapper;
    @Autowired
    private SscSchemePackExtMapper sscSchemePackExtMapper;
    @Autowired
    private SscSchemeInviteSupExtMapper sscSchemeInviteSupExtMapper;

    @Autowired
    private SscSchemeHisExtMapper sscSchemeHisExtMapper;

    @Autowired
    private SscSchemeMatHisExtMapper sscSchemeMatHisExtMapper;

    @Autowired
    private SscSchemePackHisExtMapper sscSchemePackHisExtMapper;

    @Autowired
    private SscSchemeInviteSupHisExtMapper sscSchemeInviteSupHisExtMapper;

    @Override
    public void addExtInfo(SscCommonDo sscCommonDo) {
        if (!CollectionUtils.isEmpty(sscCommonDo.getExtObjInfos())) {
            sscCommonDo.getExtObjInfos().forEach(sscExtObjInfo -> {
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT)) {
                    List<SscSchemeExtPO> sscSchemeExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeExtPO.class);
                    sscSchemeExtPOS.forEach(sscSchemeExtPO -> {
                        sscSchemeExtPO.setSchemeExtId(IdUtil.nextId());
                        sscSchemeExtPO.setSchemeId(sscExtObjInfo.getObjId());
                    });
                    sscSchemeExtMapper.insertBatch(sscSchemeExtPOS);
                }
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT)) {
                    List<SscSchemePackExtPO> sscSchemePackExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemePackExtPO.class);
                    sscSchemePackExtPOS.forEach(sscSchemePackExtPO -> {
                        sscSchemePackExtPO.setExtId(IdUtil.nextId());
                        sscSchemePackExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                        sscSchemePackExtPO.setPackId(sscExtObjInfo.getObjId());
                    });
                    sscSchemePackExtMapper.insertBatch(sscSchemePackExtPOS);
                }
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT)) {
                    List<SscSchemeMatExtPO> sscSchemeMatExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeMatExtPO.class);
                    sscSchemeMatExtPOS.forEach(sscSchemeMatExtPO -> {
                        sscSchemeMatExtPO.setSchemeMatExtId(IdUtil.nextId());
                        sscSchemeMatExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                        sscSchemeMatExtPO.setSchemeMatId(sscExtObjInfo.getObjId());
                    });
                    sscSchemeMatExtMapper.insertBatch(sscSchemeMatExtPOS);
                }
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT)) {
                    List<SscSchemeInviteSupExtPO> sscSchemeInviteSupExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeInviteSupExtPO.class);
                    sscSchemeInviteSupExtPOS.forEach(sscSchemeInviteSupExtPO -> {
                        sscSchemeInviteSupExtPO.setExtId(IdUtil.nextId());
                        sscSchemeInviteSupExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                        sscSchemeInviteSupExtPO.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                    });
                    sscSchemeInviteSupExtMapper.insertBatch(sscSchemeInviteSupExtPOS);
                }
            });
        }

    }

    @Override
    public void updateExtInfo(SscCommonDo sscCommonDo) {
        if (!CollectionUtils.isEmpty(sscCommonDo.getExtObjInfos())) {
            sscCommonDo.getExtObjInfos().forEach(sscExtObjInfo -> {
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeExtPO where = new SscSchemeExtPO();
                        where.setSchemeId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeExtPO set = new SscSchemeExtPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeExtMapper.updateBy(set, where);
                    });
                }
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemePackExtPO where = new SscSchemePackExtPO();
                        where.setPackId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemePackExtPO set = new SscSchemePackExtPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemePackExtMapper.updateBy(set, where);
                    });
                }
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeMatExtPO where = new SscSchemeMatExtPO();
                        where.setSchemeMatId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeMatExtPO set = new SscSchemeMatExtPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeMatExtMapper.updateBy(set, where);
                    });
                }
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeInviteSupExtPO where = new SscSchemeInviteSupExtPO();
                        where.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeInviteSupExtPO set = new SscSchemeInviteSupExtPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeInviteSupExtMapper.updateBy(set, where);
                    });
                }
            });
        }
    }

    @Override
    public void deleteExtInfo(SscCommonDo sscCommonDo) {
        if (!CollectionUtils.isEmpty(sscCommonDo.getExtObjInfos())) {
            sscCommonDo.getExtObjInfos().forEach(sscExtObjInfo -> {
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT)) {
                    SscSchemeExtPO where = new SscSchemeExtPO();
                    where.setSchemeId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeExtMapper.deleteBy(where);
                    }

                }
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT)) {
                    SscSchemePackExtPO where = new SscSchemePackExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setPackId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemePackExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemePackExtMapper.deleteBy(where);
                    }

                }
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT)) {
                    SscSchemeMatExtPO where = new SscSchemeMatExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeMatId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeMatExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeMatExtMapper.deleteBy(where);
                    }

                }
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT)) {
                    SscSchemeInviteSupExtPO where = new SscSchemeInviteSupExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeInviteSupExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeInviteSupExtMapper.deleteBy(where);
                    }
                }
            });
        }
    }

    @Override
    public SscCommonDo qryExtInfo(SscCommonDo sscCommonDo) {
        SscCommonDo commonDo = new SscCommonDo();
        if (!CollectionUtils.isEmpty(sscCommonDo.getExtObjInfos())) {
            List<SscExtObjInfo> infoList = new ArrayList<>();
            sscCommonDo.getExtObjInfos().forEach(e -> {
                SscExtObjInfo sscExtObjInfo = new SscExtObjInfo();
                sscExtObjInfo.setObjId(e.getObjId());
                sscExtObjInfo.setOrderId(e.getOrderId());
                sscExtObjInfo.setObjType(e.getObjType());

                String objType = e.getObjType();
                switch (objType) {
                    // 方案扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT:
                        SscSchemeExtPO schemeExtPO = new SscSchemeExtPO();
                        schemeExtPO.setSchemeId(e.getObjId());
                        List<SscSchemeExtPO> schemeExtPOList = sscSchemeExtMapper.getList(schemeExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(schemeExtPOList, SscExtInfo.class));
                        break;
                    // 标段扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT:
                        SscSchemePackExtPO schemePackExtPO = new SscSchemePackExtPO();
                        schemePackExtPO.setSchemeId(e.getOrderId());
                        schemePackExtPO.setPackId(e.getObjId());
                        List<SscSchemePackExtPO> packExtPOS = sscSchemePackExtMapper.getList(schemePackExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(packExtPOS, SscExtInfo.class));
                        break;
                    // 物料明细扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT:
                        SscSchemeMatExtPO schemeMatExtPO = new SscSchemeMatExtPO();
                        schemeMatExtPO.setSchemeId(e.getOrderId());
                        schemeMatExtPO.setSchemeMatId(e.getObjId());
                        List<SscSchemeMatExtPO> matExtPOList = sscSchemeMatExtMapper.getList(schemeMatExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(matExtPOList, SscExtInfo.class));
                        break;
                    // 供应商扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT:
                        SscSchemeInviteSupExtPO supExtPO = new SscSchemeInviteSupExtPO();
                        supExtPO.setSchemeId(e.getOrderId());
                        supExtPO.setSchemeInviteSupId(e.getObjId());
                        List<SscSchemeInviteSupExtPO> supExtPOList = sscSchemeInviteSupExtMapper.getList(supExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(supExtPOList, SscExtInfo.class));
                        break;
                    // 方案历史扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_HIS_EXT:
                        SscSchemeHisExtPO schemeHisExtPO = new SscSchemeHisExtPO();
                        schemeHisExtPO.setSchemeId(e.getOrderId());
                        schemeHisExtPO.setSchemeHisId(e.getObjId());
                        List<SscSchemeHisExtPO> schemeHisExtPOList = sscSchemeHisExtMapper.getList(schemeHisExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(schemeHisExtPOList, SscExtInfo.class));
                        break;
                    // 标段历史扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_HIS_EXT:
                        SscSchemePackHisExtPO schemePackHisExtPO = new SscSchemePackHisExtPO();
                        schemePackHisExtPO.setSchemeId(e.getOrderId());
                        schemePackHisExtPO.setPackHisId(e.getObjId());
                        List<SscSchemePackHisExtPO> packHisExtPOList = sscSchemePackHisExtMapper.getList(schemePackHisExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(packHisExtPOList, SscExtInfo.class));
                        break;
                    // 物料明细历史扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_HIS_EXT:
                        SscSchemeMatHisExtPO schemeMatHisExtPO = new SscSchemeMatHisExtPO();
                        schemeMatHisExtPO.setSchemeId(e.getOrderId());
                        schemeMatHisExtPO.setSchemeMatHisId(e.getObjId());
                        List<SscSchemeMatHisExtPO> matHisExtPOList = sscSchemeMatHisExtMapper.getList(schemeMatHisExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(matHisExtPOList, SscExtInfo.class));
                        break;
                    // 供应商历史扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_HIS_EXT:
                        SscSchemeInviteSupHisExtPO schemeInviteSupHisExtPO = new SscSchemeInviteSupHisExtPO();
                        schemeInviteSupHisExtPO.setSchemeId(e.getOrderId());
                        schemeInviteSupHisExtPO.setSchemeInviteSupHisId(e.getObjId());
                        List<SscSchemeInviteSupHisExtPO> supHisExtPOList = sscSchemeInviteSupHisExtMapper.getList(schemeInviteSupHisExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(supHisExtPOList, SscExtInfo.class));
                        break;
                    default:
                        break;
                }
                infoList.add(sscExtObjInfo);
            });
            commonDo.setExtObjInfos(infoList);
        }
        return commonDo;
    }
}
