package com.tydic.dyc.ssc.repository.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.*;
import com.tydic.dyc.ssc.model.scheme.sub.*;
import com.tydic.dyc.ssc.repository.SscSchemeRepository;
import com.tydic.dyc.ssc.repository.dao.*;
import com.tydic.dyc.ssc.repository.po.*;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeBO;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:SscSchemeRepositoryImpl
 * 说明:采购方案基建层
 * 时间:2022/11/10 10:29
 * 作者:罗有
 */

@Service
public class SscSchemeRepositoryImpl implements SscSchemeRepository {
    @Autowired
    private SscSchemeMatDraftMapper sscSchemeMatDraftMapper;

    @Autowired
    private SscSchemePackMapper sscSchemePackMapper;

    @Autowired
    private SscAccessoryMapper sscAccessoryMapper;

    @Autowired
    private SscSchemeDraftMapper sscSchemeDraftMapper;

    @Autowired
    private SscSchemePackDraftMapper sscSchemePackDraftMapper;

    @Autowired
    private SscSchemeMapper sscSchemeMapper;

    @Autowired
    private SscSchemeMatMapper sscSchemeMatMapper;

    @Autowired
    private SscSchemeInviteSupMapper sscSchemeInviteSupMapper;

    @Autowired
    private SscSchemeInviteDraftMapper sscSchemeInviteDraftMapper;

    @Autowired
    private SscSchemeMatMapperUns sscSchemeMatMapperUns;

    @Autowired
    private SscSchemeInviteSupMapperUns sscSchemeInviteSupMapperUns;

    @Autowired
    private SscSchemeAcceptRecordMapper sscSchemeAcceptRecordMapper;

    @Autowired
    private SscSchemeEntrustRecordMapper sscSchemeEntrustRecordMapper;

    @Autowired
    private SscSchemeMapperUns sscSchemeMapperUns;

    @Autowired
    private SscSchemePackMapperUns sscSchemePackMapperUns;

    @Autowired
    private SscSchemeHisMapper sscSchemeHisMapper;

    @Autowired
    private SscSchemeMatHisMapper sscSchemeMatHisMapper;

    @Autowired
    private SscSchemePackHisMapper sscSchemePackHisMapper;

    @Autowired
    private SscSchemeInviteSupHisMapper sscSchemeInviteSupHisMapper;

    @Autowired
    private SscSchemeStatusChngMapper sscSchemeStatusChngMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;

    @Override
    public SscQrySchemeMatListRspBO qrySchemeMatList(SscQrySchemeMatListReqBO reqPageBo) {
        SscQrySchemeMatListRspBO sscQrySchemeMatListRspBO = new SscQrySchemeMatListRspBO();
        Page<?> pg;
        List<SchemeMatBO> SchemeMatBOs;
        if (ObjectUtil.isNotNull(reqPageBo.getSchemeHisId())) {
            // 查历史
            pg = new Page<SscSchemeMatHisPO>(reqPageBo.getPageNo(), reqPageBo.getPageSize());
            SscSchemeMatHisPO sscSchemeMatDraftPO = SscRu.js(reqPageBo, SscSchemeMatHisPO.class);
            List<SscSchemeMatHisPO> listPage = this.sscSchemeMatHisMapper.getListPage(sscSchemeMatDraftPO, (Page<SscSchemeMatHisPO>) pg);
            SchemeMatBOs = SscRu.jsl(listPage, SchemeMatBO.class);
        } else {
            //判断如果入参enableDraft=true则查询方案物料信息草稿表
            if (reqPageBo.getEnableDraft()) {
                pg = new Page<SscSchemeMatDraftPO>(reqPageBo.getPageNo(), reqPageBo.getPageSize());
                SscSchemeMatDraftPO sscSchemeMatDraftPO = SscRu.js(reqPageBo, SscSchemeMatDraftPO.class);
                List<SscSchemeMatDraftPO> listPage = this.sscSchemeMatDraftMapper.getListPage(sscSchemeMatDraftPO, (Page<SscSchemeMatDraftPO>) pg);
                SchemeMatBOs = SscRu.jsl(listPage, SchemeMatBO.class);
            } else {
                //判断如果入参enableDraft=false则查询方案物料信息表
                pg = new Page<SscSchemeMatPO>(reqPageBo.getPageNo(), reqPageBo.getPageSize());
                SscSchemeMatPO sscSchemeMatPO = SscRu.js(reqPageBo, SscSchemeMatPO.class);
                List<SscSchemeMatPO> listPage = this.sscSchemeMatMapper.getListPage(sscSchemeMatPO, (Page<SscSchemeMatPO>) pg);
                SchemeMatBOs = SscRu.jsl(listPage, SchemeMatBO.class);
            }
        }
        sscQrySchemeMatListRspBO.setRows(SchemeMatBOs);
        sscQrySchemeMatListRspBO.setPageNo(pg.getPageNo());
        sscQrySchemeMatListRspBO.setTotal(pg.getTotalPages());
        sscQrySchemeMatListRspBO.setRecordsTotal(pg.getTotalCount());
        return sscQrySchemeMatListRspBO;
    }

    @Override
    public SscSchemeDo qrySchemeMainInfo(SscSchemeQryBo sscSchemeQryBo0) {
        if (Boolean.TRUE.equals(sscSchemeQryBo0.getEnableDraft())) {
            SscSchemeDraftPO sscSchemeDraftPO = new SscSchemeDraftPO();
            sscSchemeDraftPO.setSchemeId(sscSchemeQryBo0.getSchemeId());
            SscSchemeDraftPO modelBy = sscSchemeDraftMapper.getModelBy(sscSchemeDraftPO);
            return SscRu.js(modelBy, SscSchemeDo.class);
        }
        SscSchemePO sscSchemePO = new SscSchemePO();
        sscSchemePO.setSchemeId(sscSchemeQryBo0.getSchemeId());
        SscSchemePO modelBy = sscSchemeMapper.getModelBy(sscSchemePO);
        return SscRu.js(modelBy, SscSchemeDo.class);
    }

    @Override
    public void addScheme(SscSchemeDo sscSchemeDo) {
        SscSchemePO po = SscRu.js(sscSchemeDo, SscSchemePO.class);
        po.setCreateName(sscSchemeDo.getName());
        po.setCreateUsername(sscSchemeDo.getUsername());
        po.setCreateLoginId(sscSchemeDo.getUserId());
        po.setCreateTime(sscSchemeDo.getOperTime());
        po.setCreateOrgId(sscSchemeDo.getOrgId());
        po.setCreateOrgName(sscSchemeDo.getOrgName());
        po.setCreateOrgPath(sscSchemeDo.getOrgPath());
        // 设置版本号
        po.setSchemeVersion("v1.0.0");
        sscSchemeMapper.insert(po);
        List<SscSchemePackPO> sscSchemePackPOS = SscRu.jsl(sscSchemeDo.getSscSchemePack(), SscSchemePackPO.class);
        if (CollectionUtil.isNotEmpty(sscSchemePackPOS)) {
            for (SscSchemePackPO packPO : sscSchemePackPOS) {
                packPO.setCreateName(sscSchemeDo.getName());
                packPO.setCreateUsername(sscSchemeDo.getUsername());
                packPO.setCreateLoginId(sscSchemeDo.getUserId());
                packPO.setCreateTime(sscSchemeDo.getOperTime());
                packPO.setCreateOrgId(sscSchemeDo.getOrgId());
                packPO.setCreateOrgName(sscSchemeDo.getOrgName());
            }
            sscSchemePackMapper.insertBatch(sscSchemePackPOS);
        }
        // 新增附件信息
        List<SscAccessoryPO> accessoryPOList = SscRu.jsl(sscSchemeDo.getSscAccessory(), SscAccessoryPO.class);
        if (CollectionUtil.isNotEmpty(accessoryPOList)) {
            accessoryPOList.forEach(e -> {
                e.setObjId(sscSchemeDo.getSchemeId());
                e.setOrderId(sscSchemeDo.getSchemeId());
                e.setAccessoryId(String.valueOf(IdUtil.nextId()));
                e.setId(IdUtil.nextId());
                e.setObjType(1);
                e.setCreateName(sscSchemeDo.getName());
                e.setCreateTime(new Date());
                e.setCreateLoginId(sscSchemeDo.getUserId());
                e.setCreateUsername(sscSchemeDo.getUsername());
            });
            sscAccessoryMapper.insertBatch(accessoryPOList);
        }
    }

    @Override
    public void updateScheme(SscSchemeDo sscSchemeDo0) {
        //根据方案ID更新方案主体信息
        SscSchemePO setPo = SscRu.js(sscSchemeDo0, SscSchemePO.class);
        SscSchemePO wherePo = new SscSchemePO();
        wherePo.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemeMapper.updateBy(setPo, wherePo);
        //根据方案ID删除方案包
        SscSchemePackPO deletePo = new SscSchemePackPO();
        deletePo.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemePackMapper.deleteBy(deletePo);
        //批量新增方案包
        List<SscSchemePackPO> sscSchemePackPOS = SscRu.jsl(sscSchemeDo0.getSscSchemePack(), SscSchemePackPO.class);
        if (CollectionUtil.isNotEmpty(sscSchemePackPOS)) {
            for (SscSchemePackPO po : sscSchemePackPOS) {
                po.setUpdateLoginId(sscSchemeDo0.getUserId());
                po.setUpdateName(sscSchemeDo0.getName());
                po.setUpdateUsername(sscSchemeDo0.getUsername());
                po.setUpdateTime(sscSchemeDo0.getOperTime());
            }
            sscSchemePackMapper.insertBatch(sscSchemePackPOS);
        }
        // 根据方案id删除附件信息
        SscAccessoryPO accessoryDelPO = new SscAccessoryPO();
        accessoryDelPO.setObjId(sscSchemeDo0.getSchemeId());
        sscAccessoryMapper.deleteBy(accessoryDelPO);
        List<SscAccessory> sscAccessory = sscSchemeDo0.getSscAccessory();
        // 批量新增附件信息
        insertAccessory(sscSchemeDo0.getSchemeId(), sscSchemeDo0.getSchemeId(), sscSchemeDo0, sscAccessory);

    }

    @Override
    public void addSchemeMatBatch(SscSchemeDo sscSchemeDo0) {

        //判断如果入参enableDraft=true则批量插入方案物料信息草稿表
        if (sscSchemeDo0.getEnableDraft()) {
            List<SscSchemeMatDraftPO> list = SscRu.jsl(sscSchemeDo0.getSscSchemeMat(), SscSchemeMatDraftPO.class);
            if (list.size() > 0) {
                list.forEach(sscSchemeMatDraftPO -> {
                    sscSchemeMatDraftPO.setSchemeMatId(IdUtil.nextId());
                    sscSchemeMatDraftPO.setCreateName(sscSchemeDo0.getName());
                    sscSchemeMatDraftPO.setSchemeId(sscSchemeDo0.getSchemeId());
                    sscSchemeMatDraftPO.setCreateLoginId(sscSchemeDo0.getUserId());
                    sscSchemeMatDraftPO.setCreateUsername(sscSchemeDo0.getUsername());
                    sscSchemeMatDraftPO.setCreateOrgId(sscSchemeDo0.getOrgId());
                    sscSchemeMatDraftPO.setCreateOrgName(sscSchemeDo0.getOrgName());
                    sscSchemeMatDraftPO.setToken(sscSchemeDo0.getToken());
                });
                sscSchemeMatDraftMapper.insertBatch(list);
            }
        } else {
            if (Boolean.TRUE.equals(sscSchemeDo0.getDelAddFlag())) {
                // 删除方案id下所有物料
                SscSchemeMatPO delete = new SscSchemeMatPO();
                delete.setSchemeId(sscSchemeDo0.getSchemeId());
                sscSchemeMatMapper.deleteBy(delete);
            }
            //判断如果入参enableDraft=false则批量插入方案物料信息表
            List<SscSchemeMatPO> list = SscRu.jsl(sscSchemeDo0.getSscSchemeMat(), SscSchemeMatPO.class);
            if (list.size() > 0) {
                list.forEach(sscSchemeMatPO -> {
                    sscSchemeMatPO.setSchemeMatId(IdUtil.nextId());
                    sscSchemeMatPO.setCreateName(sscSchemeDo0.getName());
                    sscSchemeMatPO.setSchemeId(sscSchemeDo0.getSchemeId());
                    sscSchemeMatPO.setCreateLoginId(sscSchemeDo0.getUserId());
                    sscSchemeMatPO.setCreateUsername(sscSchemeDo0.getUsername());
                    sscSchemeMatPO.setCreateOrgId(sscSchemeDo0.getOrgId());
                    sscSchemeMatPO.setCreateOrgName(sscSchemeDo0.getOrgName());
                });
                sscSchemeMatMapper.insertBatch(list);
            }
        }
    }

    @Override
    public SscQrySchemeInviteSupListRspBO qrySchemeInviteSupList(SscQrySchemeInviteSupListReqBO reqBO) {
        SscQrySchemeInviteSupListRspBO rspBO = SscRu.success(SscQrySchemeInviteSupListRspBO.class);
        Page<?> page = null;
        List<SchemeInviteSupBO> rows = null;
        // 查询历史
        if (ObjectUtil.isNotNull(reqBO.getSchemeHisId())) {
            SscSchemeInviteSupHisPO inviteSupPO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeInviteSupHisPO.class);
            page = new Page<SscSchemeInviteSupHisPO>();
            page.setPageNo(reqBO.getPageNo());
            page.setPageSize(reqBO.getPageSize());
            List<SscSchemeInviteSupHisPO> listPage = sscSchemeInviteSupHisMapper.getListPage(inviteSupPO, (Page<SscSchemeInviteSupHisPO>) page);
            rows = JSON.parseArray(JSON.toJSONString(listPage), SchemeInviteSupBO.class);
        } else {
            if (reqBO.getEnableDraft()) {
                SscSchemeInviteDraftPO inviteSupPO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeInviteDraftPO.class);
                page = new Page<SscSchemeInviteDraftPO>();
                page.setPageNo(reqBO.getPageNo());
                page.setPageSize(reqBO.getPageSize());
                // 查询草稿
                List<SscSchemeInviteDraftPO> listPage = sscSchemeInviteDraftMapper.getListPage(inviteSupPO, (Page<SscSchemeInviteDraftPO>) page);
                if (ObjectUtil.isNotEmpty(listPage)) {
                    rows = JSON.parseArray(JSON.toJSONString(listPage), SchemeInviteSupBO.class);

                }
            } else {
                SscSchemeInviteSupPO inviteSupPO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeInviteSupPO.class);
                page = new Page<SscSchemeInviteSupPO>();
                page.setPageNo(reqBO.getPageNo());
                page.setPageSize(reqBO.getPageSize());
                List<SscSchemeInviteSupPO> listPage = sscSchemeInviteSupMapper.getListPage(inviteSupPO, (Page<SscSchemeInviteSupPO>) page);
                if (ObjectUtil.isNotEmpty(listPage)) {
                    rows = JSON.parseArray(JSON.toJSONString(listPage), SchemeInviteSupBO.class);
                }
            }
        }
        rspBO.setRows(rows);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(reqBO.getPageNo());
        return rspBO;
    }

    @Override
    public void copyScheme(SscSchemeDo sscSchemeDo) {
        //根据方案ID删除方案物料主表数据
        SscSchemeMatPO deleteMatPo = new SscSchemeMatPO();
        deleteMatPo.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatMapper.deleteBy(deleteMatPo);
        //执行insert select 语句，根据方案ID将数据直接从物料草稿表写入主表
        SscSchemeQryBo insertMatPo = new SscSchemeQryBo();
        insertMatPo.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatMapperUns.insertSelect(insertMatPo);
        //	根据方案ID删除物料草稿表数据
        SscSchemeMatDraftPO deleteMatDraftPo = new SscSchemeMatDraftPO();
        deleteMatDraftPo.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatDraftMapper.deleteBy(deleteMatDraftPo);

        //根据方案ID删除受邀供应商主表数据
        SscSchemeInviteSupPO deleteSupPo = new SscSchemeInviteSupPO();
        deleteSupPo.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteSupMapper.deleteBy(deleteSupPo);

        //执行insert select语句，根据方案ID将受邀供应商草稿表数据写入受邀供应商主表
        SscSchemeQryBo insertSupPo = new SscSchemeQryBo();
        insertSupPo.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteSupMapperUns.insertSelect(insertSupPo);
        //根据方案ID删除受邀供应商草稿表数据
        SscSchemeInviteDraftPO deleteDraftPo = new SscSchemeInviteDraftPO();
        deleteDraftPo.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteDraftMapper.deleteBy(deleteDraftPo);


    }

    @Override
    public void deleteSchemeMatBatch(SscSchemeDo sscSchemeDo0) {
        //判断如果入参enableDraft=true则根据token字段删除方案物料信息草稿表
        List<SscSchemeMat> sscSchemeMat = sscSchemeDo0.getSscSchemeMat();
        List<Long> packIds = null;
        List<Long> schemeMatIds = null;
        if (CollectionUtil.isNotEmpty(sscSchemeMat)) {
            packIds = sscSchemeMat.stream().map(SscSchemeMat::getPackId).collect(Collectors.toList());
            schemeMatIds = sscSchemeMat.stream().map(SscSchemeMat::getSchemeMatId).collect(Collectors.toList());
        }
        if (sscSchemeDo0.getEnableDraft()) {
            SscSchemeMatDraftPO sscSchemeMatDraftPO = new SscSchemeMatDraftPO();
            sscSchemeMatDraftPO.setSchemeId(sscSchemeDo0.getSchemeId());
            sscSchemeMatDraftPO.setSchemeMatIds(schemeMatIds);
            sscSchemeMatDraftPO.setPackIds(packIds);
            sscSchemeMatDraftPO.setToken(sscSchemeDo0.getToken());
            this.sscSchemeMatDraftMapper.deleteBy(sscSchemeMatDraftPO);
        } else {
            // 删除主表物料信息
            SscSchemeMatPO sscSchemeMatPO = new SscSchemeMatPO();
            sscSchemeMatPO.setSchemeId(sscSchemeDo0.getSchemeId());
            sscSchemeMatPO.setSchemeMatIds(schemeMatIds);
            sscSchemeMatPO.setPackIds(packIds);
            this.sscSchemeMatMapper.deleteBy(sscSchemeMatPO);

        }
    }

    @Override
    public SscSchemeDo qrySchemePlanList(SscSchemeQryBo sscSchemeQryBo0) {
        List<SscSchemeMatPO> planList = sscSchemeMatMapperUns.getPlanList(sscSchemeQryBo0);
        List<SscSchemeMat> sscSchemeMats = SscRu.jsl(planList, SscSchemeMat.class);
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setSscSchemeMat(sscSchemeMats);
        return sscSchemeDo;
    }

    @Override
    public void addSchemeInviteSupBatch(SscSchemeDo sscSchemeDo0) {
        List<SscSchemeInviteSup> sscSchemeInviteSup = sscSchemeDo0.getSscSchemeInviteSup();
        if (sscSchemeDo0.getEnableDraft()) {
            //插入sscSchemeInviteDraft表
            List<SscSchemeInviteDraftPO> sscSchemeInviteDraftPOList = new ArrayList<>();
            for (SscSchemeInviteSup sscSchemeInviteSup1 : sscSchemeInviteSup) {
                SscSchemeInviteDraftPO sscSchemeInviteDraftPO = new SscSchemeInviteDraftPO();
                BeanUtils.copyProperties(sscSchemeInviteSup1, sscSchemeInviteDraftPO);
                sscSchemeInviteDraftPO.setSchemeInviteSupId(IdUtil.nextId());
                sscSchemeInviteDraftPO.setSchemeId(sscSchemeDo0.getSchemeId());
                sscSchemeInviteDraftPO.setToken(sscSchemeDo0.getToken());
                sscSchemeInviteDraftPOList.add(sscSchemeInviteDraftPO);
            }
            sscSchemeInviteDraftMapper.insertBatch(sscSchemeInviteDraftPOList);
        } else {
            if (Boolean.TRUE.equals(sscSchemeDo0.getDelAddFlag())) {
                // 删除方案id下的所有供应商
                SscSchemeInviteSupPO delete = new SscSchemeInviteSupPO();
                delete.setSchemeId(sscSchemeDo0.getSchemeId());
                sscSchemeInviteSupMapper.deleteBy(delete);
            }

            //插入sscSchemeInviteSup表
            List<SscSchemeInviteSupPO> sscSchemeInviteSupPOlist = new ArrayList<>();
            for (SscSchemeInviteSup sscSchemeInviteSup1 : sscSchemeInviteSup) {
                SscSchemeInviteSupPO sscSchemeInviteSupPO = new SscSchemeInviteSupPO();
                BeanUtils.copyProperties(sscSchemeInviteSup1, sscSchemeInviteSupPO);
                sscSchemeInviteSupPO.setSchemeId(sscSchemeDo0.getSchemeId());
                long schemeInviteSupId = IdUtil.nextId();
                sscSchemeInviteSupPO.setSchemeInviteSupId(schemeInviteSupId);
                sscSchemeInviteSupPOlist.add(sscSchemeInviteSupPO);

            }
            sscSchemeInviteSupMapper.insertBatch(sscSchemeInviteSupPOlist);

        }
    }

    @Override
    public void deleteSchemeInviteSupBatch(SscSchemeDo reqBO) {

        // 所有方案邀请供应商
        List<SscSchemeInviteSup> sscSchemeInviteSupList = reqBO.getSscSchemeInviteSup();

        if (reqBO.getEnableDraft()) {
            if (ObjectUtil.isNotEmpty(sscSchemeInviteSupList)) {
                // 删除方案邀请供应商草稿表
                SscSchemeInviteDraftPO draftPO = SscRu.js(reqBO, SscSchemeInviteDraftPO.class);
                // 把外层的token放到删除的where条件里去
                draftPO.setToken(reqBO.getToken());
                sscSchemeInviteDraftMapper.deleteBy(draftPO);
            }
        } else {
            if (ObjectUtil.isNotEmpty(sscSchemeInviteSupList)) {
                // 删除方案邀请供应商信息表
                List<Long> schemeInviteSupIds = new ArrayList<>();
                // 把外层的schemeId 和sscSchemeInviteSup里的 schemeInviteSupId 组装到一个List中
                schemeInviteSupIds.add(reqBO.getSchemeId());

                SscSchemeInviteSupPO schemeInviteSupPO = SscRu.js(reqBO, SscSchemeInviteSupPO.class);
                sscSchemeInviteSupList.forEach(sscSchemeInviteSup -> {
                    schemeInviteSupIds.add(sscSchemeInviteSup.getSchemeInviteSupId());
                });
                schemeInviteSupPO.setSchemeInviteSupIds(schemeInviteSupIds);
                sscSchemeInviteSupMapper.deleteBy(schemeInviteSupPO);
            }
        }
    }

    @Override
    public void deleteScheme(SscSchemeDo sscSchemeDo0) {
        //删除方案草稿表
        SscSchemeDraftPO draftPO = new SscSchemeDraftPO();
        draftPO.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemeDraftMapper.deleteBy(draftPO);
        //删除方案表
        SscSchemePO schemePO = new SscSchemePO();
        schemePO.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemeMapper.deleteBy(schemePO);
        //删除物料草稿
        SscSchemeMatDraftPO matDraftPO = new SscSchemeMatDraftPO();
        matDraftPO.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemeMatDraftMapper.deleteBy(matDraftPO);
        //删除物料
        SscSchemeMatPO matPO = new SscSchemeMatPO();
        matPO.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemeMatMapper.deleteBy(matPO);
        //删除方案包草稿
        SscSchemePackDraftPO packDraftPO = new SscSchemePackDraftPO();
        packDraftPO.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemePackDraftMapper.deleteBy(packDraftPO);
        //删除方案包
        SscSchemePackPO packPO = new SscSchemePackPO();
        packPO.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemePackMapper.deleteBy(packPO);
        //删除受邀供应商草稿
        SscSchemeInviteDraftPO inviteDraftPO = new SscSchemeInviteDraftPO();
        inviteDraftPO.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemeInviteDraftMapper.deleteBy(inviteDraftPO);
        //删除受邀供应商
        SscSchemeInviteSupPO inviteSupPO = new SscSchemeInviteSupPO();
        inviteSupPO.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemeInviteSupMapper.deleteBy(inviteSupPO);
        //删除方案受理记录
        SscSchemeAcceptRecordPO acceptRecordPO = new SscSchemeAcceptRecordPO();
        acceptRecordPO.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemeAcceptRecordMapper.deleteBy(acceptRecordPO);
    }

    @Override
    public SscSchemeDo qrySchemeDetail(SscSchemeQryBo sscSchemeQryBo0) {
        //查询方案表
        SscSchemeDo sscSchemeDo;
        SscAccessoryPO sscAccessoryPO = new SscAccessoryPO();
        // 查历史
        if (ObjectUtil.isNotNull(sscSchemeQryBo0.getSchemeHisId())) {
            // 查询方案历史信息
            SscSchemeHisPO schemeHisPOWhere = new SscSchemeHisPO();
            schemeHisPOWhere.setSchemeHisId(sscSchemeQryBo0.getSchemeHisId());
            SscSchemeHisPO schemeHisPO = sscSchemeHisMapper.getModelBy(schemeHisPOWhere);
            sscSchemeDo = SscRu.js(schemeHisPO, SscSchemeDo.class);
            if (ObjectUtil.isNull(schemeHisPO)) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_QUERY_SCHEME_ERROR, "方案历史查询为空");
            }
            // 查询方案包历史信息
            SscSchemePackHisPO packHisPOWhere = new SscSchemePackHisPO();
            packHisPOWhere.setSchemeHisId(sscSchemeQryBo0.getSchemeHisId());
            List<SscSchemePackHisPO> hisPOList = sscSchemePackHisMapper.getList(packHisPOWhere);
            sscSchemeDo.setSscSchemePack(SscRu.jsl(hisPOList, SscSchemePack.class));
            // 查询附件信息
            sscAccessoryPO.setObjId(sscSchemeQryBo0.getSchemeHisId());
            sscAccessoryPO.setObjType(1);

        } else {
            // 查询附件信息条件
            sscAccessoryPO.setObjId(sscSchemeQryBo0.getSchemeId());
            sscAccessoryPO.setObjType(1);
            // 不是草稿
            if (Boolean.FALSE.equals(sscSchemeQryBo0.getEnableDraft())) {
                //根据方案ID查询ssc_scheme
                SscSchemePO po = SscRu.js(sscSchemeQryBo0, SscSchemePO.class);
                po.setSchemeId(sscSchemeQryBo0.getSchemeId());
                SscSchemePO modelBy = sscSchemeMapper.getModelBy(po);
                if (modelBy == null) {
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_QUERY_SCHEME_ERROR, "方案查询为空");
                }
                //保存方案信息
                sscSchemeDo = SscRu.js(modelBy, SscSchemeDo.class);
                //根据方案ID查询ssc_scheme_pack
                SscSchemePackPO packPO = new SscSchemePackPO();
                packPO.setSchemeId(sscSchemeQryBo0.getSchemeId());
                List<SscSchemePackPO> sscSchemePackPO = sscSchemePackMapper.getList(packPO);
                sscSchemeDo.setSscSchemePack(SscRu.jsl(sscSchemePackPO, SscSchemePack.class));
            } else {
                //根据方案ID查询ssc_scheme_draft
                SscSchemeDraftPO draftPO = new SscSchemeDraftPO();
                draftPO.setSchemeId(sscSchemeQryBo0.getSchemeId());
                SscSchemeDraftPO modelBy = sscSchemeDraftMapper.getModelBy(draftPO);
                //保存方案信息
                sscSchemeDo = SscRu.js(modelBy, SscSchemeDo.class);
                //方案ID查询ssc_scheme_pack_draft
                SscSchemePackDraftPO packDraftPO = new SscSchemePackDraftPO();
                packDraftPO.setSchemeId(sscSchemeQryBo0.getSchemeId());
                List<SscSchemePackDraftPO> model = sscSchemePackDraftMapper.getList(packDraftPO);
                //保存方案包信息
                sscSchemeDo.setSscSchemePack(SscRu.jsl(model, SscSchemePack.class));
            }
        }
        List<SscAccessoryPO> accessoryPO = sscAccessoryMapper.getList(sscAccessoryPO);
        List<SscAccessory> accessoryList = SscRu.jsl(accessoryPO, SscAccessory.class);
        sscSchemeDo.setSscAccessory(accessoryList);
        return sscSchemeDo;
    }

    @Override
    public SscSchemeDo qrySchemePackList(SscSchemePackQryBo sscSchemePackQryBo) {
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        if (ObjectUtil.isNull(sscSchemePackQryBo.getSchemeHisId()) && ObjectUtil.isNull(sscSchemePackQryBo.getSchemeHisId())) {
            // 主表
            SscSchemePackPO where = SscRu.js(sscSchemePackQryBo, SscSchemePackPO.class);
            List<SscSchemePackPO> poList = sscSchemePackMapper.getList(where);
            sscSchemeDo.setSscSchemePack(SscRu.jsl(poList, SscSchemePack.class));
        } else {
            // 历史表
            SscSchemePackHisPO hisPOWhere = SscRu.js(sscSchemePackQryBo, SscSchemePackHisPO.class);
            List<SscSchemePackHisPO> hisPOList = sscSchemePackHisMapper.getList(hisPOWhere);
            sscSchemeDo.setSscSchemePack(SscRu.jsl(hisPOList, SscSchemePack.class));
        }
        return sscSchemeDo;
    }

    @Override
    public void addSchemePackBatch(SscSchemeDo sscSchemeDo) {

    }

    @Override
    public void deleteSchemePackBatch(SscSchemeDo sscSchemeDo) {

    }

    @Override
    public SscSchemeDo qrySchemeAcceptRecordList(SscSchemeQryBo sscSchemeQryBo) {
        SscSchemeDo rspBo = new SscSchemeDo();
        SscSchemeAcceptRecordPO po = SscRu.js(sscSchemeQryBo, SscSchemeAcceptRecordPO.class);
        List<SscSchemeAcceptRecordPO> list = sscSchemeAcceptRecordMapper.getList(po);
        List<SscSchemeAcceptRecord> recordList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            recordList.addAll(SscRu.jsl(list, SscSchemeAcceptRecord.class));
        }
        rspBo.setSscSchemeAcceptRecord(recordList);
        return rspBo;
    }

    @Override
    public void deleteSchemeSingle(SscSchemeDo sscSchemeDo) {

    }

    @Override
    public void updateSchemeMain(SscSchemeDo sscSchemeDo) {
        SscSchemePO setPo = SscRu.js(sscSchemeDo, SscSchemePO.class);
        setPo.setUpdateTime(sscSchemeDo.getOperTime());
        SscSchemePO wherePo = new SscSchemePO();
        wherePo.setSchemeId(sscSchemeDo.getSchemeId());
        if (wherePo.getSchemeId() != null) {
            sscSchemeMapper.updateBy(setPo, wherePo);
        }
    }

    @Override
    public void addSchemeAcceptRecord(SscSchemeDo sscSchemeDo) {
        if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeAcceptRecord())) {
            List<SscSchemeAcceptRecordPO> sscSchemeAcceptRecordPOS = SscRu.jsl(sscSchemeDo.getSscSchemeAcceptRecord(), SscSchemeAcceptRecordPO.class);
            for (SscSchemeAcceptRecordPO po : sscSchemeAcceptRecordPOS) {
                po.setAcceptRecordId(IdUtil.nextId());
            }
            sscSchemeAcceptRecordMapper.insertBatch(sscSchemeAcceptRecordPOS);
        }
    }

    @Override
    public SscSchemeDo qrySchemeEntrustRecordList(SscSchemeEntrustRecordQryBo sscSchemeEntrustRecordQryBo) {
        SscSchemeDo rspBO = new SscSchemeDo();
        SscSchemeEntrustRecordPO po = SscRu.js(sscSchemeEntrustRecordQryBo, SscSchemeEntrustRecordPO.class);
        List<SscSchemeEntrustRecordPO> list = sscSchemeEntrustRecordMapper.getList(po);
        List<SscSchemeEntrustRecord> recordList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            recordList.addAll(SscRu.jsl(list, SscSchemeEntrustRecord.class));
        }
        rspBO.setSscSchemeEntrustRecord(recordList);
        return rspBO;
    }

    @Override
    public void addSchemeEntrustRecord(SscSchemeDo sscSchemeDo) {
        if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeEntrustRecord())) {
            List<SscSchemeEntrustRecordPO> sscSchemeEntrustRecordPOS = SscRu.jsl(sscSchemeDo.getSscSchemeEntrustRecord(), SscSchemeEntrustRecordPO.class);
            for (SscSchemeEntrustRecordPO po : sscSchemeEntrustRecordPOS) {
                po.setEntrustRecordId(IdUtil.nextId());
                po.setCreateName(sscSchemeDo.getName());
                po.setCreateUsername(sscSchemeDo.getUsername());
                po.setCreateUserId(sscSchemeDo.getUserId());
                po.setCreateTime(new Date());
            }
            sscSchemeEntrustRecordMapper.insertBatch(sscSchemeEntrustRecordPOS);
        }
    }

    @Override
    public void copySchemeToDraft(SscSchemeDo sscSchemeDo) {
        if (sscSchemeDo.getEnableDraft()) {
            //1 删除采购方案草稿表
            SscSchemeDraftPO sscSchemeDraftPO = new SscSchemeDraftPO();
            sscSchemeDraftPO.setSchemeId(sscSchemeDo.getSchemeId());
            sscSchemeDraftPO.setToken(sscSchemeDo.getToken());
            sscSchemeDraftMapper.deleteBy(sscSchemeDraftPO);
            //2 根据方案ID将数据直接从方案表写入到方案草稿表
            SscSchemePO sscSchemePO = new SscSchemePO();
            sscSchemePO.setSchemeId(sscSchemeDo.getSchemeId());
            sscSchemeMapperUns.insertSelect(sscSchemePO, sscSchemeDo.getToken());
            //3 删除方案包草稿表
            SscSchemePackDraftPO sscSchemePackDraftPO = new SscSchemePackDraftPO();
            sscSchemePackDraftPO.setSchemeId(sscSchemeDo.getSchemeId());
            sscSchemePackDraftPO.setToken(sscSchemeDo.getToken());
            sscSchemePackDraftMapper.deleteBy(sscSchemePackDraftPO);
            //4 根据方案ID将数据直接从方案包表写入到方案包草稿表
            SscSchemePackPO sscSchemePackPO = new SscSchemePackPO();
            sscSchemePackPO.setSchemeId(sscSchemeDo.getSchemeId());
            sscSchemePackMapperUns.insertSelect(sscSchemePackPO, sscSchemeDo.getToken());
        }
        //5 删除方案物料草稿表
        SscSchemeMatDraftPO sscSchemeMatDraftPO = new SscSchemeMatDraftPO();
        sscSchemeMatDraftPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatDraftPO.setToken(sscSchemeDo.getToken());
        sscSchemeMatDraftMapper.deleteBy(sscSchemeMatDraftPO);
        //6 将数据直接从方案物料信息表写入到方案物料草稿表
        SscSchemeMatPO sscSchemeMatPO = new SscSchemeMatPO();
        sscSchemeMatPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatMapperUns.copeToDraft(sscSchemeMatPO, sscSchemeDo.getToken());
        //7 删除方案邀请供应商信息表
        SscSchemeInviteDraftPO sscSchemeInviteDraftPO = new SscSchemeInviteDraftPO();
        sscSchemeInviteDraftPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteDraftPO.setToken(sscSchemeDo.getToken());
        sscSchemeInviteDraftMapper.deleteBy(sscSchemeInviteDraftPO);
        //8 将数据直接从方案物料信息表写入到方案邀请供应商草稿表
        SscSchemeInviteSupPO sscSchemeInviteSupPO = new SscSchemeInviteSupPO();
        sscSchemeInviteSupPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteSupMapperUns.copyToDraft(sscSchemeInviteSupPO, sscSchemeDo.getToken());

    }

    @Override
    public void updateSchemeMatBatch(SscSchemeDo sscSchemeDo) {
        if (sscSchemeDo.getEnableDraft()) {
            if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeMat())) {
                sscSchemeDo.getSscSchemeMat().forEach(sscSchemeMat -> {
                    //set值
                    SscSchemeMatDraftPO set = SscRu.js(sscSchemeMat, SscSchemeMatDraftPO.class);
                    set.setSchemeId(null);
                    set.setToken(null);
                    //where值
                    SscSchemeMatDraftPO where = new SscSchemeMatDraftPO();
                    where.setSchemeMatIds(sscSchemeMat.getSchemeMatIds());
                    where.setSchemeId(sscSchemeDo.getSchemeId());
                    where.setToken(sscSchemeDo.getToken());
                    sscSchemeMatDraftMapper.updateBy(set, where);
                });
            }
        } else {
            if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeMat())) {
                sscSchemeDo.getSscSchemeMat().forEach(sscSchemeMat -> {
                    //set值
                    SscSchemeMatPO set = SscRu.js(sscSchemeMat, SscSchemeMatPO.class);
                    set.setSchemeId(null);
                    //where值
                    SscSchemeMatPO where = new SscSchemeMatPO();
                    where.setSchemeMatIds(sscSchemeMat.getSchemeMatIds());
                    where.setSchemeId(sscSchemeDo.getSchemeId());
                    sscSchemeMatMapper.updateBy(set, where);
                });
            }
        }
    }

    @Override
    public void setSchemeMatNullValue(SscSchemeDo sscSchemeDo) {
        if (sscSchemeDo.getEnableDraft()) {
            if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeMat())) {
                sscSchemeDo.getSscSchemeMat().forEach(ssm -> {
                    //set值
                    SscSchemeMatDraftPO set = SscRu.js(ssm, SscSchemeMatDraftPO.class);
                    set.setSchemeId(null);
                    set.setToken(null);
                    //where值
                    SscSchemeMatDraftPO where = new SscSchemeMatDraftPO();
                    where.setSchemeId(sscSchemeDo.getSchemeId());
                    where.setToken(sscSchemeDo.getToken());
                    sscSchemeMatMapperUns.updateSchemeMatDraft(set, where);
                });
            }
        } else {
            if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeMat())) {
                sscSchemeDo.getSscSchemeMat().forEach(ssm -> {
                    //set值
                    SscSchemeMatPO set = SscRu.js(ssm, SscSchemeMatPO.class);
                    set.setSchemeId(null);
                    //where值
                    SscSchemeMatPO where = new SscSchemeMatPO();
                    where.setSchemeId(sscSchemeDo.getSchemeId());
                    sscSchemeMatMapperUns.updateSchemeMat(set, where);
                });
            }
        }
    }

    @Override
    public SscSchemeDo qrySchemeVersionList(SscSchemeQryBo sscSchemeQryBo) {
        SscSchemeHisPO where = new SscSchemeHisPO();
        where.setSchemeId(sscSchemeQryBo.getSchemeId());
        List<SscSchemeHisPO> schemeHisPOList = sscSchemeHisMapper.getList(where);
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setSscSchemeVersion(JUtil.jsl(schemeHisPOList, SscSchemeVersion.class));
        return sscSchemeDo;
    }

    @Override
    public void schemeChange(SscSchemeDo sscSchemeDo) {
        // 根据方案id查询方案信息
        SscSchemePO sscSchemePOWhere = new SscSchemePO();
        sscSchemePOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        SscSchemePO sscSchemePO = sscSchemeMapper.getModelBy(sscSchemePOWhere);
        // 修改审批状态为草稿 方案状态为已变更
        SscSchemePO schemePOWhere = new SscSchemePO();
        schemePOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        SscSchemePO schemePOSet = new SscSchemePO();
        schemePOSet.setSchemeAuditStatus(SscCommConstant.SchemeAuditStatus.DRAW.getCode());
        schemePOSet.setSchemeStatus(SscCommConstant.SchemeStatus.CHANGE.getCode());
        // 版本号 + 1
        schemePOSet.setSchemeVersion(getVersion(sscSchemePO.getSchemeVersion()));
        schemePOSet.setUpdateTime(new Date());
        sscSchemeMapper.updateBy(schemePOSet, schemePOWhere);
        // 清空执行人
        SscSchemePO impl = new SscSchemePO();
        impl.setSchemeId(sscSchemeDo.getSchemeId());
        impl.setImplId(-1L);
        impl.setImplName("");
        sscSchemeMapperUns.updateImpl(impl);
        // 新增方案历史信息
        SscSchemeHisPO sscSchemeHisPO = JUtil.js(sscSchemePO, SscSchemeHisPO.class);
        long schemeHisId = IdUtil.nextId();
        sscSchemeHisPO.setSchemeHisId(schemeHisId);
        // 设置审批时间
        UocOrderTaskInstPO instPO = new UocOrderTaskInstPO();
        instPO.setObjId(sscSchemePO.getSchemeId());
        List<UocOrderTaskInstPO> instPOList = uocOrderTaskInstMapper.getList(instPO);
        sscSchemeHisPO.setAuditTime(instPOList.stream().max(Comparator.comparing(UocOrderTaskInstPO::getFinishTime)).get().getFinishTime());
        sscSchemeHisMapper.insert(sscSchemeHisPO);
        // 根据方案id查询方案物料信息
        SscSchemeMatPO sscSchemeMatPOWhere = new SscSchemeMatPO();
        sscSchemeMatPOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        List<SscSchemeMatPO> sscSchemeMatPOList = sscSchemeMatMapper.getList(sscSchemeMatPOWhere);
        // 新增方案物料历史信息
        if (CollectionUtil.isNotEmpty(sscSchemeMatPOList)) {
            List<SscSchemeMatHisPO> schemeMatHisPOList = sscSchemeMatPOList.stream().map(e -> {
                SscSchemeMatHisPO sscSchemeMatHisPO = JUtil.js(e, SscSchemeMatHisPO.class);
                sscSchemeMatHisPO.setSchemeHisId(schemeHisId);
                sscSchemeMatHisPO.setSchemeMatHisId(IdUtil.nextId());
                return sscSchemeMatHisPO;
            }).collect(Collectors.toList());
            sscSchemeMatHisMapper.insertBatch(schemeMatHisPOList);
        }
        // 根据方案id查询方案标段信息
        SscSchemePackPO sscSchemePackPOWhere = new SscSchemePackPO();
        sscSchemePackPOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        List<SscSchemePackPO> packPOList = sscSchemePackMapper.getList(sscSchemePackPOWhere);
        // 新增标段历史信息
        if (CollectionUtil.isNotEmpty(packPOList)) {
            List<SscSchemePackHisPO> packHisList = packPOList.stream().map(e -> {
                SscSchemePackHisPO schemePackHisPO = JUtil.js(e, SscSchemePackHisPO.class);
                schemePackHisPO.setSchemeHisId(schemeHisId);
                schemePackHisPO.setPackHisId(IdUtil.nextId());
                return schemePackHisPO;
            }).collect(Collectors.toList());
            sscSchemePackHisMapper.insertBatch(packHisList);
        }
        // 根据方案id查询方案邀请供应商信息
        SscSchemeInviteSupPO schemeInviteSupPOWhere = new SscSchemeInviteSupPO();
        schemeInviteSupPOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        List<SscSchemeInviteSupPO> supPOList = sscSchemeInviteSupMapper.getList(schemeInviteSupPOWhere);
        // 新增方案邀请供应商历史信息
        if (CollectionUtil.isNotEmpty(supPOList)) {
            List<SscSchemeInviteSupHisPO> supHisPOList = supPOList.stream().map(e -> {
                SscSchemeInviteSupHisPO schemeInviteSupHisPO = JUtil.js(e, SscSchemeInviteSupHisPO.class);
                schemeInviteSupHisPO.setSchemeHisId(schemeHisId);
                schemeInviteSupHisPO.setSchemeInviteSupHisId(IdUtil.nextId());
                return schemeInviteSupHisPO;
            }).collect(Collectors.toList());
            sscSchemeInviteSupHisMapper.insertBatch(supHisPOList);
        }
        // 根据方案id查询附件信息
        SscAccessoryPO accessoryPO = new SscAccessoryPO();
        accessoryPO.setObjType(1);
        accessoryPO.setObjId(sscSchemeDo.getSchemeId());
        List<SscAccessoryPO> accessoryPOList = sscAccessoryMapper.getList(accessoryPO);
        if (CollectionUtil.isNotEmpty(accessoryPOList)) {
            // 新增方案附件历史信息
            accessoryPOList.forEach(e -> {
                e.setId(IdUtil.nextId());
                e.setObjId(schemeHisId);
            });
            sscAccessoryMapper.insertBatch(accessoryPOList);
        }
    }

    @Override
    public void addSchemeHis() {

    }

    @Override
    public void schemePutUp(SscSchemeDo sscSchemeDo) {
        // 查询方案信息
        SscSchemePO where = new SscSchemePO();
        where.setSchemeId(sscSchemeDo.getSchemeId());
        SscSchemePO sscSchemePO = sscSchemeMapper.getModelBy(where);
        // 修改方案状态
        SscSchemePO sscSchemePOWhere = new SscSchemePO();
        sscSchemePOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        SscSchemePO sscSchemePOSet = new SscSchemePO();
        sscSchemePOSet.setSchemeStatus(sscSchemeDo.getSchemeStatus());
        sscSchemeMapper.updateBy(sscSchemePOSet, sscSchemePOWhere);

        // 新增方案变更信息
        List<SscSchemeChangeBO> sscSchemeChange = sscSchemeDo.getSscSchemeChange();
        if (CollectionUtil.isNotEmpty(sscSchemeChange)) {
            for (SscSchemeChangeBO changeBO : sscSchemeChange) {
                SscSchemeStatusChngPO chngPO = new SscSchemeStatusChngPO();
                long chngId = IdUtil.nextId();
                chngPO.setId(chngId);
                chngPO.setSchemeId(sscSchemeDo.getSchemeId());
                chngPO.setOldSchemeStatus(sscSchemePO.getSchemeStatus());
                chngPO.setNewSchemeStatus(sscSchemeDo.getSchemeStatus());
                chngPO.setReason(changeBO.getReason());
                chngPO.setOperType(changeBO.getOperType());
                chngPO.setCreateTime(new Date());
                chngPO.setCreateName(sscSchemeDo.getName());
                chngPO.setCreateLoginId(sscSchemeDo.getUserId());
                chngPO.setCreateUsername(sscSchemeDo.getUsername());
                chngPO.setCreateTime(new Date());
                sscSchemeStatusChngMapper.insert(chngPO);
                // 新增附件信息
                insertAccessory(chngId, chngId, sscSchemeDo, changeBO.getSscAccessory());
            }
        }
    }

    @Override
    public void schemeCancelPutUp(SscSchemeDo sscSchemeDo) {
        // 查询已挂起的信息(operType = 0)
        SscSchemeStatusChngPO where = new SscSchemeStatusChngPO();
        where.setSchemeId(sscSchemeDo.getSchemeId());
        where.setOperType(SscCommConstant.OperTypeEnum.PUT_UP.getCode());
        List<SscSchemeStatusChngPO> chngPOList = sscSchemeStatusChngMapper.getList(where);
        // 获取最新一条信息
        List<SscSchemeStatusChngPO> chngPOSortList = chngPOList.stream().sorted(Comparator.comparing(SscSchemeStatusChngPO::getCreateTime).reversed()).collect(Collectors.toList());
        String oldSchemeStatus = chngPOSortList.get(0).getOldSchemeStatus();
        // 修改方案状态
        SscSchemePO schemePOWhere = new SscSchemePO();
        schemePOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        SscSchemePO schemePOSet = new SscSchemePO();
        schemePOSet.setSchemeStatus(oldSchemeStatus);
        sscSchemeMapper.updateBy(schemePOSet, schemePOWhere);
    }

    @Override
    public void updateImpl(SscSchemeDo sscSchemeDo) {
        sscSchemeMapperUns.updateImpl(SscRu.js(sscSchemeDo, SscSchemePO.class));
    }

    @Override
    public SscSchemeDo qrySchemeChangeList(SscSchemeQryBo sscSchemeQryBo) {
        SscSchemeStatusChngPO where = new SscSchemeStatusChngPO();
        where.setSchemeId(sscSchemeQryBo.getSchemeId());
        where.setOperType(sscSchemeQryBo.getOperType());
        List<SscSchemeStatusChngPO> chngPOList = sscSchemeStatusChngMapper.getList(where);
        // 附件信息
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        List<SscSchemeChangeBO> changeBOList = SscRu.jsl(chngPOList, SscSchemeChangeBO.class);
        for (SscSchemeChangeBO bo : changeBOList) {
            SscAccessoryPO accessoryPOWhere = new SscAccessoryPO();
            accessoryPOWhere.setObjId(bo.getId());
            List<SscAccessoryPO> accessoryPOList = sscAccessoryMapper.getList(accessoryPOWhere);
            bo.setSscAccessory(SscRu.jsl(accessoryPOList, SscAccessory.class));
        }
        sscSchemeDo.setSscSchemeChange(changeBOList);
        return sscSchemeDo;
    }

    @Override
    public void updatePackMain(SscSchemeDo sscSchemeDo) {
        List<SscSchemePack> schemePackList = sscSchemeDo.getSscSchemePack();
        if (CollectionUtil.isNotEmpty(schemePackList)) {
            List<SscSchemePackPO> schemePackPOList = SscRu.jsl(schemePackList, SscSchemePackPO.class);
            for (SscSchemePackPO po : schemePackPOList) {
                SscSchemePackPO where = new SscSchemePackPO();
                where.setPackId(po.getPackId());
                sscSchemePackMapper.updateBy(po, where);
            }
        }
    }

    @Override
    public void dealSchemeEnd(SscSchemeDo sscSchemeDo) {
        this.schemePutUp(sscSchemeDo);
    }

    @Override
    public void addSchemeChangeInfo(SscSchemeDo sscSchemeDo) {
        // 查询方案信息
        SscSchemePO schemeWhere = new SscSchemePO();
        schemeWhere.setSchemeId(sscSchemeDo.getSchemeId());
        SscSchemePO schemePO = sscSchemeMapper.getModelBy(schemeWhere);
        for (SscSchemeChangeBO changeBO : sscSchemeDo.getSscSchemeChange()) {
            SscSchemeStatusChngPO chngPO = SscRu.js(changeBO, SscSchemeStatusChngPO.class);
            long chngPOId = IdUtil.nextId();
            chngPO.setId(chngPOId);
            chngPO.setCreateTime(new Date());
            chngPO.setCreateLoginId(sscSchemeDo.getCreateLoginId());
            chngPO.setCreateUsername(sscSchemeDo.getCreateUsername());
            chngPO.setCreateName(sscSchemeDo.getCreateName());
            if (SscCommConstant.OperTypeEnum.PUT_UP.getCode().equals(changeBO.getOperType())) {
                // 挂起，oldSchemeStatus = schemeStatus
                chngPO.setOldSchemeStatus(schemePO.getSchemeStatus());
            } else if (SscCommConstant.OperTypeEnum.END.getCode().equals(changeBO.getOperType())) {
                // 终止，oldSchemeStatus = schemeStatus
                chngPO.setOldSchemeStatus(schemePO.getSchemeStatus());
            } else if (SscCommConstant.OperTypeEnum.AUDIT_PURCHASE_TYPE.getCode().equals(changeBO.getOperType())) {
                // 审批采购方式，oldSchemeStatus = purchaseTypeZ
                chngPO.setOldSchemeStatus(String.valueOf(schemePO.getPurchaseType()));
            }
            sscSchemeStatusChngMapper.insert(chngPO);
            insertAccessory(chngPOId, chngPOId, sscSchemeDo, changeBO.getSscAccessory());
        }
    }

    private String getVersion(String version) {
        int versionNum = Integer.parseInt(version.replace("v", "").replace(".", "")) + 1;
        return "v" + Arrays.stream(ArrayUtil.wrap(Integer.toString(versionNum).toCharArray())).map(String::valueOf).collect(Collectors.joining("."));
    }

    public void insertAccessory(Long objId, Long orderId, SscSchemeDo sscSchemeDo, List<SscAccessory> sscAccessory) {
        if (CollectionUtil.isNotEmpty(sscAccessory)) {
            List<SscAccessoryPO> accessoryPOList = sscAccessory.stream().map(e -> {
                SscAccessoryPO accessoryPO = new SscAccessoryPO();
                accessoryPO.setObjId(objId);
                accessoryPO.setOrderId(orderId);
                accessoryPO.setAccessoryId(String.valueOf(IdUtil.nextId()));
                accessoryPO.setId(IdUtil.nextId());
                accessoryPO.setObjType(1);
                accessoryPO.setAttachmentType(e.getAttachmentType());
                accessoryPO.setAccessoryUrl(e.getAccessoryUrl());
                accessoryPO.setAccessoryName(e.getAccessoryName());
                accessoryPO.setCreateName(sscSchemeDo.getName());
                accessoryPO.setCreateTime(new Date());
                accessoryPO.setCreateLoginId(sscSchemeDo.getUserId());
                accessoryPO.setCreateUsername(sscSchemeDo.getUsername());
                return accessoryPO;
            }).collect(Collectors.toList());
            sscAccessoryMapper.insertBatch(accessoryPOList);
        }
    }

}
