package com.tydic.dyc.ssc.repository.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderProcInst;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.*;
import com.tydic.dyc.ssc.model.scheme.sub.*;
import com.tydic.dyc.ssc.repository.SscProcInstRepository;
import com.tydic.dyc.ssc.repository.SscSchemeRepository;
import com.tydic.dyc.ssc.repository.dao.*;
import com.tydic.dyc.ssc.repository.po.*;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackListRspBO;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:SscSchemeRepositoryImpl
 * 说明:采购方案基建层
 * 时间:2022/11/10 10:29
 * 作者:罗有
 */

@Service
@Slf4j
public class SscSchemeRepositoryImpl implements SscSchemeRepository {
    @Autowired
    private SscSchemeMatDraftMapper sscSchemeMatDraftMapper;

    @Autowired
    private SscSchemePackMapper sscSchemePackMapper;

    @Autowired
    private SscAccessoryMapper sscAccessoryMapper;

    @Autowired
    private SscSchemeDraftMapper sscSchemeDraftMapper;

    @Autowired
    private SscSchemePackDraftMapper sscSchemePackDraftMapper;

    @Autowired
    private SscSchemeMapper sscSchemeMapper;

    @Autowired
    private SscSchemeMatMapper sscSchemeMatMapper;

    @Autowired
    private SscSchemeInviteSupMapper sscSchemeInviteSupMapper;

    @Autowired
    private SscSchemeInviteDraftMapper sscSchemeInviteDraftMapper;

    @Autowired
    private SscSchemeMatMapperUns sscSchemeMatMapperUns;

    @Autowired
    private SscSchemeInviteSupMapperUns sscSchemeInviteSupMapperUns;

    @Autowired
    private SscSchemeAcceptRecordMapper sscSchemeAcceptRecordMapper;

    @Autowired
    private SscSchemeEntrustRecordMapper sscSchemeEntrustRecordMapper;

    @Autowired
    private SscSchemeMapperUns sscSchemeMapperUns;

    @Autowired
    private SscSchemePackMapperUns sscSchemePackMapperUns;

    @Autowired
    private SscSchemeHisMapper sscSchemeHisMapper;

    @Autowired
    private SscSchemeMatHisMapper sscSchemeMatHisMapper;

    @Autowired
    private SscSchemePackHisMapper sscSchemePackHisMapper;

    @Autowired
    private SscSchemeInviteSupHisMapper sscSchemeInviteSupHisMapper;

    @Autowired
    private SscSchemeStatusChngMapper sscSchemeStatusChngMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;

    @Autowired
    private SscSchemeMatExtDraftMapper sscSchemeMatExtDraftMapper;

    @Autowired
    private SscSchemeInviteSupExtDraftMapper sscSchemeInviteSupExtDraftMapper;

    @Autowired
    private SscSchemeMatExtMapper sscSchemeMatExtMapper;

    @Autowired
    private SscSchemeInviteSupExtMapper sscSchemeInviteSupExtMapper;

    @Autowired
    private SscSchemeExtMapper sscSchemeExtMapper;

    @Autowired
    private SscSchemeHisExtMapper sscSchemeHisExtMapper;

    @Autowired
    private SscSchemeMatHisExtMapper sscSchemeMatHisExtMapper;

    @Autowired
    private SscSchemePackHisExtMapper sscSchemePackHisExtMapper;

    @Autowired
    private SscSchemePackExtMapper sscSchemePackExtMapper;

    @Autowired
    private SscSchemeInviteSupHisExtMapper sscSchemeInviteSupHisExtMapper;

    @Autowired
    private SscProcInstRepository sscProcInstRepository;


    @Override
    public SscQrySchemeMatListRspBO qrySchemeMatList(SscQrySchemeMatListReqBO reqPageBo) {
        SscQrySchemeMatListRspBO sscQrySchemeMatListRspBO = new SscQrySchemeMatListRspBO();
        Page<?> pg;
        List<SchemeMatBO> SchemeMatBOs;
        if (ObjectUtil.isNotNull(reqPageBo.getSchemeHisId()) || ObjectUtil.isNotNull(reqPageBo.getPackHisId())) {
            // 查历史
            pg = new Page<SscSchemeMatHisPO>(reqPageBo.getPageNo(), reqPageBo.getPageSize());
            SscSchemeMatHisPO sscSchemeMatDraftPO = SscRu.js(reqPageBo, SscSchemeMatHisPO.class);
            List<SscSchemeMatHisPO> listPage = this.sscSchemeMatHisMapper.getListPage(sscSchemeMatDraftPO, (Page<SscSchemeMatHisPO>) pg);
            SchemeMatBOs = SscRu.jsl(listPage, SchemeMatBO.class);
        } else {
            //判断如果入参enableDraft=true则查询方案物料信息草稿表
            if (reqPageBo.getEnableDraft()) {
                pg = new Page<SscSchemeMatDraftPO>(reqPageBo.getPageNo(), reqPageBo.getPageSize());
                SscSchemeMatDraftPO sscSchemeMatDraftPO = SscRu.js(reqPageBo, SscSchemeMatDraftPO.class);
                List<SscSchemeMatDraftPO> listPage = this.sscSchemeMatDraftMapper.getListPage(sscSchemeMatDraftPO, (Page<SscSchemeMatDraftPO>) pg);
                SchemeMatBOs = SscRu.jsl(listPage, SchemeMatBO.class);
            } else {
                //判断如果入参enableDraft=false则查询方案物料信息表
                pg = new Page<SscSchemeMatPO>(reqPageBo.getPageNo(), reqPageBo.getPageSize());
                SscSchemeMatPO sscSchemeMatPO = SscRu.js(reqPageBo, SscSchemeMatPO.class);
                List<SscSchemeMatPO> listPage = this.sscSchemeMatMapper.getListPage(sscSchemeMatPO, (Page<SscSchemeMatPO>) pg);
                SchemeMatBOs = SscRu.jsl(listPage, SchemeMatBO.class);
            }
        }
        sscQrySchemeMatListRspBO.setRows(SchemeMatBOs);
        sscQrySchemeMatListRspBO.setPageNo(pg.getPageNo());
        sscQrySchemeMatListRspBO.setTotal(pg.getTotalPages());
        sscQrySchemeMatListRspBO.setRecordsTotal(pg.getTotalCount());
        return sscQrySchemeMatListRspBO;
    }

    @Override
    public SscSchemeDo qrySchemeMainInfo(SscSchemeQryBo sscSchemeQryBo0) {
        if (Boolean.TRUE.equals(sscSchemeQryBo0.getEnableDraft())) {
            SscSchemeDraftPO sscSchemeDraftPO = new SscSchemeDraftPO();
            sscSchemeDraftPO.setSchemeId(sscSchemeQryBo0.getSchemeId());
            SscSchemeDraftPO modelBy = sscSchemeDraftMapper.getModelBy(sscSchemeDraftPO);
            return SscRu.js(modelBy, SscSchemeDo.class);
        }
        SscSchemePO sscSchemePO = new SscSchemePO();
        sscSchemePO.setSchemeId(sscSchemeQryBo0.getSchemeId());
        SscSchemePO modelBy = sscSchemeMapper.getModelBy(sscSchemePO);
        return SscRu.js(modelBy, SscSchemeDo.class);
    }

    @Override
    public void addScheme(SscSchemeDo sscSchemeDo) {
        SscSchemePO po = SscRu.js(sscSchemeDo, SscSchemePO.class);
        po.setCreateName(sscSchemeDo.getName());
        po.setCreateUsername(sscSchemeDo.getUsername());
        po.setCreateLoginId(sscSchemeDo.getUserId());
        po.setCreateTime(ObjectUtil.isNull(sscSchemeDo.getCreateTime()) ? new Date() : sscSchemeDo.getCreateTime());
        po.setCreateOrgId(sscSchemeDo.getOrgId());
        po.setCreateOrgName(sscSchemeDo.getOrgName());
        po.setCreateOrgPath(sscSchemeDo.getOrgPath());
        // 设置版本号
        if (StrUtil.isEmpty(sscSchemeDo.getSchemeVersion())) {
            po.setSchemeVersion("v1.0.0");
        }
        sscSchemeMapper.insert(po);
        List<SscSchemePackPO> sscSchemePackPOS = SscRu.jsl(sscSchemeDo.getSscSchemePack(), SscSchemePackPO.class);
        log.info("新增方案包数据为: {}", JSON.toJSONString(sscSchemePackPOS));
        if (CollectionUtil.isNotEmpty(sscSchemePackPOS)) {
            for (SscSchemePackPO packPO : sscSchemePackPOS) {
                packPO.setCreateName(sscSchemeDo.getName());
                packPO.setCreateUsername(sscSchemeDo.getUsername());
                packPO.setCreateLoginId(sscSchemeDo.getUserId());
                packPO.setCreateTime(ObjectUtil.isNull(packPO.getCreateTime()) ? new Date() : packPO.getCreateTime());
                packPO.setCreateOrgId(sscSchemeDo.getOrgId());
                packPO.setCreateOrgName(sscSchemeDo.getOrgName());
            }
            sscSchemePackMapper.insertBatch(sscSchemePackPOS);
        }
        // 新增附件信息
        List<SscAccessoryPO> accessoryPOList = SscRu.jsl(sscSchemeDo.getSscAccessory(), SscAccessoryPO.class);
        if (CollectionUtil.isNotEmpty(accessoryPOList)) {
            accessoryPOList.forEach(e -> {
                e.setObjId(sscSchemeDo.getSchemeId());
                e.setOrderId(sscSchemeDo.getSchemeId());
                e.setAccessoryId(String.valueOf(IdUtil.nextId()));
                e.setId(IdUtil.nextId());
                e.setObjType(1);
                e.setCreateName(sscSchemeDo.getName());
                e.setCreateTime(new Date());
                e.setCreateLoginId(sscSchemeDo.getUserId());
                e.setCreateUsername(sscSchemeDo.getUsername());
                e.setDelTag(SscCommConstant.YesOrNoEnum.NO.getCode());
            });
            sscAccessoryMapper.insertBatch(accessoryPOList);
        }
    }

    @Override
    public void updateScheme(SscSchemeDo sscSchemeDo0) {
        //根据方案ID更新方案主体信息
        SscSchemePO setPo = SscRu.js(sscSchemeDo0, SscSchemePO.class);
        SscSchemePO wherePo = new SscSchemePO();
        wherePo.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemeMapper.updateBy(setPo, wherePo);
        //根据方案ID删除方案包
        SscSchemePackPO deletePo = new SscSchemePackPO();
        deletePo.setSchemeId(sscSchemeDo0.getSchemeId());
        sscSchemePackMapper.deleteBy(deletePo);
        //批量新增方案包
        List<SscSchemePackPO> sscSchemePackPOS = SscRu.jsl(sscSchemeDo0.getSscSchemePack(), SscSchemePackPO.class);
        if (CollectionUtil.isNotEmpty(sscSchemePackPOS)) {
            for (SscSchemePackPO po : sscSchemePackPOS) {
                po.setUpdateLoginId(sscSchemeDo0.getUserId());
                po.setUpdateName(sscSchemeDo0.getName());
                po.setUpdateUsername(sscSchemeDo0.getUsername());
                po.setUpdateTime(sscSchemeDo0.getOperTime());
            }
            sscSchemePackMapper.insertBatch(sscSchemePackPOS);
        }
        // 根据方案id删除附件信息
        SscAccessoryPO accessoryDelPO = new SscAccessoryPO();
        accessoryDelPO.setObjId(sscSchemeDo0.getSchemeId());
        sscAccessoryMapper.deleteBy(accessoryDelPO);
        List<SscAccessory> sscAccessory = sscSchemeDo0.getSscAccessory();
        // 批量新增附件信息
        insertAccessory(sscSchemeDo0.getSchemeId(), sscSchemeDo0.getSchemeId(), sscSchemeDo0, sscAccessory);

    }

    @Override
    public void addSchemeMatBatch(SscSchemeDo sscSchemeDo0) {

        List<SscSchemeMat> sscSchemeMat = sscSchemeDo0.getSscSchemeMat();
        //判断如果入参enableDraft=true则批量插入方案物料信息草稿表
        if (sscSchemeDo0.getEnableDraft()) {
            List<SscSchemeMatDraftPO> matDraftPOS = sscSchemeMat.stream().map(e -> {
                long schemeMatId = IdUtil.nextId();
                SscSchemeMatDraftPO sscSchemeMatDraftPO = SscRu.js(e, SscSchemeMatDraftPO.class);
                e.setSchemeMatId(schemeMatId);
                sscSchemeMatDraftPO.setSchemeMatId(schemeMatId);
                sscSchemeMatDraftPO.setCreateName(sscSchemeDo0.getName());
                sscSchemeMatDraftPO.setSchemeId(sscSchemeDo0.getSchemeId());
                sscSchemeMatDraftPO.setCreateLoginId(sscSchemeDo0.getUserId());
                sscSchemeMatDraftPO.setCreateUsername(sscSchemeDo0.getUsername());
                sscSchemeMatDraftPO.setCreateOrgId(sscSchemeDo0.getOrgId());
                sscSchemeMatDraftPO.setCreateOrgName(sscSchemeDo0.getOrgName());
                sscSchemeMatDraftPO.setToken(sscSchemeDo0.getToken());
                return sscSchemeMatDraftPO;
            }).collect(Collectors.toList());
            sscSchemeMatDraftMapper.insertBatch(matDraftPOS);
        } else {
            if (Boolean.TRUE.equals(sscSchemeDo0.getDelAddFlag())) {
                // 删除方案id下所有物料
                SscSchemeMatPO delete = new SscSchemeMatPO();
                delete.setSchemeId(sscSchemeDo0.getSchemeId());
                sscSchemeMatMapper.deleteBy(delete);
            }
            //判断如果入参enableDraft=false则批量插入方案物料信息表
            List<SscSchemeMatPO> matPOS = sscSchemeMat.stream().map(e -> {
                long schemeMatId = IdUtil.nextId();
                SscSchemeMatPO sscSchemeMatPO = SscRu.js(e, SscSchemeMatPO.class);
                e.setSchemeMatId(schemeMatId);
                sscSchemeMatPO.setSchemeMatId(schemeMatId);
                sscSchemeMatPO.setCreateName(sscSchemeDo0.getName());
                sscSchemeMatPO.setSchemeId(sscSchemeDo0.getSchemeId());
                sscSchemeMatPO.setCreateLoginId(sscSchemeDo0.getUserId());
                sscSchemeMatPO.setCreateUsername(sscSchemeDo0.getUsername());
                sscSchemeMatPO.setCreateOrgId(sscSchemeDo0.getOrgId());
                sscSchemeMatPO.setCreateOrgName(sscSchemeDo0.getOrgName());
                return sscSchemeMatPO;
            }).collect(Collectors.toList());
            sscSchemeMatMapper.insertBatch(matPOS);
        }
    }

    @Override
    public SscQrySchemeInviteSupListRspBO qrySchemeInviteSupList(SscQrySchemeInviteSupListReqBO reqBO) {
        SscQrySchemeInviteSupListRspBO rspBO = SscRu.success(SscQrySchemeInviteSupListRspBO.class);
        Page<?> page = null;
        List<SchemeInviteSupBO> rows = null;
        // 查询历史
        if (ObjectUtil.isNotNull(reqBO.getSchemeHisId())) {
            SscSchemeInviteSupHisPO inviteSupPO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeInviteSupHisPO.class);
            page = new Page<SscSchemeInviteSupHisPO>();
            page.setPageNo(reqBO.getPageNo());
            page.setPageSize(reqBO.getPageSize());
            List<SscSchemeInviteSupHisPO> listPage = sscSchemeInviteSupHisMapper.getListPage(inviteSupPO, (Page<SscSchemeInviteSupHisPO>) page);
            rows = JSON.parseArray(JSON.toJSONString(listPage), SchemeInviteSupBO.class);
        } else {
            if (reqBO.getEnableDraft()) {
                SscSchemeInviteDraftPO inviteSupPO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeInviteDraftPO.class);
                page = new Page<SscSchemeInviteDraftPO>();
                page.setPageNo(reqBO.getPageNo());
                page.setPageSize(reqBO.getPageSize());
                // 查询草稿
                List<SscSchemeInviteDraftPO> listPage = sscSchemeInviteDraftMapper.getListPage(inviteSupPO, (Page<SscSchemeInviteDraftPO>) page);
                if (ObjectUtil.isNotEmpty(listPage)) {
                    rows = JSON.parseArray(JSON.toJSONString(listPage), SchemeInviteSupBO.class);

                }
            } else {
                SscSchemeInviteSupPO inviteSupPO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeInviteSupPO.class);
                page = new Page<SscSchemeInviteSupPO>();
                page.setPageNo(reqBO.getPageNo());
                page.setPageSize(reqBO.getPageSize());
                List<SscSchemeInviteSupPO> listPage = sscSchemeInviteSupMapper.getListPage(inviteSupPO, (Page<SscSchemeInviteSupPO>) page);
                if (ObjectUtil.isNotEmpty(listPage)) {
                    rows = JSON.parseArray(JSON.toJSONString(listPage), SchemeInviteSupBO.class);
                }
            }
        }
        rspBO.setRows(rows);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(reqBO.getPageNo());
        return rspBO;
    }

    @Override
    public void copyScheme(SscSchemeDo sscSchemeDo) {
        //根据方案ID删除方案物料主表数据
        SscSchemeMatPO deleteMatPo = new SscSchemeMatPO();
        deleteMatPo.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatMapper.deleteBy(deleteMatPo);
        //执行insert select 语句，根据方案ID将数据直接从物料草稿表写入主表
        SscSchemeQryBo insertMatPo = new SscSchemeQryBo();
        insertMatPo.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatMapperUns.insertSelect(insertMatPo);
        //	根据方案ID删除物料草稿表数据
        SscSchemeMatDraftPO deleteMatDraftPo = new SscSchemeMatDraftPO();
        deleteMatDraftPo.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatDraftMapper.deleteBy(deleteMatDraftPo);

        // 根据方案id删除方案物料扩展主数据
        SscSchemeMatExtPO sscSchemeMatExtPO = new SscSchemeMatExtPO();
        sscSchemeMatExtPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatExtMapper.deleteBy(sscSchemeMatExtPO);
        // 执行insert select, 方案物料草稿表写入到主表
        sscSchemeMatMapperUns.insertSelectExt(sscSchemeMatExtPO);
        // 删除物料扩展草稿
        SscSchemeMatExtDraftPO schemeMatExtDraftPO = new SscSchemeMatExtDraftPO();
        schemeMatExtDraftPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatExtDraftMapper.deleteBy(schemeMatExtDraftPO);

        //根据方案ID删除受邀供应商主表数据
        SscSchemeInviteSupPO deleteSupPo = new SscSchemeInviteSupPO();
        deleteSupPo.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteSupMapper.deleteBy(deleteSupPo);

        //执行insert select语句，根据方案ID将受邀供应商草稿表数据写入受邀供应商主表
        SscSchemeQryBo insertSupPo = new SscSchemeQryBo();
        insertSupPo.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteSupMapperUns.insertSelect(insertSupPo);
        //根据方案ID删除受邀供应商草稿表数据
        SscSchemeInviteDraftPO deleteDraftPo = new SscSchemeInviteDraftPO();
        deleteDraftPo.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteDraftMapper.deleteBy(deleteDraftPo);

        // 根据方案id删除供应商扩展
        SscSchemeInviteSupExtPO sscSchemeInviteSupExtPO = new SscSchemeInviteSupExtPO();
        sscSchemeInviteSupExtPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteSupExtMapper.deleteBy(sscSchemeInviteSupExtPO);
        // 执行insert select, 将供应商扩展草稿写入到供应商扩展主表
        sscSchemeInviteSupMapperUns.insertSelectExt(sscSchemeInviteSupExtPO);
        // 删除供应商扩展草稿
        SscSchemeInviteSupExtDraftPO supExtDraftPO = new SscSchemeInviteSupExtDraftPO();
        supExtDraftPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteSupExtDraftMapper.deleteBy(supExtDraftPO);

    }

    @Override
    public void deleteSchemeMatBatch(SscSchemeDo sscSchemeDo0) {
        //判断如果入参enableDraft=true则根据token字段删除方案物料信息草稿表
        List<SscSchemeMat> sscSchemeMat = sscSchemeDo0.getSscSchemeMat();
        if (CollectionUtil.isNotEmpty(sscSchemeMat)) {
            sscSchemeMat.forEach(e -> {
                if (sscSchemeDo0.getEnableDraft()) {
                    SscSchemeMatDraftPO sscSchemeMatDraftPO = new SscSchemeMatDraftPO();
                    sscSchemeMatDraftPO.setSchemeId(sscSchemeDo0.getSchemeId());
                    sscSchemeMatDraftPO.setSchemeMatId(e.getSchemeMatId());
                    sscSchemeMatDraftPO.setPackId(e.getPackId());
                    sscSchemeMatDraftPO.setPlanId(e.getPlanId());
                    sscSchemeMatDraftPO.setPlanMatDetailId(e.getPlanMatDetailId());
                    sscSchemeMatDraftPO.setToken(sscSchemeDo0.getToken());
                    this.sscSchemeMatDraftMapper.deleteBy(sscSchemeMatDraftPO);
                } else {
                    // 删除主表物料信息
                    SscSchemeMatPO sscSchemeMatPO = new SscSchemeMatPO();
                    sscSchemeMatPO.setSchemeId(sscSchemeDo0.getSchemeId());
                    sscSchemeMatPO.setSchemeMatId(e.getSchemeMatId());
                    sscSchemeMatPO.setPackId(e.getPackId());
                    sscSchemeMatPO.setPlanId(e.getPlanId());
                    sscSchemeMatPO.setPlanMatDetailId(e.getPlanMatDetailId());
                    this.sscSchemeMatMapper.deleteBy(sscSchemeMatPO);
                }
            });
        }

    }

    @Override
    public SscSchemeDo qrySchemePlanList(SscSchemeQryBo sscSchemeQryBo0) {
        List<SscSchemeMatPO> planList = sscSchemeMatMapperUns.getPlanList(sscSchemeQryBo0);
        List<SscSchemeMat> sscSchemeMats = SscRu.jsl(planList, SscSchemeMat.class);
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setSscSchemeMat(sscSchemeMats);
        return sscSchemeDo;
    }

    @Override
    public void addSchemeInviteSupBatch(SscSchemeDo sscSchemeDo0) {
        List<SscSchemeInviteSup> sscSchemeInviteSup = sscSchemeDo0.getSscSchemeInviteSup();
        if (sscSchemeDo0.getEnableDraft()) {
            //插入sscSchemeInviteDraft表
            List<SscSchemeInviteDraftPO> sscSchemeInviteDraftPOList = new ArrayList<>();
            for (SscSchemeInviteSup sscSchemeInviteSup1 : sscSchemeInviteSup) {
                SscSchemeInviteDraftPO sscSchemeInviteDraftPO = new SscSchemeInviteDraftPO();
                BeanUtils.copyProperties(sscSchemeInviteSup1, sscSchemeInviteDraftPO);
                sscSchemeInviteDraftPO.setSchemeId(sscSchemeDo0.getSchemeId());
                sscSchemeInviteDraftPO.setToken(sscSchemeDo0.getToken());
                sscSchemeInviteDraftPOList.add(sscSchemeInviteDraftPO);
            }
            sscSchemeInviteDraftMapper.insertBatch(sscSchemeInviteDraftPOList);
        } else {
            if (Boolean.TRUE.equals(sscSchemeDo0.getDelAddFlag())) {
                // 删除方案id下的所有供应商
                SscSchemeInviteSupPO delete = new SscSchemeInviteSupPO();
                delete.setSchemeId(sscSchemeDo0.getSchemeId());
                sscSchemeInviteSupMapper.deleteBy(delete);
            }

            //插入sscSchemeInviteSup表
            List<SscSchemeInviteSupPO> sscSchemeInviteSupPOlist = new ArrayList<>();
            for (SscSchemeInviteSup sscSchemeInviteSup1 : sscSchemeInviteSup) {
                SscSchemeInviteSupPO sscSchemeInviteSupPO = new SscSchemeInviteSupPO();
                BeanUtils.copyProperties(sscSchemeInviteSup1, sscSchemeInviteSupPO);
                sscSchemeInviteSupPO.setSchemeId(sscSchemeDo0.getSchemeId());
                sscSchemeInviteSupPOlist.add(sscSchemeInviteSupPO);

            }
            sscSchemeInviteSupMapper.insertBatch(sscSchemeInviteSupPOlist);

        }
    }

    @Override
    public void deleteSchemeInviteSupBatch(SscSchemeDo reqBO) {

        // 所有方案邀请供应商
        List<SscSchemeInviteSup> sscSchemeInviteSupList = reqBO.getSscSchemeInviteSup();

        if (reqBO.getEnableDraft()) {
            // 删除方案邀请供应商草稿表
            if (ObjectUtil.isNotEmpty(sscSchemeInviteSupList)) {
                sscSchemeInviteSupList.forEach(e -> {
                    SscSchemeInviteDraftPO draftPO = SscRu.js(e, SscSchemeInviteDraftPO.class);
                    draftPO.setToken(reqBO.getToken());
                    sscSchemeInviteDraftMapper.deleteBy(draftPO);
                });
            }
        } else {
            if (ObjectUtil.isNotEmpty(sscSchemeInviteSupList)) {
                // 删除方案邀请供应商信息表
                sscSchemeInviteSupList.forEach(e -> {
                    SscSchemeInviteSupPO supPO = SscRu.js(e, SscSchemeInviteSupPO.class);
                    sscSchemeInviteSupMapper.deleteBy(supPO);
                });
            }
        }
    }

    @Override
    public void deleteScheme(SscSchemeDo sscSchemeDo0) {
        if (ObjectUtil.isNotNull(sscSchemeDo0.getSchemeHisId())) {
            // 删除方案历史表
            SscSchemeHisPO sscSchemeHisPO = new SscSchemeHisPO();
            sscSchemeHisPO.setSchemeHisId(sscSchemeDo0.getSchemeHisId());
            this.sscSchemeHisMapper.deleteBy(sscSchemeHisPO);
            // 删除方案历史扩展表
            SscSchemeHisExtPO hisExtPO = new SscSchemeHisExtPO();
            hisExtPO.setSchemeHisId(sscSchemeDo0.getSchemeHisId());
            this.sscSchemeHisExtMapper.deleteBy(hisExtPO);
        } else {
            //删除方案草稿表
            SscSchemeDraftPO draftPO = new SscSchemeDraftPO();
            draftPO.setSchemeId(sscSchemeDo0.getSchemeId());
            sscSchemeDraftMapper.deleteBy(draftPO);
            //删除方案表
            SscSchemePO schemePO = new SscSchemePO();
            schemePO.setSchemeId(sscSchemeDo0.getSchemeId());
            sscSchemeMapper.deleteBy(schemePO);
            //删除物料草稿
            SscSchemeMatDraftPO matDraftPO = new SscSchemeMatDraftPO();
            matDraftPO.setSchemeId(sscSchemeDo0.getSchemeId());
            sscSchemeMatDraftMapper.deleteBy(matDraftPO);
            //删除物料
            SscSchemeMatPO matPO = new SscSchemeMatPO();
            matPO.setSchemeId(sscSchemeDo0.getSchemeId());
            sscSchemeMatMapper.deleteBy(matPO);
            //删除方案包草稿
            SscSchemePackDraftPO packDraftPO = new SscSchemePackDraftPO();
            packDraftPO.setSchemeId(sscSchemeDo0.getSchemeId());
            sscSchemePackDraftMapper.deleteBy(packDraftPO);
            //删除方案包
            SscSchemePackPO packPO = new SscSchemePackPO();
            packPO.setSchemeId(sscSchemeDo0.getSchemeId());
            sscSchemePackMapper.deleteBy(packPO);
            //删除受邀供应商草稿
            SscSchemeInviteDraftPO inviteDraftPO = new SscSchemeInviteDraftPO();
            inviteDraftPO.setSchemeId(sscSchemeDo0.getSchemeId());
            sscSchemeInviteDraftMapper.deleteBy(inviteDraftPO);
            //删除受邀供应商
            SscSchemeInviteSupPO inviteSupPO = new SscSchemeInviteSupPO();
            inviteSupPO.setSchemeId(sscSchemeDo0.getSchemeId());
            sscSchemeInviteSupMapper.deleteBy(inviteSupPO);
            //删除方案受理记录
            SscSchemeAcceptRecordPO acceptRecordPO = new SscSchemeAcceptRecordPO();
            acceptRecordPO.setSchemeId(sscSchemeDo0.getSchemeId());
            sscSchemeAcceptRecordMapper.deleteBy(acceptRecordPO);
            // 删除附件信息
            SscAccessoryPO sscaccessorypo = new SscAccessoryPO();
            sscaccessorypo.setObjId(sscSchemeDo0.getSchemeId());
            sscAccessoryMapper.deleteBy(sscaccessorypo);
        }

    }

    @Override
    public SscSchemeDo qrySchemeDetail(SscSchemeQryBo sscSchemeQryBo0) {
        //查询方案表
        SscSchemeDo sscSchemeDo;
        SscAccessoryPO sscAccessoryPO = new SscAccessoryPO();
        // 查历史
        if (ObjectUtil.isNotNull(sscSchemeQryBo0.getSchemeHisId())) {
            // 查询方案历史信息
            SscSchemeHisPO schemeHisPOWhere = new SscSchemeHisPO();
            schemeHisPOWhere.setSchemeHisId(sscSchemeQryBo0.getSchemeHisId());
            SscSchemeHisPO schemeHisPO = sscSchemeHisMapper.getModelBy(schemeHisPOWhere);
            sscSchemeDo = SscRu.js(schemeHisPO, SscSchemeDo.class);
            if (ObjectUtil.isNull(schemeHisPO)) {
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_QUERY_SCHEME_ERROR, "方案历史查询为空");
            }
            // 查询方案包历史信息
            SscSchemePackHisPO packHisPOWhere = new SscSchemePackHisPO();
            packHisPOWhere.setSchemeHisId(sscSchemeQryBo0.getSchemeHisId());
            List<SscSchemePackHisPO> hisPOList = sscSchemePackHisMapper.getList(packHisPOWhere);
            List<SscSchemePack> schemePackList = SscRu.jsl(hisPOList, SscSchemePack.class);
            if (CollectionUtil.isNotEmpty(schemePackList)) {
                schemePackList.forEach(e -> {
                    // 设置方案包历史物资项数
                    SscSchemeMatHisPO matHisPO = new SscSchemeMatHisPO();
                    matHisPO.setPackHisId(e.getPackHisId());
                    e.setMatNum((long) sscSchemeMatHisMapper.getCheckBy(matHisPO));
                    // 设置方案包历史供应商数
                    SscSchemeInviteSupHisPO supHisPO = new SscSchemeInviteSupHisPO();
                    supHisPO.setPackHisId(e.getPackHisId());
                    e.setSupNum((long) sscSchemeInviteSupHisMapper.getCheckBy(supHisPO));
                });
            }
            sscSchemeDo.setSscSchemePack(schemePackList);

            // 查询附件信息
            sscAccessoryPO.setObjId(sscSchemeQryBo0.getSchemeHisId());
            sscAccessoryPO.setObjType(1);

        } else {
            // 查询附件信息条件
            sscAccessoryPO.setObjId(sscSchemeQryBo0.getSchemeId());
            sscAccessoryPO.setObjType(1);
            // 不是草稿
            if (Boolean.FALSE.equals(sscSchemeQryBo0.getEnableDraft())) {
                //根据方案ID查询ssc_scheme
                SscSchemePO po = SscRu.js(sscSchemeQryBo0, SscSchemePO.class);
                po.setSchemeId(sscSchemeQryBo0.getSchemeId());
                SscSchemePO modelBy = sscSchemeMapper.getModelBy(po);
                if (modelBy == null) {
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_QUERY_SCHEME_ERROR, "方案查询为空");
                }
                //保存方案信息
                sscSchemeDo = SscRu.js(modelBy, SscSchemeDo.class);
                //根据方案ID查询ssc_scheme_pack
                SscSchemePackPO packPO = new SscSchemePackPO();
                packPO.setSchemeId(sscSchemeQryBo0.getSchemeId());
                List<SscSchemePackPO> sscSchemePackPO = sscSchemePackMapper.getList(packPO);
                List<SscSchemePack> schemePackList = SscRu.jsl(sscSchemePackPO, SscSchemePack.class);
                if (CollectionUtil.isNotEmpty(schemePackList)) {
                    schemePackList.forEach(e -> {
                        // 设置方案包历史物资项数
                        SscSchemeMatPO matPO = new SscSchemeMatPO();
                        matPO.setPackId(e.getPackId());
                        e.setMatNum((long) sscSchemeMatMapper.getCheckBy(matPO));
                        // 设置方案包历史供应商数
                        SscSchemeInviteSupPO supPO = new SscSchemeInviteSupPO();
                        supPO.setPackId(e.getPackId());
                        e.setSupNum((long) sscSchemeInviteSupMapper.getCheckBy(supPO));
                    });
                }
                sscSchemeDo.setSscSchemePack(schemePackList);
            } else {
                //根据方案ID查询ssc_scheme_draft
                SscSchemeDraftPO draftPO = new SscSchemeDraftPO();
                draftPO.setSchemeId(sscSchemeQryBo0.getSchemeId());
                SscSchemeDraftPO modelBy = sscSchemeDraftMapper.getModelBy(draftPO);
                //保存方案信息
                sscSchemeDo = SscRu.js(modelBy, SscSchemeDo.class);
                //方案ID查询ssc_scheme_pack_draft
                SscSchemePackDraftPO packDraftPO = new SscSchemePackDraftPO();
                packDraftPO.setSchemeId(sscSchemeQryBo0.getSchemeId());
                List<SscSchemePackDraftPO> model = sscSchemePackDraftMapper.getList(packDraftPO);
                List<SscSchemePack> schemePackList = SscRu.jsl(model, SscSchemePack.class);
                if (CollectionUtil.isNotEmpty(schemePackList)) {
                    schemePackList.forEach(e -> {
                        // 设置方案包历史物资项数
                        SscSchemeMatDraftPO matDraftPO = new SscSchemeMatDraftPO();
                        matDraftPO.setPackId(e.getPackId());
                        e.setMatNum((long) sscSchemeMatDraftMapper.getCheckBy(matDraftPO));
                        // 设置方案包历史供应商数
                        SscSchemeInviteDraftPO supDraftPO = new SscSchemeInviteDraftPO();
                        supDraftPO.setPackId(e.getPackId());
                        e.setSupNum((long) sscSchemeInviteDraftMapper.getCheckBy(supDraftPO));
                    });
                }
                sscSchemeDo.setSscSchemePack(schemePackList);
                //保存方案包信息
            }
        }
        List<SscAccessoryPO> accessoryPO = sscAccessoryMapper.getList(sscAccessoryPO);
        List<SscAccessory> accessoryList = SscRu.jsl(accessoryPO, SscAccessory.class);
        sscSchemeDo.setSscAccessory(accessoryList);

        if (ObjectUtil.isNotNull(sscSchemeQryBo0.getSchemeId())) {
            // 查询审批流程实例id
            SscProcInstDo sscProcInstDo = new SscProcInstDo();
            sscProcInstDo.setOrderId(sscSchemeQryBo0.getSchemeId());
            SscProcInstDo proInstList = sscProcInstRepository.getProInstList(sscProcInstDo);
            List<UocOrderProcInst> taskInstList = proInstList.getSscUocOrderProcInst();
            if (CollectionUtil.isNotEmpty(taskInstList)) {
                sscSchemeDo.setAuditProclnstld(taskInstList.get(0).getProcInstId());
            }
        }
        return sscSchemeDo;
    }

    @Override
    public SscQrySchemePackListRspBO qrySchemePackList(SscSchemePackQryBo sscSchemePackQryBo) {
        SscQrySchemePackListRspBO rspBO = SscRu.success(SscQrySchemePackListRspBO.class);
        Page<?> page;
        if (ObjectUtil.isNull(sscSchemePackQryBo.getSchemeHisId()) && ObjectUtil.isNull(sscSchemePackQryBo.getSchemeHisId())) {
            // 主表
            page = new Page<SscSchemePackPO>();
            page.setPageSize(sscSchemePackQryBo.getPageSize());
            page.setPageNo(sscSchemePackQryBo.getPageNo());
            SscSchemePackPO where = SscRu.js(sscSchemePackQryBo, SscSchemePackPO.class);
            List<SscSchemePackPO> poList = sscSchemePackMapper.getListPage(where, (Page<SscSchemePackPO>) page);
            List<SscSchemePackBO> sscSchemePackBOList = SscRu.jsl(poList, SscSchemePackBO.class);
            sscSchemePackBOList.forEach(e -> {
                // 设置方案包历史物资项数
                SscSchemeMatPO matPO = new SscSchemeMatPO();
                matPO.setPackId(e.getPackId());
                e.setMatNum((long) sscSchemeMatMapper.getCheckBy(matPO));
                // 设置方案包历史供应商数
                SscSchemeInviteSupPO supPO = new SscSchemeInviteSupPO();
                supPO.setPackId(e.getPackId());
                e.setSupNum((long) sscSchemeInviteSupMapper.getCheckBy(supPO));
            });
            rspBO.setSscSchemePackList(sscSchemePackBOList);
        } else {
            // 历史表
            page = new Page<SscSchemePackHisPO>();
            page.setPageSize(sscSchemePackQryBo.getPageSize());
            page.setPageNo(sscSchemePackQryBo.getPageNo());
            SscSchemePackHisPO hisPOWhere = SscRu.js(sscSchemePackQryBo, SscSchemePackHisPO.class);
            List<SscSchemePackHisPO> hisPOList = sscSchemePackHisMapper.getListPage(hisPOWhere, (Page<SscSchemePackHisPO>) page);
            List<SscSchemePackBO> sscSchemePackBOList = SscRu.jsl(hisPOList, SscSchemePackBO.class);
            sscSchemePackBOList.forEach(e -> {
                // 设置方案包历史物资项数
                SscSchemeMatHisPO matHisPO = new SscSchemeMatHisPO();
                matHisPO.setPackHisId(e.getPackHisId());
                e.setMatNum((long) sscSchemeMatHisMapper.getCheckBy(matHisPO));
                // 设置方案包历史供应商数
                SscSchemeInviteSupHisPO supHisPO = new SscSchemeInviteSupHisPO();
                supHisPO.setPackHisId(e.getPackHisId());
                e.setSupNum((long) sscSchemeInviteSupHisMapper.getCheckBy(supHisPO));
            });
            rspBO.setSscSchemePackList(sscSchemePackBOList);
        }
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }

    @Override
    public void addSchemePackBatch(SscSchemeDo sscSchemeDo) {

    }

    @Override
    public void deleteSchemePackBatch(SscSchemeDo sscSchemeDo) {

    }

    @Override
    public SscSchemeDo qrySchemeAcceptRecordList(SscSchemeQryBo sscSchemeQryBo) {
        SscSchemeDo rspBo = new SscSchemeDo();
        SscSchemeAcceptRecordPO po = SscRu.js(sscSchemeQryBo, SscSchemeAcceptRecordPO.class);
        List<SscSchemeAcceptRecordPO> list = sscSchemeAcceptRecordMapper.getList(po);
        List<SscSchemeAcceptRecord> recordList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            recordList.addAll(SscRu.jsl(list, SscSchemeAcceptRecord.class));
        }
        rspBo.setSscSchemeAcceptRecord(recordList);
        return rspBo;
    }

    @Override
    public void deleteSchemeSingle(SscSchemeDo sscSchemeDo) {

    }

    @Override
    public void updateSchemeMain(SscSchemeDo sscSchemeDo) {
        SscSchemePO setPo = SscRu.js(sscSchemeDo, SscSchemePO.class);
        setPo.setUpdateTime(sscSchemeDo.getOperTime());
        SscSchemePO wherePo = new SscSchemePO();
        wherePo.setSchemeId(sscSchemeDo.getSchemeId());
        if (wherePo.getSchemeId() != null) {
            sscSchemeMapper.updateBy(setPo, wherePo);
        }
    }

    @Override
    public void addSchemeAcceptRecord(SscSchemeDo sscSchemeDo) {
        if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeAcceptRecord())) {
            List<SscSchemeAcceptRecordPO> sscSchemeAcceptRecordPOS = SscRu.jsl(sscSchemeDo.getSscSchemeAcceptRecord(), SscSchemeAcceptRecordPO.class);
            for (SscSchemeAcceptRecordPO po : sscSchemeAcceptRecordPOS) {
                po.setAcceptRecordId(IdUtil.nextId());
            }
            sscSchemeAcceptRecordMapper.insertBatch(sscSchemeAcceptRecordPOS);
        }
    }

    @Override
    public SscSchemeDo qrySchemeEntrustRecordList(SscSchemeEntrustRecordQryBo sscSchemeEntrustRecordQryBo) {
        SscSchemeDo rspBO = new SscSchemeDo();
        SscSchemeEntrustRecordPO po = SscRu.js(sscSchemeEntrustRecordQryBo, SscSchemeEntrustRecordPO.class);
        List<SscSchemeEntrustRecordPO> list = sscSchemeEntrustRecordMapper.getList(po);
        List<SscSchemeEntrustRecord> recordList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            recordList.addAll(SscRu.jsl(list, SscSchemeEntrustRecord.class));
        }
        rspBO.setSscSchemeEntrustRecord(recordList);
        return rspBO;
    }

    @Override
    public void addSchemeEntrustRecord(SscSchemeDo sscSchemeDo) {
        if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeEntrustRecord())) {
            List<SscSchemeEntrustRecordPO> sscSchemeEntrustRecordPOS = SscRu.jsl(sscSchemeDo.getSscSchemeEntrustRecord(), SscSchemeEntrustRecordPO.class);
            for (SscSchemeEntrustRecordPO po : sscSchemeEntrustRecordPOS) {
                po.setEntrustRecordId(IdUtil.nextId());
                po.setCreateName(sscSchemeDo.getName());
                po.setCreateUsername(sscSchemeDo.getUsername());
                po.setCreateUserId(sscSchemeDo.getUserId());
                po.setCreateTime(new Date());
            }
            sscSchemeEntrustRecordMapper.insertBatch(sscSchemeEntrustRecordPOS);
        }
    }

    @Override
    public void copySchemeToDraft(SscSchemeDo sscSchemeDo) {
        if (sscSchemeDo.getEnableDraft()) {
            //1 删除采购方案草稿表
            SscSchemeDraftPO sscSchemeDraftPO = new SscSchemeDraftPO();
            sscSchemeDraftPO.setSchemeId(sscSchemeDo.getSchemeId());
            sscSchemeDraftMapper.deleteBy(sscSchemeDraftPO);
            //2 根据方案ID将数据直接从方案表写入到方案草稿表
            SscSchemePO sscSchemePO = new SscSchemePO();
            sscSchemePO.setSchemeId(sscSchemeDo.getSchemeId());
            sscSchemeMapperUns.insertSelect(sscSchemePO, sscSchemeDo.getToken());
            //3 删除方案包草稿表
            SscSchemePackDraftPO sscSchemePackDraftPO = new SscSchemePackDraftPO();
            sscSchemePackDraftPO.setSchemeId(sscSchemeDo.getSchemeId());
            sscSchemePackDraftMapper.deleteBy(sscSchemePackDraftPO);
            //4 根据方案ID将数据直接从方案包表写入到方案包草稿表
            SscSchemePackPO sscSchemePackPO = new SscSchemePackPO();
            sscSchemePackPO.setSchemeId(sscSchemeDo.getSchemeId());
            sscSchemePackMapperUns.insertSelect(sscSchemePackPO, sscSchemeDo.getToken());
        }
        //5 删除方案物料草稿表
        SscSchemeMatDraftPO sscSchemeMatDraftPO = new SscSchemeMatDraftPO();
        sscSchemeMatDraftPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatDraftMapper.deleteBy(sscSchemeMatDraftPO);
        //6 将数据直接从方案物料信息表写入到方案物料草稿表
        SscSchemeMatPO sscSchemeMatPO = new SscSchemeMatPO();
        sscSchemeMatPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatMapperUns.copeToDraft(sscSchemeMatPO, sscSchemeDo.getToken());
        // 刪除方案物料扩展草稿
        SscSchemeMatExtDraftPO schemeMatExtDraftPO = new SscSchemeMatExtDraftPO();
        schemeMatExtDraftPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeMatExtDraftMapper.deleteBy(schemeMatExtDraftPO);
        // 将数据直接从方案物料扩展写入到方案物料扩展草稿
        sscSchemeMatMapperUns.copeToDraftExt(sscSchemeMatPO, sscSchemeDo.getToken());

        //7 删除方案邀请供应商信息表
        SscSchemeInviteDraftPO sscSchemeInviteDraftPO = new SscSchemeInviteDraftPO();
        sscSchemeInviteDraftPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteDraftMapper.deleteBy(sscSchemeInviteDraftPO);
        //8 将数据直接从方案物料信息表写入到方案邀请供应商草稿表
        SscSchemeInviteSupPO sscSchemeInviteSupPO = new SscSchemeInviteSupPO();
        sscSchemeInviteSupPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteSupMapperUns.copyToDraft(sscSchemeInviteSupPO, sscSchemeDo.getToken());
        // 删除方案邀请供应商扩展草稿
        SscSchemeInviteSupExtDraftPO supExtDraftPO = new SscSchemeInviteSupExtDraftPO();
        supExtDraftPO.setSchemeId(sscSchemeDo.getSchemeId());
        sscSchemeInviteSupExtDraftMapper.deleteBy(supExtDraftPO);
        // 将数据直接从方案邀请供应商扩展写入到方案邀请供应商扩展草稿
        sscSchemeInviteSupMapperUns.copyToDraftExt(sscSchemeInviteSupPO, sscSchemeDo.getToken());
    }

    @Override
    public void updateSchemeMatBatch(SscSchemeDo sscSchemeDo) {
        if (sscSchemeDo.getEnableDraft()) {
            if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeMat())) {
                sscSchemeDo.getSscSchemeMat().forEach(sscSchemeMat -> {
                    //set值
                    SscSchemeMatDraftPO set = SscRu.js(sscSchemeMat, SscSchemeMatDraftPO.class);
                    set.setPackId(null);
                    set.setSchemeId(null);
                    set.setToken(null);
                    //where值
                    SscSchemeMatDraftPO where = new SscSchemeMatDraftPO();
                    where.setSchemeMatId(sscSchemeMat.getSchemeMatId());
                    where.setPackId(sscSchemeMat.getPackId());
                    where.setSchemeMatIds(sscSchemeMat.getSchemeMatIds());
                    where.setSchemeId(sscSchemeDo.getSchemeId());
                    where.setToken(sscSchemeDo.getToken());
                    sscSchemeMatDraftMapper.updateBy(set, where);
                });
            }
        } else {
            if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeMat())) {
                sscSchemeDo.getSscSchemeMat().forEach(sscSchemeMat -> {
                    //set值
                    SscSchemeMatPO set = SscRu.js(sscSchemeMat, SscSchemeMatPO.class);
                    set.setPackId(null);
                    set.setSchemeId(null);
                    //where值
                    SscSchemeMatPO where = new SscSchemeMatPO();
                    where.setPackId(sscSchemeMat.getPackId());
                    where.setSchemeMatId(sscSchemeMat.getSchemeMatId());
                    where.setSchemeId(sscSchemeDo.getSchemeId());
                    sscSchemeMatMapper.updateBy(set, where);
                });
            }
        }
    }

    @Override
    public void setSchemeMatNullValue(SscSchemeDo sscSchemeDo) {
        if (sscSchemeDo.getEnableDraft()) {
            if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeMat())) {
                sscSchemeDo.getSscSchemeMat().forEach(ssm -> {
                    //set值
                    SscSchemeMatDraftPO set = SscRu.js(ssm, SscSchemeMatDraftPO.class);
                    set.setSchemeId(null);
                    set.setToken(null);
                    //where值
                    SscSchemeMatDraftPO where = new SscSchemeMatDraftPO();
                    where.setSchemeId(sscSchemeDo.getSchemeId());
                    where.setToken(sscSchemeDo.getToken());
                    where.setPlanId(ssm.getPlanId());
                    sscSchemeMatMapperUns.updateSchemeMatDraft(set, where);
                });
            }
        } else {
            if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeMat())) {
                sscSchemeDo.getSscSchemeMat().forEach(ssm -> {
                    //set值
                    SscSchemeMatPO set = SscRu.js(ssm, SscSchemeMatPO.class);
                    set.setSchemeId(null);
                    //where值
                    SscSchemeMatPO where = new SscSchemeMatPO();
                    where.setSchemeId(sscSchemeDo.getSchemeId());
                    sscSchemeMatMapperUns.updateSchemeMat(set, where);
                });
            }
        }
    }

    @Override
    public SscQrySchemeVersionListRspBO qrySchemeVersionList(SscSchemeQryBo sscSchemeQryBo) {
        SscQrySchemeVersionListRspBO rspBO = new SscQrySchemeVersionListRspBO();
        Page<SscSchemeHisPO> page = new Page<>();
        page.setPageSize(sscSchemeQryBo.getPageSize());
        page.setPageNo(sscSchemeQryBo.getPageNo());
        SscSchemeHisPO where = new SscSchemeHisPO();
        where.setSchemeId(sscSchemeQryBo.getSchemeId());
        List<SscSchemeHisPO> schemeHisPOList = sscSchemeHisMapper.getListPage(where, page);
        rspBO.setSscSchemeVersion(JUtil.jsl(schemeHisPOList, SscSchemeVersionBo.class));
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }

    @Override
    public void schemeChange(SscSchemeDo sscSchemeDo) {
        // 根据方案id查询方案信息
        SscSchemePO sscSchemePOWhere = new SscSchemePO();
        sscSchemePOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        SscSchemePO sscSchemePO = sscSchemeMapper.getModelBy(sscSchemePOWhere);
        // 修改审批状态为草稿 方案状态为已变更
        SscSchemePO schemePOWhere = new SscSchemePO();
        schemePOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        SscSchemePO schemePOSet = new SscSchemePO();
        schemePOSet.setSchemeAuditStatus(SscCommConstant.SchemeAuditStatus.DRAW.getCode());
        schemePOSet.setSchemeStatus(SscCommConstant.SchemeStatus.CHANGE.getCode());
        // 版本号 + 1
        int versionNum = Integer.parseInt(sscSchemePO.getSchemeVersion().replace("v", "").replace(".", "")) + 1;
        schemePOSet.setSchemeVersion(getVersion(versionNum));
        schemePOSet.setUpdateTime(new Date());
        sscSchemeMapper.updateBy(schemePOSet, schemePOWhere);
        // 清空执行人
        SscSchemePO impl = new SscSchemePO();
        impl.setSchemeId(sscSchemeDo.getSchemeId());
        impl.setImplId(-1L);
        impl.setImplName("");
        sscSchemeMapperUns.updateImpl(impl);
        // 新增方案历史信息
        SscSchemeHisPO sscSchemeHisPO = JUtil.js(sscSchemePO, SscSchemeHisPO.class);
        // 简易、集采、采购、设置方案编码(方案编码_(版本号数值-101))
        if (SscCommConstant.SchemeTypeEnum.SIMPLE.getCode().equals(sscSchemePO.getSchemeType()) ||
                SscCommConstant.SchemeTypeEnum.PURCHASE.getCode().equals(sscSchemePO.getSchemeType()) ||
                SscCommConstant.SchemeTypeEnum.FOCUS.getCode().equals(sscSchemePO.getSchemeType())) {
            sscSchemeHisPO.setSchemeCode(sscSchemeHisPO.getSchemeCode() + "_" + (versionNum - 101));
        }

        long schemeHisId = IdUtil.nextId();
        sscSchemeHisPO.setSchemeHisId(schemeHisId);
        // 设置审批时间
        UocOrderTaskInstPO instPO = new UocOrderTaskInstPO();
        instPO.setOrderId(sscSchemePO.getSchemeId());
        instPO.setFinishTag(SscCommConstant.YesOrNoEnum.YES.getCode());
        List<UocOrderTaskInstPO> instPOList = uocOrderTaskInstMapper.getList(instPO);
        instPOList.stream().filter(e -> ObjectUtil.isNotNull(e.getFinishTime())).max(Comparator.comparing(UocOrderTaskInstPO::getFinishTime)).ifPresent(e -> sscSchemeHisPO.setAuditTime(e.getFinishTime()));
        sscSchemeHisMapper.insert(sscSchemeHisPO);
        // 新增方案扩展历史信息
        SscSchemeExtPO sscSchemeExtPO = new SscSchemeExtPO();
        sscSchemeExtPO.setSchemeId(sscSchemeDo.getSchemeId());
        List<SscSchemeExtPO> schemeExtPOList = sscSchemeExtMapper.getList(sscSchemeExtPO);
        if (CollectionUtil.isNotEmpty(schemeExtPOList)) {
            List<SscSchemeHisExtPO> extPOList = schemeExtPOList.stream().map(e -> {
                SscSchemeHisExtPO schemeHisExtPO = SscRu.js(e, SscSchemeHisExtPO.class);
                schemeHisExtPO.setExtId(IdUtil.nextId());
                schemeHisExtPO.setSchemeHisId(schemeHisId);
                return schemeHisExtPO;
            }).collect(Collectors.toList());
            sscSchemeHisExtMapper.insertBatch(extPOList);
        }
        // 根据方案id查询方案标段信息
        SscSchemePackPO sscSchemePackPOWhere = new SscSchemePackPO();
        sscSchemePackPOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        List<SscSchemePackPO> packPOList = sscSchemePackMapper.getList(sscSchemePackPOWhere);
        // 新增标段历史信息
        Map<Long, Long> packIdPackHisIdMap = null;
        if (CollectionUtil.isNotEmpty(packPOList)) {
            List<SscSchemePackHisPO> packHisList = packPOList.stream().map(e -> {
                SscSchemePackHisPO schemePackHisPO = JUtil.js(e, SscSchemePackHisPO.class);
                long packHisId = IdUtil.nextId();
                schemePackHisPO.setSchemeHisId(schemeHisId);
                schemePackHisPO.setPackHisId(packHisId);
                return schemePackHisPO;
            }).collect(Collectors.toList());
            sscSchemePackHisMapper.insertBatch(packHisList);
            packIdPackHisIdMap = packHisList.stream().collect(Collectors.toMap(SscSchemePackHisPO::getPackId, SscSchemePackHisPO::getPackHisId, (a, b) -> a));

            // 新增方案包扩展历史信息
            SscSchemePackExtPO packExtPO = new SscSchemePackExtPO();
            packExtPO.setSchemeId(sscSchemeDo.getSchemeId());
            List<SscSchemePackExtPO> schemeMatExtMapperList = sscSchemePackExtMapper.getList(packExtPO);
            if (CollectionUtil.isNotEmpty(schemeMatExtMapperList)) {
                final Map<Long, Long> finalPackIdPackHisIdMap = packIdPackHisIdMap;
                List<SscSchemePackHisExtPO> extPOList = schemeMatExtMapperList.stream().map(e -> {
                    SscSchemePackHisExtPO packHisExtPO = SscRu.js(e, SscSchemePackHisExtPO.class);
                    packHisExtPO.setExtId(IdUtil.nextId());
                    packHisExtPO.setPackHisId(finalPackIdPackHisIdMap.get(e.getPackId()));
                    return packHisExtPO;
                }).collect(Collectors.toList());
                sscSchemePackHisExtMapper.insertBatch(extPOList);
            }
        }
        // 根据方案id查询方案物料信息
        SscSchemeMatPO sscSchemeMatPOWhere = new SscSchemeMatPO();
        sscSchemeMatPOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        List<SscSchemeMatPO> sscSchemeMatPOList = sscSchemeMatMapper.getList(sscSchemeMatPOWhere);
        // 新增方案物料历史信息
        if (CollectionUtil.isNotEmpty(sscSchemeMatPOList)) {
            final Map<Long, Long> finalPackIdPackHisIdMap = packIdPackHisIdMap;
            List<SscSchemeMatHisPO> schemeMatHisPOList = sscSchemeMatPOList.stream().map(e -> {
                SscSchemeMatHisPO sscSchemeMatHisPO = JUtil.js(e, SscSchemeMatHisPO.class);
                if (MapUtil.isNotEmpty(finalPackIdPackHisIdMap)) {
                    sscSchemeMatHisPO.setPackHisId(finalPackIdPackHisIdMap.get(e.getPackId()));
                }
                sscSchemeMatHisPO.setSchemeHisId(schemeHisId);
                sscSchemeMatHisPO.setSchemeMatHisId(IdUtil.nextId());
                return sscSchemeMatHisPO;
            }).collect(Collectors.toList());
            sscSchemeMatHisMapper.insertBatch(schemeMatHisPOList);

            // 新增方案明细扩展历史信息
            SscSchemeMatExtPO sscSchemeMatExtPO = new SscSchemeMatExtPO();
            sscSchemeMatExtPO.setSchemeId(sscSchemeDo.getSchemeId());
            List<SscSchemeMatExtPO> schemeMatExtMapperList = sscSchemeMatExtMapper.getList(sscSchemeMatExtPO);
            if (CollectionUtil.isNotEmpty(schemeMatExtMapperList)) {
                Map<Long, Long> matIdMatHisIdMap = schemeMatHisPOList.stream().collect(Collectors.toMap(SscSchemeMatHisPO::getSchemeMatId, SscSchemeMatHisPO::getSchemeMatHisId, (a, b) -> a));
                List<SscSchemeMatHisExtPO> extPOList = schemeMatExtMapperList.stream().map(e -> {
                    SscSchemeMatHisExtPO sscSchemeMatHisExtPO = SscRu.js(e, SscSchemeMatHisExtPO.class);
                    sscSchemeMatHisExtPO.setExtId(IdUtil.nextId());
                    sscSchemeMatHisExtPO.setSchemeMatHisId(matIdMatHisIdMap.get(e.getSchemeMatId()));
                    return sscSchemeMatHisExtPO;
                }).collect(Collectors.toList());
                sscSchemeMatHisExtMapper.insertBatch(extPOList);
            }
        }

        // 根据方案id查询方案邀请供应商信息
        SscSchemeInviteSupPO schemeInviteSupPOWhere = new SscSchemeInviteSupPO();
        schemeInviteSupPOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        List<SscSchemeInviteSupPO> supPOList = sscSchemeInviteSupMapper.getList(schemeInviteSupPOWhere);
        // 新增方案邀请供应商历史信息
        if (CollectionUtil.isNotEmpty(supPOList)) {
            final Map<Long, Long> finalPackIdPackHisIdMap = packIdPackHisIdMap;
            List<SscSchemeInviteSupHisPO> supHisPOList = supPOList.stream().map(e -> {
                SscSchemeInviteSupHisPO schemeInviteSupHisPO = JUtil.js(e, SscSchemeInviteSupHisPO.class);
                if (MapUtil.isNotEmpty(finalPackIdPackHisIdMap)) {
                    schemeInviteSupHisPO.setPackHisId(finalPackIdPackHisIdMap.get(e.getPackId()));
                }
                schemeInviteSupHisPO.setSchemeHisId(schemeHisId);
                schemeInviteSupHisPO.setSchemeInviteSupHisId(IdUtil.nextId());
                return schemeInviteSupHisPO;
            }).collect(Collectors.toList());
            sscSchemeInviteSupHisMapper.insertBatch(supHisPOList);

            // 新增供应商扩展历史
            SscSchemeInviteSupExtPO supExtPO = new SscSchemeInviteSupExtPO();
            supExtPO.setSchemeId(sscSchemeDo.getSchemeId());
            List<SscSchemeInviteSupExtPO> supExtPOList = sscSchemeInviteSupExtMapper.getList(supExtPO);
            if (CollectionUtil.isNotEmpty(supExtPOList)) {
                Map<Long, Long> supIdSupHisIdMap = supHisPOList.stream().collect(Collectors.toMap(SscSchemeInviteSupHisPO::getSchemeInviteSupId, SscSchemeInviteSupHisPO::getSchemeInviteSupHisId));
                List<SscSchemeInviteSupHisExtPO> supHisExtPOList = supExtPOList.stream().map(e -> {
                    SscSchemeInviteSupHisExtPO supHisExtPO = SscRu.js(e, SscSchemeInviteSupHisExtPO.class);
                    supHisExtPO.setSchemeInviteSupHisId(supIdSupHisIdMap.get(e.getSchemeInviteSupId()));
                    return supHisExtPO;
                }).collect(Collectors.toList());
                sscSchemeInviteSupHisExtMapper.insertBatch(supHisExtPOList);
            }
        }
        // 根据方案id查询附件信息
        SscAccessoryPO accessoryPO = new SscAccessoryPO();
        accessoryPO.setObjType(1);
        accessoryPO.setObjId(sscSchemeDo.getSchemeId());
        List<SscAccessoryPO> accessoryPOList = sscAccessoryMapper.getList(accessoryPO);
        if (CollectionUtil.isNotEmpty(accessoryPOList)) {
            // 新增方案附件历史信息
            accessoryPOList.forEach(e -> {
                e.setId(IdUtil.nextId());
                e.setObjId(schemeHisId);
            });
            sscAccessoryMapper.insertBatch(accessoryPOList);
        }

    }

    @Override
    public void addSchemeHis() {

    }

    @Override
    public void schemePutUp(SscSchemeDo sscSchemeDo) {
        // 查询方案信息
        SscSchemePO where = new SscSchemePO();
        where.setSchemeId(sscSchemeDo.getSchemeId());
        SscSchemePO sscSchemePO = sscSchemeMapper.getModelBy(where);
        // 修改方案状态
        SscSchemePO sscSchemePOWhere = new SscSchemePO();
        sscSchemePOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        SscSchemePO sscSchemePOSet = new SscSchemePO();
        sscSchemePOSet.setSchemeStatus(sscSchemeDo.getSchemeStatus());
        sscSchemeMapper.updateBy(sscSchemePOSet, sscSchemePOWhere);

        // 新增方案变更信息
        List<SscSchemeChangeBO> sscSchemeChange = sscSchemeDo.getSscSchemeChange();
        if (CollectionUtil.isNotEmpty(sscSchemeChange)) {
            for (SscSchemeChangeBO changeBO : sscSchemeChange) {
                SscSchemeStatusChngPO chngPO = new SscSchemeStatusChngPO();
                long chngId = IdUtil.nextId();
                chngPO.setId(chngId);
                chngPO.setSchemeId(sscSchemeDo.getSchemeId());
                chngPO.setOldSchemeStatus(sscSchemePO.getSchemeStatus());
                chngPO.setNewSchemeStatus(sscSchemeDo.getSchemeStatus());
                chngPO.setReason(changeBO.getReason());
                chngPO.setOperType(changeBO.getOperType());
                chngPO.setCreateTime(new Date());
                chngPO.setCreateName(sscSchemeDo.getCreateName());
                chngPO.setCreateLoginId(sscSchemeDo.getCreateLoginId());
                chngPO.setCreateUsername(sscSchemeDo.getCreateUsername());
                sscSchemeStatusChngMapper.insert(chngPO);
                // 新增附件信息
                insertAccessory(chngId, chngId, sscSchemeDo, changeBO.getSscAccessory());
            }
        }
    }

    @Override
    public void schemeCancelPutUp(SscSchemeDo sscSchemeDo) {
        // 查询已挂起的信息(operType = 0)
        SscSchemeStatusChngPO where = new SscSchemeStatusChngPO();
        where.setSchemeId(sscSchemeDo.getSchemeId());
        where.setOperType(SscCommConstant.OperTypeEnum.PUT_UP.getCode());
        List<SscSchemeStatusChngPO> chngPOList = sscSchemeStatusChngMapper.getList(where);
        // 获取最新一条信息
        List<SscSchemeStatusChngPO> chngPOSortList = chngPOList.stream().sorted(Comparator.comparing(SscSchemeStatusChngPO::getCreateTime).reversed()).collect(Collectors.toList());
        String oldSchemeStatus = chngPOSortList.get(0).getOldSchemeStatus();
        // 修改方案状态
        SscSchemePO schemePOWhere = new SscSchemePO();
        schemePOWhere.setSchemeId(sscSchemeDo.getSchemeId());
        SscSchemePO schemePOSet = new SscSchemePO();
        schemePOSet.setSchemeStatus(oldSchemeStatus);
        sscSchemeMapper.updateBy(schemePOSet, schemePOWhere);
    }

    @Override
    public void updateImpl(SscSchemeDo sscSchemeDo) {
        sscSchemeMapperUns.updateImpl(SscRu.js(sscSchemeDo, SscSchemePO.class));
    }

    @Override
    public SscSchemeDo qrySchemeChangeList(SscSchemeQryBo sscSchemeQryBo) {
        SscSchemeStatusChngPO where = new SscSchemeStatusChngPO();
        where.setSchemeId(sscSchemeQryBo.getSchemeId());
        where.setOperType(sscSchemeQryBo.getOperType());
        List<SscSchemeStatusChngPO> chngPOList = sscSchemeStatusChngMapper.getList(where);
        // 附件信息
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        List<SscSchemeChangeBO> changeBOList = SscRu.jsl(chngPOList, SscSchemeChangeBO.class);
        for (SscSchemeChangeBO bo : changeBOList) {
            SscAccessoryPO accessoryPOWhere = new SscAccessoryPO();
            accessoryPOWhere.setObjId(bo.getId());
            List<SscAccessoryPO> accessoryPOList = sscAccessoryMapper.getList(accessoryPOWhere);
            bo.setSscAccessory(SscRu.jsl(accessoryPOList, SscAccessory.class));
        }
        sscSchemeDo.setSscSchemeChange(changeBOList);
        return sscSchemeDo;
    }

    @Override
    public void updatePackMain(SscSchemeDo sscSchemeDo) {
        List<SscSchemePack> schemePackList = sscSchemeDo.getSscSchemePack();
        if (CollectionUtil.isNotEmpty(schemePackList)) {
            List<SscSchemePackPO> schemePackPOList = SscRu.jsl(schemePackList, SscSchemePackPO.class);
            for (SscSchemePackPO po : schemePackPOList) {
                SscSchemePackPO where = new SscSchemePackPO();
                where.setPackId(po.getPackId());
                sscSchemePackMapper.updateBy(po, where);
            }
        }
    }

    @Override
    public void dealSchemeEnd(SscSchemeDo sscSchemeDo) {
        this.schemePutUp(sscSchemeDo);
    }

    @Override
    public void addSchemeChangeInfo(SscSchemeDo sscSchemeDo) {
        // 查询方案信息
        SscSchemePO schemeWhere = new SscSchemePO();
        schemeWhere.setSchemeId(sscSchemeDo.getSchemeId());
        SscSchemePO schemePO = sscSchemeMapper.getModelBy(schemeWhere);
        for (SscSchemeChangeBO changeBO : sscSchemeDo.getSscSchemeChange()) {
            SscSchemeStatusChngPO chngPO = SscRu.js(changeBO, SscSchemeStatusChngPO.class);
            long chngPOId = IdUtil.nextId();
            chngPO.setId(chngPOId);
            chngPO.setCreateTime(new Date());
            chngPO.setCreateLoginId(sscSchemeDo.getCreateLoginId());
            chngPO.setCreateUsername(sscSchemeDo.getCreateUsername());
            chngPO.setCreateName(sscSchemeDo.getCreateName());
            if (SscCommConstant.OperTypeEnum.PUT_UP.getCode().equals(changeBO.getOperType())) {
                // 挂起，oldSchemeStatus = schemeStatus
                chngPO.setOldSchemeStatus(schemePO.getSchemeStatus());
            } else if (SscCommConstant.OperTypeEnum.END.getCode().equals(changeBO.getOperType())) {
                // 终止，oldSchemeStatus = schemeStatus
                chngPO.setOldSchemeStatus(schemePO.getSchemeStatus());
            } else if (SscCommConstant.OperTypeEnum.AUDIT_PURCHASE_TYPE.getCode().equals(changeBO.getOperType())) {
                // 审批采购方式，oldSchemeStatus = purchaseTypeZ
                chngPO.setOldSchemeStatus(String.valueOf(schemePO.getPurchaseType()));
            }
            sscSchemeStatusChngMapper.insert(chngPO);
            insertAccessory(chngPOId, chngPOId, sscSchemeDo, changeBO.getSscAccessory());
        }
    }

    @Override
    public SscQrySchemeMainInfoListRspBO qrySchemeMainInfoList(SscQrySchemeMainInfoListReqBO sscQrySchemeMainInfoListReqBO) {
        SscQrySchemeMainInfoListRspBO rspBO = new SscQrySchemeMainInfoListRspBO();
        SscSchemePO where = SscRu.js(sscQrySchemeMainInfoListReqBO, SscSchemePO.class);
        List<SscSchemePO> schemePOList = sscSchemeMapper.getList(where);
        rspBO.setSscQrySchemeMainInfoList(SscRu.jsl(schemePOList, SscQrySchemeMainInfoBO.class));
        return rspBO;
    }

    @Override
    public SscQrySchemeChangeListBatchRspBO qrySchemeChangeListBatch(SscQrySchemeChangeListBatchReqBO sscQrySchemeChangeListBatchReqBO) {
        SscQrySchemeChangeListBatchRspBO rspBO = new SscQrySchemeChangeListBatchRspBO();
        SscSchemeStatusChngPO where = SscRu.js(sscQrySchemeChangeListBatchReqBO, SscSchemeStatusChngPO.class);
        List<SscSchemeStatusChngPO> statusChngPOS = sscSchemeStatusChngMapper.getList(where);
        rspBO.setSscSchemeChange(SscRu.jsl(statusChngPOS, SscSchemeChangeBO.class));
        return rspBO;
    }

    @Override
    public SscSchemeDo setEsMount(SscSetSchemeMatNullValueBatchReqBO reqBO) {
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        BigDecimal estAmount = BigDecimal.ZERO;
        if (Boolean.TRUE.equals(reqBO.getEstAmountFlag())) {
            if (reqBO.getEnableDraft()) {
                // 根据方案id查询方案物料明细草稿表
                SscSchemeMatDraftPO where = new SscSchemeMatDraftPO();
                where.setSchemeId(reqBO.getSchemeId());
                List<SscSchemeMatDraftPO> schemeMatDraftPOList = this.sscSchemeMatDraftMapper.getList(where);
                for (SscSchemeMatDraftPO po : schemeMatDraftPOList) {
                    // 设置金额
                    if (ObjectUtil.isNotNull(po.getNoTaxPrice()) && ObjectUtil.isNotNull(po.getTaxRate()) && ObjectUtil.isNotNull(po.getPurchaseNum())) {
                        BigDecimal total = po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).multiply(po.getPurchaseNum());
                        estAmount = estAmount.add(total);
                    }
                }
            }
        }
        sscSchemeDo.setEstAmount(estAmount);
        return sscSchemeDo;
    }

    private String getVersion(int versionNum) {
        return "v" + Arrays.stream(ArrayUtil.wrap(Integer.toString(versionNum).toCharArray())).map(String::valueOf).collect(Collectors.joining("."));
    }

    public void insertAccessory(Long objId, Long orderId, SscSchemeDo sscSchemeDo, List<SscAccessory> sscAccessory) {
        if (CollectionUtil.isNotEmpty(sscAccessory)) {
            List<SscAccessoryPO> accessoryPOList = sscAccessory.stream().map(e -> {
                SscAccessoryPO accessoryPO = new SscAccessoryPO();
                accessoryPO.setObjId(objId);
                accessoryPO.setOrderId(orderId);
                accessoryPO.setAccessoryId(String.valueOf(IdUtil.nextId()));
                accessoryPO.setId(IdUtil.nextId());
                accessoryPO.setObjType(1);
                accessoryPO.setAttachmentType(e.getAttachmentType());
                accessoryPO.setAccessoryUrl(e.getAccessoryUrl());
                accessoryPO.setAccessoryName(e.getAccessoryName());
                accessoryPO.setCreateName(sscSchemeDo.getName());
                accessoryPO.setCreateTime(new Date());
                accessoryPO.setCreateLoginId(sscSchemeDo.getUserId());
                accessoryPO.setCreateUsername(sscSchemeDo.getUsername());
                accessoryPO.setDelTag(SscCommConstant.YesOrNoEnum.NO.getCode());
                return accessoryPO;
            }).collect(Collectors.toList());
            sscAccessoryMapper.insertBatch(accessoryPOList);
        }
    }

}
