package com.tydic.dyc.ssc.repository.impl;


import com.tydic.dyc.ssc.model.auditorder.SscAuditOrderDo;
import com.tydic.dyc.ssc.model.auditorder.qrybo.SscAuditOrderQryBo;
import com.tydic.dyc.ssc.model.auditorder.sub.UocApprovalObj;
import com.tydic.dyc.ssc.repository.SscAuditOrderRepository;
import com.tydic.dyc.ssc.repository.dao.UocApprovalObjMapper;
import com.tydic.dyc.ssc.repository.dao.UocAuditOrderMapper;
import com.tydic.dyc.ssc.repository.po.UocApprovalObjPO;
import com.tydic.dyc.ssc.repository.po.UocAuditOrderPO;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:SscAuditOrderRepositoryImpl
 * 说明:TODO
 * 时间:2022/9/2 11:59
 * 作者:代愿愿
 */
@Slf4j
@Service
public class SscAuditOrderRepositoryImpl implements SscAuditOrderRepository {

    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;

    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;

    @Override
    public void saveAuditOrder(SscAuditOrderDo sscAuditOrderDo) {
        UocAuditOrderPO uocAuditOrderPO = SscRu.js(sscAuditOrderDo, UocAuditOrderPO.class);
        uocAuditOrderMapper.insert(uocAuditOrderPO);
        if(!CollectionUtils.isEmpty(sscAuditOrderDo.getUocApprovalObj())){
            List<UocApprovalObjPO> uocApprovalObjPOS = new ArrayList<>();
            sscAuditOrderDo.getUocApprovalObj().forEach(uocApprovalObj -> {
                UocApprovalObjPO po = SscRu.js(uocApprovalObj,UocApprovalObjPO.class);
                po.setAuditOrderId(sscAuditOrderDo.getAuditOrderId());
                po.setId(IdUtil.nextId());
                po.setOrderId(sscAuditOrderDo.getOrderId());
                uocApprovalObjPOS.add(po);
            });
            uocApprovalObjMapper.insertBatch(uocApprovalObjPOS);
        }
    }

    @Override
    public SscAuditOrderDo getAuditObj(SscAuditOrderQryBo sscAuditOrderQryBo) {
        UocApprovalObjPO uocApprovalObjPO = SscRu.js(sscAuditOrderQryBo,UocApprovalObjPO.class) ;
        List<UocApprovalObjPO> pos =  uocApprovalObjMapper.getList(uocApprovalObjPO);
        List<UocApprovalObj> uocApprovalObj = SscRu.jsl(pos,UocApprovalObj.class);
        SscAuditOrderDo sscAuditOrderDo = new SscAuditOrderDo();
        sscAuditOrderDo.setUocApprovalObj(uocApprovalObj);
        return sscAuditOrderDo;
    }
}
