package com.tydic.dyc.ssc.repository.impl;

import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.repository.SscCommonRepository;
import com.tydic.dyc.ssc.repository.dao.*;
import com.tydic.dyc.ssc.repository.po.*;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:SscCommonRepositoryImpl
 * 说明:TODO
 * 时间:2023/3/13 11:16
 * 作者:代愿愿
 */
@Service
class SscCommonRepositoryImpl implements SscCommonRepository {
    @Autowired
    private SscSchemeExtMapper sscSchemeExtMapper;
    @Autowired
    private SscSchemeMatExtMapper sscSchemeMatExtMapper;
    @Autowired
    private SscSchemePackExtMapper sscSchemePackExtMapper;
    @Autowired
    private SscSchemeInviteSupExtMapper sscSchemeInviteSupExtMapper;

    @Autowired
    private SscSchemeHisExtMapper sscSchemeHisExtMapper;

    @Autowired
    private SscSchemeMatHisExtMapper sscSchemeMatHisExtMapper;

    @Autowired
    private SscSchemePackHisExtMapper sscSchemePackHisExtMapper;

    @Autowired
    private SscSchemeInviteSupHisExtMapper sscSchemeInviteSupHisExtMapper;

    @Autowired
    private SscSchemeInviteSupExtDraftMapper sscSchemeInviteSupExtDraftMapper;

    @Autowired
    private SscSchemeMatExtDraftMapper sscSchemeMatExtDraftMapper;

    @Override
    public void addExtInfo(SscCommonDo sscCommonDo) {
        if (!CollectionUtils.isEmpty(sscCommonDo.getExtObjInfos())) {
            sscCommonDo.getExtObjInfos().forEach(sscExtObjInfo -> {
                // 方案扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT)) {
                    List<SscSchemeExtPO> sscSchemeExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeExtPO.class);
                    sscSchemeExtPOS.forEach(sscSchemeExtPO -> {
                        sscSchemeExtPO.setSchemeExtId(IdUtil.nextId());
                        sscSchemeExtPO.setSchemeId(sscExtObjInfo.getObjId());
                    });
                    sscSchemeExtMapper.insertBatch(sscSchemeExtPOS);
                }
                // 方案扩展历史
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_HIS_EXT)) {
                    List<SscSchemeHisExtPO> sscSchemeHisExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeHisExtPO.class);
                    sscSchemeHisExtPOS.forEach(sscSchemeHisExtPO -> {
                        sscSchemeHisExtPO.setExtId(IdUtil.nextId());
                        sscSchemeHisExtPO.setSchemeHisId(sscExtObjInfo.getObjId());
                        sscSchemeHisExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                    });
                    sscSchemeHisExtMapper.insertBatch(sscSchemeHisExtPOS);
                }
                // 方案标段扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT)) {
                    List<SscSchemePackExtPO> sscSchemePackExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemePackExtPO.class);
                    sscSchemePackExtPOS.forEach(sscSchemePackExtPO -> {
                        sscSchemePackExtPO.setExtId(IdUtil.nextId());
                        sscSchemePackExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                        sscSchemePackExtPO.setPackId(sscExtObjInfo.getObjId());
                    });
                    sscSchemePackExtMapper.insertBatch(sscSchemePackExtPOS);
                }
                // 方案标段历史扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_HIS_EXT)) {
                    List<SscSchemePackHisExtPO> sscSchemePackHisExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemePackHisExtPO.class);
                    sscSchemePackHisExtPOS.forEach(sscSchemePackHisExtPO -> {
                        sscSchemePackHisExtPO.setExtId(IdUtil.nextId());
                        sscSchemePackHisExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                        sscSchemePackHisExtPO.setPackHisId(sscExtObjInfo.getObjId());
                    });
                    sscSchemePackHisExtMapper.insertBatch(sscSchemePackHisExtPOS);
                }
                // 物料明细扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT)) {
                    List<SscSchemeMatExtPO> sscSchemeMatExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeMatExtPO.class);
                    sscSchemeMatExtPOS.forEach(sscSchemeMatExtPO -> {
                        sscSchemeMatExtPO.setSchemeMatExtId(IdUtil.nextId());
                        sscSchemeMatExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                        sscSchemeMatExtPO.setSchemeMatId(sscExtObjInfo.getObjId());
                    });
                    sscSchemeMatExtMapper.insertBatch(sscSchemeMatExtPOS);
                }
                // 物料明细扩展草稿
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT)) {
                    List<SscSchemeMatExtDraftPO> sscSchemeMatExtDraftPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeMatExtDraftPO.class);
                    sscSchemeMatExtDraftPOS.forEach(sscSchemeMatExtPO -> {
                        sscSchemeMatExtPO.setSchemeMatExtId(IdUtil.nextId());
                        sscSchemeMatExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                        sscSchemeMatExtPO.setSchemeMatId(sscExtObjInfo.getObjId());
                    });
                    sscSchemeMatExtDraftMapper.insertBatch(sscSchemeMatExtDraftPOS);
                }
                // 供应商扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT)) {
                    List<SscSchemeInviteSupExtPO> sscSchemeInviteSupExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeInviteSupExtPO.class);
                    sscSchemeInviteSupExtPOS.forEach(sscSchemeInviteSupExtPO -> {
                        sscSchemeInviteSupExtPO.setExtId(IdUtil.nextId());
                        sscSchemeInviteSupExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                        sscSchemeInviteSupExtPO.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                    });
                    sscSchemeInviteSupExtMapper.insertBatch(sscSchemeInviteSupExtPOS);
                }
                // 供应商扩展草稿
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT)) {
                    List<SscSchemeInviteSupExtDraftPO> sscSchemeInviteSupExtDraftPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeInviteSupExtDraftPO.class);
                    sscSchemeInviteSupExtDraftPOS.forEach(sscSchemeInviteSupExtPO -> {
                        sscSchemeInviteSupExtPO.setExtId(IdUtil.nextId());
                        sscSchemeInviteSupExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                        sscSchemeInviteSupExtPO.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                    });
                    sscSchemeInviteSupExtDraftMapper.insertBatch(sscSchemeInviteSupExtDraftPOS);
                }
                // 供应商历史扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT)) {
                    List<SscSchemeInviteSupHisExtPO> sscSchemeInviteSupHisExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeInviteSupHisExtPO.class);
                    sscSchemeInviteSupHisExtPOS.forEach(sscSchemeInviteSupHisExtPO -> {
                        sscSchemeInviteSupHisExtPO.setExtId(IdUtil.nextId());
                        sscSchemeInviteSupHisExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                        sscSchemeInviteSupHisExtPO.setSchemeInviteSupHisId(sscExtObjInfo.getObjId());
                    });
                    sscSchemeInviteSupHisExtMapper.insertBatch(sscSchemeInviteSupHisExtPOS);
                }
            });
        }

    }

    @Override
    public void updateExtInfo(SscCommonDo sscCommonDo) {
        if (!CollectionUtils.isEmpty(sscCommonDo.getExtObjInfos())) {
            sscCommonDo.getExtObjInfos().forEach(sscExtObjInfo -> {
                // 方案扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeExtPO where = new SscSchemeExtPO();
                        where.setSchemeId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeExtPO set = new SscSchemeExtPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeExtMapper.updateBy(set, where);
                    });
                }
                // 方案标段扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemePackExtPO where = new SscSchemePackExtPO();
                        where.setPackId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemePackExtPO set = new SscSchemePackExtPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemePackExtMapper.updateBy(set, where);
                    });
                }
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeMatExtPO where = new SscSchemeMatExtPO();
                        where.setSchemeMatId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeMatExtPO set = new SscSchemeMatExtPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeMatExtMapper.updateBy(set, where);
                    });
                }
                // 物料明细扩展草稿
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeMatExtDraftPO where = new SscSchemeMatExtDraftPO();
                        where.setSchemeMatId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeMatExtDraftPO set = new SscSchemeMatExtDraftPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeMatExtDraftMapper.updateBy(set, where);
                    });
                }
                // 供应商扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeInviteSupExtPO where = new SscSchemeInviteSupExtPO();
                        where.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeInviteSupExtPO set = new SscSchemeInviteSupExtPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeInviteSupExtMapper.updateBy(set, where);
                    });
                }
                // 供应商草稿扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeInviteSupExtDraftPO where = new SscSchemeInviteSupExtDraftPO();
                        where.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeInviteSupExtDraftPO set = new SscSchemeInviteSupExtDraftPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeInviteSupExtDraftMapper.updateBy(set, where);
                    });
                }
            });
        }
    }

    @Override
    public void deleteExtInfo(SscCommonDo sscCommonDo) {
        if (!CollectionUtils.isEmpty(sscCommonDo.getExtObjInfos())) {
            sscCommonDo.getExtObjInfos().forEach(sscExtObjInfo -> {
                // 方案扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT)) {
                    SscSchemeExtPO where = new SscSchemeExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeExtMapper.deleteBy(where);
                    }

                }
                // 方案历史扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_HIS_EXT)) {
                    SscSchemeHisExtPO where = new SscSchemeHisExtPO();
                    where.setSchemeHisId(sscExtObjInfo.getOrderId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeHisExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeHisExtMapper.deleteBy(where);
                    }

                }
                // 方案标段扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT)) {
                    SscSchemePackExtPO where = new SscSchemePackExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setPackId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemePackExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemePackExtMapper.deleteBy(where);
                    }

                }
                // 方案标段扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_HIS_EXT)) {
                    SscSchemePackHisExtPO where = new SscSchemePackHisExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setPackHisId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemePackHisExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemePackHisExtMapper.deleteBy(where);
                    }

                }
                // 物料明细扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT)) {
                    SscSchemeMatExtPO where = new SscSchemeMatExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeMatId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeMatExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeMatExtMapper.deleteBy(where);
                    }

                }
                // 物料明细扩展草稿
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT)) {
                    SscSchemeMatExtDraftPO where = new SscSchemeMatExtDraftPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeMatId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeMatExtDraftMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeMatExtDraftMapper.deleteBy(where);
                    }

                }
                // 物料明细历史扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_HIS_EXT)) {
                    SscSchemeMatHisExtPO where = new SscSchemeMatHisExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeMatHisId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeMatHisExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeMatHisExtMapper.deleteBy(where);
                    }

                }
                // 供应商
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT)) {
                    SscSchemeInviteSupExtPO where = new SscSchemeInviteSupExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeInviteSupExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeInviteSupExtMapper.deleteBy(where);
                    }
                }
                // 供应商扩展草稿
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT)) {
                    SscSchemeInviteSupExtDraftPO where = new SscSchemeInviteSupExtDraftPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeInviteSupExtDraftMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeInviteSupExtDraftMapper.deleteBy(where);
                    }
                }
                // 供应商历史扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_HIS_EXT)) {
                    SscSchemeInviteSupHisExtPO where = new SscSchemeInviteSupHisExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeInviteSupHisId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeInviteSupHisExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeInviteSupHisExtMapper.deleteBy(where);
                    }
                }
            });
        }
    }

    @Override
    public SscCommonDo qryExtInfo(SscCommonDo sscCommonDo) {
        SscCommonDo commonDo = new SscCommonDo();
        if (!CollectionUtils.isEmpty(sscCommonDo.getExtObjInfos())) {
            List<SscExtObjInfo> infoList = new ArrayList<>();
            sscCommonDo.getExtObjInfos().forEach(e -> {
                SscExtObjInfo sscExtObjInfo = new SscExtObjInfo();
                sscExtObjInfo.setObjId(e.getObjId());
                sscExtObjInfo.setOrderId(e.getOrderId());
                sscExtObjInfo.setObjType(e.getObjType());

                String objType = e.getObjType();
                switch (objType) {
                    // 方案扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT:
                        SscSchemeExtPO schemeExtPO = new SscSchemeExtPO();
                        schemeExtPO.setSchemeId(e.getObjId());
                        List<SscSchemeExtPO> schemeExtPOList = sscSchemeExtMapper.getList(schemeExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(schemeExtPOList, SscExtInfo.class));
                        break;
                    // 方案历史扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_HIS_EXT:
                        SscSchemeHisExtPO schemeHisExtPO = new SscSchemeHisExtPO();
                        schemeHisExtPO.setSchemeId(e.getOrderId());
                        schemeHisExtPO.setSchemeHisId(e.getObjId());
                        List<SscSchemeHisExtPO> schemeHisExtPOList = sscSchemeHisExtMapper.getList(schemeHisExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(schemeHisExtPOList, SscExtInfo.class));
                        break;
                    // 标段扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT:
                        SscSchemePackExtPO schemePackExtPO = new SscSchemePackExtPO();
                        schemePackExtPO.setSchemeId(e.getOrderId());
                        schemePackExtPO.setPackId(e.getObjId());
                        List<SscSchemePackExtPO> packExtPOS = sscSchemePackExtMapper.getList(schemePackExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(packExtPOS, SscExtInfo.class));
                        break;
                    // 标段历史扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_HIS_EXT:
                        SscSchemePackHisExtPO schemePackHisExtPO = new SscSchemePackHisExtPO();
                        schemePackHisExtPO.setSchemeId(e.getOrderId());
                        schemePackHisExtPO.setPackHisId(e.getObjId());
                        List<SscSchemePackHisExtPO> packHisExtPOList = sscSchemePackHisExtMapper.getList(schemePackHisExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(packHisExtPOList, SscExtInfo.class));
                        break;
                    // 物料明细扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT:
                        SscSchemeMatExtPO schemeMatExtPO = new SscSchemeMatExtPO();
                        schemeMatExtPO.setSchemeId(e.getOrderId());
                        schemeMatExtPO.setSchemeMatId(e.getObjId());
                        List<SscSchemeMatExtPO> matExtPOList = sscSchemeMatExtMapper.getList(schemeMatExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(matExtPOList, SscExtInfo.class));
                        break;
                    // 物料明细扩展草稿
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT:
                        SscSchemeMatExtDraftPO schemeMatExtDraftPO = new SscSchemeMatExtDraftPO();
                        schemeMatExtDraftPO.setSchemeId(e.getOrderId());
                        schemeMatExtDraftPO.setSchemeMatId(e.getObjId());
                        List<SscSchemeMatExtDraftPO> matExtDraftPOList = sscSchemeMatExtDraftMapper.getList(schemeMatExtDraftPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(matExtDraftPOList, SscExtInfo.class));
                        break;
                    // 物料明细历史扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_HIS_EXT:
                        SscSchemeMatHisExtPO schemeMatHisExtPO = new SscSchemeMatHisExtPO();
                        schemeMatHisExtPO.setSchemeId(e.getOrderId());
                        schemeMatHisExtPO.setSchemeMatHisId(e.getObjId());
                        List<SscSchemeMatHisExtPO> matHisExtPOList = sscSchemeMatHisExtMapper.getList(schemeMatHisExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(matHisExtPOList, SscExtInfo.class));
                        break;
                    // 供应商扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT:
                        SscSchemeInviteSupExtPO supExtPO = new SscSchemeInviteSupExtPO();
                        supExtPO.setSchemeId(e.getOrderId());
                        supExtPO.setSchemeInviteSupId(e.getObjId());
                        List<SscSchemeInviteSupExtPO> supExtPOList = sscSchemeInviteSupExtMapper.getList(supExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(supExtPOList, SscExtInfo.class));
                        break;
                    // 供应商扩展草稿
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT:
                        SscSchemeInviteSupExtDraftPO supExtDraftPO = new SscSchemeInviteSupExtDraftPO();
                        supExtDraftPO.setSchemeId(e.getOrderId());
                        supExtDraftPO.setSchemeInviteSupId(e.getObjId());
                        List<SscSchemeInviteSupExtDraftPO> supExtDraftPOList = sscSchemeInviteSupExtDraftMapper.getList(supExtDraftPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(supExtDraftPOList, SscExtInfo.class));
                        break;
                    // 供应商历史扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_HIS_EXT:
                        SscSchemeInviteSupHisExtPO schemeInviteSupHisExtPO = new SscSchemeInviteSupHisExtPO();
                        schemeInviteSupHisExtPO.setSchemeId(e.getOrderId());
                        schemeInviteSupHisExtPO.setSchemeInviteSupHisId(e.getObjId());
                        List<SscSchemeInviteSupHisExtPO> supHisExtPOList = sscSchemeInviteSupHisExtMapper.getList(schemeInviteSupHisExtPO);
                        sscExtObjInfo.setExtInfo(SscRu.jsl(supHisExtPOList, SscExtInfo.class));
                        break;
                    default:
                        break;
                }
                infoList.add(sscExtObjInfo);
            });
            commonDo.setExtObjInfos(infoList);
        }
        return commonDo;
    }
}
