package com.tydic.dyc.ssc.repository.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.repository.SscCommonRepository;
import com.tydic.dyc.ssc.repository.dao.*;
import com.tydic.dyc.ssc.repository.po.*;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:SscCommonRepositoryImpl
 * 说明:TODO
 * 时间:2023/3/13 11:16
 * 作者:代愿愿
 */
@Service
@Slf4j
class SscCommonRepositoryImpl implements SscCommonRepository {
    @Autowired
    private SscSchemeExtMapper sscSchemeExtMapper;
    @Autowired
    private SscSchemeMatExtMapper sscSchemeMatExtMapper;
    @Autowired
    private SscSchemePackExtMapper sscSchemePackExtMapper;
    @Autowired
    private SscSchemeInviteSupExtMapper sscSchemeInviteSupExtMapper;

    @Autowired
    private SscSchemeHisExtMapper sscSchemeHisExtMapper;

    @Autowired
    private SscSchemeMatHisExtMapper sscSchemeMatHisExtMapper;

    @Autowired
    private SscSchemePackHisExtMapper sscSchemePackHisExtMapper;

    @Autowired
    private SscSchemeInviteSupHisExtMapper sscSchemeInviteSupHisExtMapper;

    @Autowired
    private SscSchemeInviteSupExtDraftMapper sscSchemeInviteSupExtDraftMapper;

    @Autowired
    private SscSchemeMatExtDraftMapper sscSchemeMatExtDraftMapper;

    @Override
    public void addExtInfo(SscCommonDo sscCommonDo) {
        if (!CollectionUtils.isEmpty(sscCommonDo.getExtObjInfos())) {
            // 根据objType分组
            Map<String, List<SscExtObjInfo>> objTypeExtObjListMap = sscCommonDo.getExtObjInfos().stream().collect(Collectors.groupingBy(SscExtObjInfo::getObjType));
            objTypeExtObjListMap.forEach((objType, sscExtObjInfoList) -> {
                // 方案扩展
                if (objType.equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT)) {
                    List<SscSchemeExtPO> sscSchemeExtPOList = sscExtObjInfoList
                            .stream()
                            .flatMap(sscExtObjInfo -> {
                                List<SscSchemeExtPO> sscSchemeExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeExtPO.class);
                                sscSchemeExtPOS.forEach(sscSchemeExtPO -> {
                                    sscSchemeExtPO.setSchemeExtId(IdUtil.nextId());
                                    sscSchemeExtPO.setSchemeId(sscExtObjInfo.getObjId());
                                    sscSchemeExtPO.setCreateTime(new Date());
                                });
                                return sscSchemeExtPOS.stream();
                            }).collect(Collectors.toList());
                    sscSchemeExtMapper.insertBatch(sscSchemeExtPOList);
                }

                // 方案扩展历史
                if (objType.equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_HIS_EXT)) {
                    List<SscSchemeHisExtPO> sscSchemeHisExtPOList = sscExtObjInfoList
                            .stream()
                            .flatMap(sscExtObjInfo -> {
                                List<SscSchemeHisExtPO> sscSchemeExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeHisExtPO.class);
                                sscSchemeExtPOS.forEach(sscSchemeExtPO -> {
                                    sscSchemeExtPO.setSchemeHisId(IdUtil.nextId());
                                    sscSchemeExtPO.setSchemeId(sscExtObjInfo.getObjId());
                                    sscSchemeExtPO.setCreateTime(new Date());
                                });
                                return sscSchemeExtPOS.stream();
                            }).collect(Collectors.toList());
                    sscSchemeHisExtMapper.insertBatch(sscSchemeHisExtPOList);
                }
                // 方案标段扩展
                if (objType.equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT)) {
                    List<SscSchemePackExtPO> sscSchemePackExtPOList = sscExtObjInfoList
                            .stream()
                            .flatMap(sscExtObjInfo -> {
                                List<SscSchemePackExtPO> sscSchemePackExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemePackExtPO.class);
                                sscSchemePackExtPOS.forEach(sscSchemePackExtPO -> {
                                    sscSchemePackExtPO.setExtId(IdUtil.nextId());
                                    sscSchemePackExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                                    sscSchemePackExtPO.setPackId(sscExtObjInfo.getObjId());
                                    sscSchemePackExtPO.setCreateTime(new Date());
                                });
                                return sscSchemePackExtPOS.stream();
                            }).collect(Collectors.toList());
                    sscSchemePackExtMapper.insertBatch(sscSchemePackExtPOList);
                }
                // 方案标段历史扩展
                if (objType.equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_HIS_EXT)) {
                    List<SscSchemePackHisExtPO> sscSchemePackHisExtPOList = sscExtObjInfoList
                            .stream()
                            .flatMap(sscExtObjInfo -> {
                                List<SscSchemePackHisExtPO> sscSchemePackHisExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemePackHisExtPO.class);
                                sscSchemePackHisExtPOS.forEach(sscSchemePackHisExtPO -> {
                                    sscSchemePackHisExtPO.setExtId(IdUtil.nextId());
                                    sscSchemePackHisExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                                    sscSchemePackHisExtPO.setPackHisId(sscExtObjInfo.getObjId());
                                    sscSchemePackHisExtPO.setCreateTime(new Date());
                                });
                                return sscSchemePackHisExtPOS.stream();
                            }).collect(Collectors.toList());

                    sscSchemePackHisExtMapper.insertBatch(sscSchemePackHisExtPOList);
                }
                // 物料明细扩展
                if (objType.equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT)) {
                    List<SscSchemeMatExtPO> sscSchemeMatExtPOList = sscExtObjInfoList
                            .stream()
                            .flatMap(sscExtObjInfo -> {
                                List<SscSchemeMatExtPO> sscSchemeMatExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeMatExtPO.class);
                                sscSchemeMatExtPOS.forEach(sscSchemeMatExtPO -> {
                                    sscSchemeMatExtPO.setSchemeMatExtId(IdUtil.nextId());
                                    sscSchemeMatExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                                    sscSchemeMatExtPO.setSchemeMatId(sscExtObjInfo.getObjId());
                                    sscSchemeMatExtPO.setCreateTime(new Date());
                                });
                                return sscSchemeMatExtPOS.stream();
                            }).collect(Collectors.toList());

                    sscSchemeMatExtMapper.insertBatch(sscSchemeMatExtPOList);
                }
                // 物料明细扩展草稿
                if (objType.equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT)) {
                    List<SscSchemeMatExtDraftPO> sscSchemeMatExtDraftPOList = sscExtObjInfoList
                            .stream()
                            .flatMap(sscExtObjInfo -> {
                                List<SscSchemeMatExtDraftPO> sscSchemeMatExtDraftPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeMatExtDraftPO.class);
                                sscSchemeMatExtDraftPOS.forEach(sscSchemeMatExtPO -> {
                                    sscSchemeMatExtPO.setSchemeMatExtId(IdUtil.nextId());
                                    sscSchemeMatExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                                    sscSchemeMatExtPO.setSchemeMatId(sscExtObjInfo.getObjId());
                                    sscSchemeMatExtPO.setCreateTime(new Date());
                                });
                                return sscSchemeMatExtDraftPOS.stream();
                            }).collect(Collectors.toList());

                    sscSchemeMatExtDraftMapper.insertBatch(sscSchemeMatExtDraftPOList);
                }
                // 供应商扩展
                if (objType.equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT)) {
                    List<SscSchemeInviteSupExtPO> sscSchemeInviteSupExtPOList = sscExtObjInfoList
                            .stream()
                            .flatMap(sscExtObjInfo -> {
                                List<SscSchemeInviteSupExtPO> sscSchemeInviteSupExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeInviteSupExtPO.class);
                                sscSchemeInviteSupExtPOS.forEach(sscSchemeInviteSupExtPO -> {
                                    sscSchemeInviteSupExtPO.setExtId(IdUtil.nextId());
                                    sscSchemeInviteSupExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                                    sscSchemeInviteSupExtPO.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                                    sscSchemeInviteSupExtPO.setCreateTime(new Date());
                                });
                                return sscSchemeInviteSupExtPOS.stream();
                            }).collect(Collectors.toList());

                    sscSchemeInviteSupExtMapper.insertBatch(sscSchemeInviteSupExtPOList);
                }
                // 供应商扩展草稿
                if (objType.equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT)) {
                    List<SscSchemeInviteSupExtDraftPO> sscSchemeInviteSupExtDraftPOList = sscExtObjInfoList
                            .stream()
                            .flatMap(sscExtObjInfo -> {
                                List<SscSchemeInviteSupExtDraftPO> sscSchemeInviteSupExtDraftPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeInviteSupExtDraftPO.class);
                                sscSchemeInviteSupExtDraftPOS.forEach(sscSchemeInviteSupExtPO -> {
                                    sscSchemeInviteSupExtPO.setExtId(IdUtil.nextId());
                                    sscSchemeInviteSupExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                                    sscSchemeInviteSupExtPO.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                                    sscSchemeInviteSupExtPO.setCreateTime(new Date());
                                });
                                return sscSchemeInviteSupExtDraftPOS.stream();
                            }).collect(Collectors.toList());

                    sscSchemeInviteSupExtDraftMapper.insertBatch(sscSchemeInviteSupExtDraftPOList);
                }
                // 供应商历史扩展
                if (objType.equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT)) {
                    List<SscSchemeInviteSupHisExtPO> sscSchemeInviteSupHisExtPOList = sscExtObjInfoList
                            .stream()
                            .flatMap(sscExtObjInfo -> {
                                List<SscSchemeInviteSupHisExtPO> sscSchemeInviteSupHisExtPOS = SscRu.jsl(sscExtObjInfo.getExtInfo(), SscSchemeInviteSupHisExtPO.class);
                                sscSchemeInviteSupHisExtPOS.forEach(sscSchemeInviteSupHisExtPO -> {
                                    sscSchemeInviteSupHisExtPO.setExtId(IdUtil.nextId());
                                    sscSchemeInviteSupHisExtPO.setSchemeId(sscExtObjInfo.getOrderId());
                                    sscSchemeInviteSupHisExtPO.setSchemeInviteSupHisId(sscExtObjInfo.getObjId());
                                    sscSchemeInviteSupHisExtPO.setCreateTime(new Date());
                                });
                                return sscSchemeInviteSupHisExtPOS.stream();
                            }).collect(Collectors.toList());

                    sscSchemeInviteSupHisExtMapper.insertBatch(sscSchemeInviteSupHisExtPOList);
                }
            });
        }

    }

    @Override
    public void updateExtInfo(SscCommonDo sscCommonDo) {
        if (!CollectionUtils.isEmpty(sscCommonDo.getExtObjInfos())) {
            sscCommonDo.getExtObjInfos().forEach(sscExtObjInfo -> {
                // 方案扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeExtPO where = new SscSchemeExtPO();
                        where.setSchemeId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeExtPO set = new SscSchemeExtPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeExtMapper.updateBy(set, where);
                    });
                }
                // 方案标段扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemePackExtPO where = new SscSchemePackExtPO();
                        where.setPackId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemePackExtPO set = new SscSchemePackExtPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemePackExtMapper.updateBy(set, where);
                    });
                }
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeMatExtPO where = new SscSchemeMatExtPO();
                        where.setSchemeMatId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeMatExtPO set = new SscSchemeMatExtPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeMatExtMapper.updateBy(set, where);
                    });
                }
                // 物料明细扩展草稿
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeMatExtDraftPO where = new SscSchemeMatExtDraftPO();
                        where.setSchemeMatId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeMatExtDraftPO set = new SscSchemeMatExtDraftPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeMatExtDraftMapper.updateBy(set, where);
                    });
                }
                // 供应商扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeInviteSupExtPO where = new SscSchemeInviteSupExtPO();
                        where.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeInviteSupExtPO set = new SscSchemeInviteSupExtPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeInviteSupExtMapper.updateBy(set, where);
                    });
                }
                // 供应商草稿扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT)) {
                    sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                        SscSchemeInviteSupExtDraftPO where = new SscSchemeInviteSupExtDraftPO();
                        where.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                        where.setFieldCode(sscExtInfo.getFieldCode());

                        SscSchemeInviteSupExtDraftPO set = new SscSchemeInviteSupExtDraftPO();
                        set.setFieldName(sscExtInfo.getFieldName());
                        set.setFieldValue(sscExtInfo.getFieldValue());
                        set.setRemark(sscExtInfo.getRemark());
                        sscSchemeInviteSupExtDraftMapper.updateBy(set, where);
                    });
                }
            });
        }
    }

    @Override
    public void deleteExtInfo(SscCommonDo sscCommonDo) {
        if (!CollectionUtils.isEmpty(sscCommonDo.getExtObjInfos())) {
            for (SscExtObjInfo sscExtObjInfo : sscCommonDo.getExtObjInfos()) {
                // 方案扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT)) {
                    if (ObjectUtil.isEmpty(sscExtObjInfo.getOrderId())) {
                        log.error("删除方案扩展信息时，orderId为空");
                        continue;
                    }
                    SscSchemeExtPO where = new SscSchemeExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeExtMapper.deleteBy(where);
                    }

                }
                // 方案历史扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_HIS_EXT)) {
                    if (ObjectUtil.isEmpty(sscExtObjInfo.getOrderId())) {
                        log.error("删除方案历史扩展信息时，orderId为空");
                        continue;
                    }
                    SscSchemeHisExtPO where = new SscSchemeHisExtPO();
                    where.setSchemeHisId(sscExtObjInfo.getOrderId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeHisExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeHisExtMapper.deleteBy(where);
                    }

                }
                // 方案标段扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT)) {
                    if (ObjectUtil.isEmpty(sscExtObjInfo.getOrderId()) && ObjectUtil.isEmpty(sscExtObjInfo.getObjId())) {
                        log.error("删除方案标段扩展信息时，orderId和objId都为空");
                        continue;
                    }
                    SscSchemePackExtPO where = new SscSchemePackExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setPackId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemePackExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemePackExtMapper.deleteBy(where);
                    }

                }
                // 方案标段扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_HIS_EXT)) {
                    if (ObjectUtil.isEmpty(sscExtObjInfo.getOrderId()) && ObjectUtil.isEmpty(sscExtObjInfo.getObjId())) {
                        log.error("删除方案标段历史扩展信息时，orderId和objId都为空");
                        continue;
                    }
                    SscSchemePackHisExtPO where = new SscSchemePackHisExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setPackHisId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemePackHisExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemePackHisExtMapper.deleteBy(where);
                    }

                }
                // 物料明细扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT)) {
                    if (ObjectUtil.isEmpty(sscExtObjInfo.getOrderId()) && ObjectUtil.isEmpty(sscExtObjInfo.getObjId())) {
                        log.error("删除物料明细扩展信息时，orderId和objId都为空");
                        continue;
                    }
                    SscSchemeMatExtPO where = new SscSchemeMatExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeMatId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeMatExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeMatExtMapper.deleteBy(where);
                    }

                }
                // 物料明细扩展草稿
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT)) {
                    if (ObjectUtil.isEmpty(sscExtObjInfo.getOrderId()) && ObjectUtil.isEmpty(sscExtObjInfo.getObjId())) {
                        log.error("删除物料明细扩展草稿信息时，orderId和objId都为空");
                        continue;
                    }
                    SscSchemeMatExtDraftPO where = new SscSchemeMatExtDraftPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeMatId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeMatExtDraftMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeMatExtDraftMapper.deleteBy(where);
                    }

                }
                // 物料明细历史扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_HIS_EXT)) {
                    if (ObjectUtil.isEmpty(sscExtObjInfo.getOrderId()) && ObjectUtil.isEmpty(sscExtObjInfo.getObjId())) {
                        log.error("删除物料明细历史扩展信息时，orderId和objId都为空");
                        continue;
                    }
                    SscSchemeMatHisExtPO where = new SscSchemeMatHisExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeMatHisId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeMatHisExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeMatHisExtMapper.deleteBy(where);
                    }

                }
                // 供应商
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT)) {
                    if (ObjectUtil.isEmpty(sscExtObjInfo.getOrderId()) && ObjectUtil.isEmpty(sscExtObjInfo.getObjId())) {
                        log.error("删除供应商扩展信息时，orderId和objId都为空");
                        continue;
                    }
                    SscSchemeInviteSupExtPO where = new SscSchemeInviteSupExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeInviteSupExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeInviteSupExtMapper.deleteBy(where);
                    }
                }
                // 供应商扩展草稿
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT)) {
                    if (ObjectUtil.isEmpty(sscExtObjInfo.getOrderId()) && ObjectUtil.isEmpty(sscExtObjInfo.getObjId())) {
                        log.error("删除供应商扩展草稿信息时，orderId和objId都为空");
                        continue;
                    }
                    SscSchemeInviteSupExtDraftPO where = new SscSchemeInviteSupExtDraftPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeInviteSupId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeInviteSupExtDraftMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeInviteSupExtDraftMapper.deleteBy(where);
                    }
                }
                // 供应商历史扩展
                if (sscExtObjInfo.getObjType().equals(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_HIS_EXT)) {
                    if (ObjectUtil.isEmpty(sscExtObjInfo.getOrderId()) && ObjectUtil.isEmpty(sscExtObjInfo.getObjId())) {
                        log.error("删除供应商历史扩展信息时，orderId和objId都为空");
                        continue;
                    }
                    SscSchemeInviteSupHisExtPO where = new SscSchemeInviteSupHisExtPO();
                    where.setSchemeId(sscExtObjInfo.getOrderId());
                    where.setSchemeInviteSupHisId(sscExtObjInfo.getObjId());
                    if (!CollectionUtils.isEmpty(sscExtObjInfo.getExtInfo())) {
                        sscExtObjInfo.getExtInfo().forEach(sscExtInfo -> {
                            where.setFieldCode(sscExtInfo.getFieldCode());
                            sscSchemeInviteSupHisExtMapper.deleteBy(where);
                        });
                    } else {
                        sscSchemeInviteSupHisExtMapper.deleteBy(where);
                    }
                }
            }

        }
    }

    @Override
    public SscCommonDo qryExtInfo(SscCommonDo sscCommonDo) {
        SscCommonDo commonDo = new SscCommonDo();
        if (!CollectionUtils.isEmpty(sscCommonDo.getExtObjInfos())) {
            List<SscExtObjInfo> infoList = new ArrayList<>();
            Map<String, List<SscExtObjInfo>> objTypeObjListMap = sscCommonDo.getExtObjInfos().stream().collect(Collectors.groupingBy(SscExtObjInfo::getObjType));
            objTypeObjListMap.forEach((k, v) -> {
                List<Long> orderIdList = v.stream().map(SscExtObjInfo::getOrderId).filter(ObjectUtil::isNotNull).distinct().collect(Collectors.toList());
                List<Long> objIdList = v.stream().map(SscExtObjInfo::getObjId).filter(ObjectUtil::isNotNull).distinct().collect(Collectors.toList());
                switch (k) {
                    // 方案扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT:
                        SscSchemeExtPO schemeExtPO = new SscSchemeExtPO();
                        schemeExtPO.setSchemeIds(objIdList);
                        List<SscSchemeExtPO> schemeExtPOList = sscSchemeExtMapper.getList(schemeExtPO);
                        if (CollectionUtil.isNotEmpty(schemeExtPOList)) {
                            Map<Long, List<SscSchemeExtPO>> map = schemeExtPOList.stream().collect(Collectors.groupingBy(SscSchemeExtPO::getSchemeId));
                            map.forEach((key, value) -> {
                                SscExtObjInfo extObjInfo = new SscExtObjInfo();
                                extObjInfo.setObjId(key);
                                extObjInfo.setExtInfo(SscRu.jsl(value, SscExtInfo.class));
                                infoList.add(extObjInfo);
                            });
                        }
                        break;
                    // 方案历史扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_HIS_EXT:
                        SscSchemeHisExtPO schemeHisExtPO = new SscSchemeHisExtPO();
                        schemeHisExtPO.setSchemeIds(orderIdList);
                        schemeHisExtPO.setSchemeHisIds(objIdList);
                        List<SscSchemeHisExtPO> schemeHisExtPOList = sscSchemeHisExtMapper.getList(schemeHisExtPO);
                        if (CollectionUtil.isNotEmpty(schemeHisExtPOList)) {
                            Map<Long, List<SscSchemeHisExtPO>> map = schemeHisExtPOList.stream().collect(Collectors.groupingBy(SscSchemeHisExtPO::getSchemeHisId));
                            map.forEach((key, value) -> {
                                SscExtObjInfo extObjInfo = new SscExtObjInfo();
                                extObjInfo.setObjId(key);
                                extObjInfo.setExtInfo(SscRu.jsl(value, SscExtInfo.class));
                                infoList.add(extObjInfo);
                            });
                        }
                        break;
                    // 标段扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT:
                        SscSchemePackExtPO schemePackExtPO = new SscSchemePackExtPO();
                        schemePackExtPO.setSchemeIds(orderIdList);
                        schemePackExtPO.setPackIds(objIdList);
                        List<SscSchemePackExtPO> packExtPOS = sscSchemePackExtMapper.getList(schemePackExtPO);
                        if (CollectionUtil.isNotEmpty(packExtPOS)) {
                            Map<Long, List<SscSchemePackExtPO>> map = packExtPOS.stream().collect(Collectors.groupingBy(SscSchemePackExtPO::getPackId));
                            map.forEach((key, value) -> {
                                SscExtObjInfo extObjInfo = new SscExtObjInfo();
                                extObjInfo.setObjId(key);
                                extObjInfo.setExtInfo(SscRu.jsl(value, SscExtInfo.class));
                                infoList.add(extObjInfo);
                            });
                        }
                        break;
                    // 标段历史扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_HIS_EXT:
                        SscSchemePackHisExtPO schemePackHisExtPO = new SscSchemePackHisExtPO();
                        schemePackHisExtPO.setSchemeIds(orderIdList);
                        schemePackHisExtPO.setPackHisIds(objIdList);
                        List<SscSchemePackHisExtPO> packHisExtPOList = sscSchemePackHisExtMapper.getList(schemePackHisExtPO);
                        if (CollectionUtil.isNotEmpty(packHisExtPOList)) {
                            Map<Long, List<SscSchemePackHisExtPO>> map = packHisExtPOList.stream().collect(Collectors.groupingBy(SscSchemePackHisExtPO::getPackHisId));
                            map.forEach((key, value) -> {
                                SscExtObjInfo extObjInfo = new SscExtObjInfo();
                                extObjInfo.setObjId(key);
                                extObjInfo.setExtInfo(SscRu.jsl(value, SscExtInfo.class));
                                infoList.add(extObjInfo);
                            });
                        }
                        break;
                    // 物料明细扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT:
                        SscSchemeMatExtPO schemeMatExtPO = new SscSchemeMatExtPO();
                        schemeMatExtPO.setSchemeIds(orderIdList);
                        schemeMatExtPO.setSchemeMatIds(objIdList);
                        List<SscSchemeMatExtPO> matExtPOList = sscSchemeMatExtMapper.getList(schemeMatExtPO);
                        if (CollectionUtil.isNotEmpty(matExtPOList)) {
                            Map<Long, List<SscSchemeMatExtPO>> map = matExtPOList.stream().collect(Collectors.groupingBy(SscSchemeMatExtPO::getSchemeMatId));
                            map.forEach((key, value) -> {
                                SscExtObjInfo extObjInfo = new SscExtObjInfo();
                                extObjInfo.setObjId(key);
                                extObjInfo.setExtInfo(SscRu.jsl(value, SscExtInfo.class));
                                infoList.add(extObjInfo);
                            });
                        }
                        break;
                    // 物料明细扩展草稿
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT:
                        SscSchemeMatExtDraftPO schemeMatExtDraftPO = new SscSchemeMatExtDraftPO();
                        schemeMatExtDraftPO.setSchemeIds(orderIdList);
                        schemeMatExtDraftPO.setSchemeMatIds(objIdList);
                        List<SscSchemeMatExtDraftPO> matExtDraftPOList = sscSchemeMatExtDraftMapper.getList(schemeMatExtDraftPO);
                        if (CollectionUtil.isNotEmpty(matExtDraftPOList)) {
                            Map<Long, List<SscSchemeMatExtDraftPO>> map = matExtDraftPOList.stream().collect(Collectors.groupingBy(SscSchemeMatExtDraftPO::getSchemeMatId));
                            map.forEach((key, value) -> {
                                SscExtObjInfo extObjInfo = new SscExtObjInfo();
                                extObjInfo.setObjId(key);
                                extObjInfo.setExtInfo(SscRu.jsl(value, SscExtInfo.class));
                                infoList.add(extObjInfo);
                            });
                        }
                        break;
                    // 物料明细历史扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_HIS_EXT:
                        SscSchemeMatHisExtPO schemeMatHisExtPO = new SscSchemeMatHisExtPO();
                        schemeMatHisExtPO.setSchemeIds(orderIdList);
                        schemeMatHisExtPO.setSchemeMatHisIds(objIdList);
                        List<SscSchemeMatHisExtPO> matHisExtPOList = sscSchemeMatHisExtMapper.getList(schemeMatHisExtPO);
                        if (CollectionUtil.isNotEmpty(matHisExtPOList)) {
                            Map<Long, List<SscSchemeMatHisExtPO>> map = matHisExtPOList.stream().collect(Collectors.groupingBy(SscSchemeMatHisExtPO::getSchemeMatHisId));
                            map.forEach((key, value) -> {
                                SscExtObjInfo extObjInfo = new SscExtObjInfo();
                                extObjInfo.setObjId(key);
                                extObjInfo.setExtInfo(SscRu.jsl(value, SscExtInfo.class));
                                infoList.add(extObjInfo);
                            });
                        }
                        break;
                    // 供应商扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT:
                        SscSchemeInviteSupExtPO supExtPO = new SscSchemeInviteSupExtPO();
                        supExtPO.setSchemeIds(orderIdList);
                        supExtPO.setSchemeInviteSupIds(objIdList);
                        List<SscSchemeInviteSupExtPO> supExtPOList = sscSchemeInviteSupExtMapper.getList(supExtPO);
                        if (CollectionUtil.isNotEmpty(supExtPOList)) {
                            Map<Long, List<SscSchemeInviteSupExtPO>> map = supExtPOList.stream().collect(Collectors.groupingBy(SscSchemeInviteSupExtPO::getSchemeInviteSupId));
                            map.forEach((key, value) -> {
                                SscExtObjInfo extObjInfo = new SscExtObjInfo();
                                extObjInfo.setObjId(key);
                                extObjInfo.setExtInfo(SscRu.jsl(value, SscExtInfo.class));
                                infoList.add(extObjInfo);
                            });
                        }
                        break;
                    // 供应商扩展草稿
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT:
                        SscSchemeInviteSupExtDraftPO supExtDraftPO = new SscSchemeInviteSupExtDraftPO();
                        supExtDraftPO.setSchemeIds(orderIdList);
                        supExtDraftPO.setSchemeInviteSupIds(objIdList);
                        List<SscSchemeInviteSupExtDraftPO> supExtDraftPOList = sscSchemeInviteSupExtDraftMapper.getList(supExtDraftPO);
                        if (CollectionUtil.isNotEmpty(supExtDraftPOList)) {
                            Map<Long, List<SscSchemeInviteSupExtDraftPO>> map = supExtDraftPOList.stream().collect(Collectors.groupingBy(SscSchemeInviteSupExtDraftPO::getSchemeInviteSupId));
                            map.forEach((key, value) -> {
                                SscExtObjInfo extObjInfo = new SscExtObjInfo();
                                extObjInfo.setObjId(key);
                                extObjInfo.setExtInfo(SscRu.jsl(value, SscExtInfo.class));
                                infoList.add(extObjInfo);
                            });
                        }
                        break;
                    // 供应商历史扩展
                    case SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_HIS_EXT:
                        SscSchemeInviteSupHisExtPO schemeInviteSupHisExtPO = new SscSchemeInviteSupHisExtPO();
                        schemeInviteSupHisExtPO.setSchemeIds(orderIdList);
                        schemeInviteSupHisExtPO.setSchemeInviteSupHisIds(objIdList);
                        List<SscSchemeInviteSupHisExtPO> supHisExtPOList = sscSchemeInviteSupHisExtMapper.getList(schemeInviteSupHisExtPO);
                        if (CollectionUtil.isNotEmpty(supHisExtPOList)) {
                            Map<Long, List<SscSchemeInviteSupHisExtPO>> map = supHisExtPOList.stream().collect(Collectors.groupingBy(SscSchemeInviteSupHisExtPO::getSchemeInviteSupHisId));
                            map.forEach((key, value) -> {
                                SscExtObjInfo extObjInfo = new SscExtObjInfo();
                                extObjInfo.setObjId(key);
                                extObjInfo.setExtInfo(SscRu.jsl(value, SscExtInfo.class));
                                infoList.add(extObjInfo);
                            });
                        }
                        break;
                    default:
                        break;
                }
            });
            commonDo.setExtObjInfos(infoList);
        }
        return commonDo;
    }
}
