package com.tydic.dyc.ubc.constants;

import com.tydic.dyc.base.constants.BaseRspConstant;

/**
 * 标题:UocRspConstants
 * 说明:用户行为监测错误编码定义
 * 时间:2022/2/22 14:18
 * 作者:田桂银
 */
public class UbcRspConstants extends BaseRspConstant {

    /*
    编码生成规则：用户行为监测中心编码开头：20开头的6位编码
	调用成功的编码无需再自行定义，统一使用：RSP_CODE_SUCCESS
	每个接口调用失败的编码需自行定义，规则如下：
	编码key：以RSP_CODE开头，以ERROR结束，中间为自定义部分，
	自定义原则为具有可读性的英文单词（可简写），多个单词以“_”分隔
	编码值：领域服务层1开头，如：1001；领域方法以2开头，如：2001；基建层以3开头，如3001；编码值长度为4位
	注意：用户行为监测中心整体编码前面要加10，方便应用层识别和统一管理编码
	*/

    /**
     * 入参非空失败
     */
    public static final String RSP_CODE_ARG_EMPTY_ERROR = "200001";
    /**
     * 通用系统异常编码
     */
    public static final String RSP_CODE_SYSTEM_EXCEPTION = "200100";

    /**
     * 快照不存在
     */
    public static final String RSP_CODE_SNAPSHOT_NOT_EXIST = "200002";

    /**
     * 用户行为编码未定义
     */
    public static final String RSP_CODE_BEHAVIOR_NOT_DEFINE = "200003";

    /**
     * 用户行为操作编码未定义
     */
    public static final String RSP_CODE_BEHAVIOR_OPERATE_NOT_DEFINE = "200004";

    /**
     * 用户行为操作编码属性未传递
     */
    public static final String RSP_CODE_BEHAVIOR_OPERATE_PROPERTY_NOT_INPUT = "200005";

}


