/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ubc.components.es;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UbcElasticsearchUtil {
    private static final Logger log = LoggerFactory.getLogger(UbcElasticsearchUtil.class);
    @Autowired
    private RestHighLevelClient restHighLevelClient;

    public boolean deleteIndex(String index) {
        if (StringUtils.isBlank((CharSequence)index)) {
            log.info("\u5220\u9664\u7d22\u5f15\u5185\u5bb9\u4e3a\u7a7a");
            return false;
        }
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        try {
            AcknowledgedResponse indexResponse = this.restHighLevelClient.indices().delete(request, RequestOptions.DEFAULT);
            if (indexResponse.isAcknowledged()) {
                log.info("\u5220\u9664\u7d22\u5f15\u6210\u529f");
            } else {
                log.info("\u5220\u9664\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            String exceptionStr = JSON.toJSONString((Object)e.getMessage());
            return exceptionStr.contains("index_not_found_exception");
        }
    }

    public boolean createIndex(String index) {
        CreateIndexRequest request = new CreateIndexRequest(index);
        try {
            CreateIndexResponse indexResponse = this.restHighLevelClient.indices().create(request, RequestOptions.DEFAULT);
            if (indexResponse.isAcknowledged()) {
                log.info("\u521b\u5efa\u7d22\u5f15\u6210\u529f");
            } else {
                log.info("\u521b\u5efa\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public String addData(String index, String type, String id, JSONObject object) {
        IndexRequest indexRequest = new IndexRequest(index);
        indexRequest.id(id);
        try {
            indexRequest.source(JSON.toJSONString((Object)object), XContentType.JSON);
            IndexResponse indexResponse = this.restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
            return indexResponse.getId();
        }
        catch (Exception e) {
            log.info("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public String addJsonData(String index, String id, String jsonStr) {
        IndexRequest indexRequest = new IndexRequest(index);
        indexRequest.id(id);
        try {
            indexRequest.source(jsonStr, XContentType.JSON);
            log.info("addJsonData\u4fdd\u5b58\u6570\u636e\uff1a" + jsonStr);
            IndexResponse indexResponse = this.restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
            return indexResponse.getId();
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new BaseBusinessException("8888", "\u63d2\u5165\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public boolean checkIndexExist(String index) {
        String ok = "OK";
        boolean checkResult = false;
        try {
            Request request = new Request("HEAD", index);
            Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            if (ok.equals(response.getStatusLine().getReasonPhrase())) {
                checkResult = true;
            }
        }
        catch (IOException e) {
            log.error("\u68c0\u67e5\u7d22\u5f15\u5931\u8d25", (Throwable)e);
        }
        return checkResult;
    }

    public Boolean deleteDataByCondition(String endPoint, JSONObject qryJson) {
        boolean deleteResult = false;
        NStringEntity entity = new NStringEntity(qryJson.toJSONString(), ContentType.APPLICATION_JSON);
        try {
            JSONObject deleteResultJson;
            int deleteCount;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotBlank((CharSequence)result) && (deleteCount = (deleteResultJson = JSONObject.parseObject((String)result)).getInteger("deleted").intValue()) > 0) {
                deleteResult = true;
            }
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6761\u4ef6\u5220\u9664ES\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return deleteResult;
    }

    public Boolean updateDataById(String endPoint, JSONObject updateJson, String id) {
        boolean updateREsult = false;
        String esUpdateStr = this.toEsUpdateStr(id, updateJson);
        log.info("esUpdate URL:{}", (Object)endPoint);
        log.info("esUpdateStrReq:{}", (Object)esUpdateStr);
        NStringEntity entity = new NStringEntity(esUpdateStr, ContentType.APPLICATION_JSON);
        try {
            JSONObject rspJsonObject;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("esUpdateStrRsp:{}", (Object)result);
            if (StringUtils.isNotBlank((CharSequence)result) && "1".equals((rspJsonObject = JSON.parseObject((String)result)).get((Object)"updated"))) {
                updateREsult = true;
            }
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6761\u4ef6\u66f4\u65b0ES\u6570\u636e\u5931\u8d25:{},\u66f4\u65b0\u8bed\u53e5:{}", (Object)e, (Object)esUpdateStr);
        }
        return updateREsult;
    }

    public RestClient getLowLevelClient() {
        return this.restHighLevelClient.getLowLevelClient();
    }

    public String toEsUpdateStr(String id, JSONObject updateParams) {
        JSONObject term = new JSONObject();
        term.put("_id", (Object)id);
        JSONObject query = new JSONObject();
        query.put("term", (Object)term);
        JSONObject script = new JSONObject();
        script.put("source", (Object)this.getSource(updateParams));
        script.put("lang", (Object)"painless");
        script.put("params", (Object)updateParams);
        JSONObject esJsonObj = new JSONObject();
        esJsonObj.put("query", (Object)query);
        esJsonObj.put("script", (Object)script);
        return esJsonObj.toJSONString();
    }

    private String getSource(JSONObject updateParams) {
        StringBuilder stringBuilder = new StringBuilder();
        updateParams.keySet().forEach(key -> stringBuilder.append("ctx._source.").append((String)key).append("=").append("params.").append((String)key).append(";"));
        return stringBuilder.toString();
    }
}

