/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ubc.components.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class UbcThreadPool {
    private ThreadPoolExecutor executor = null;
    @Value(value="${ubc.thread.corePoolSize:4}")
    int corePoolSize;
    @Value(value="${ubc.thread.maximumPoolSize:50}")
    int maximumPoolSize;
    @Value(value="${ubc.thread.keepAliveTime:60}")
    long keepAliveTime;
    @Value(value="${ubc.thread.blockingCapacity:100}")
    private int blockingCapacity;
    @Autowired
    private AutowireCapableBeanFactory beanFactory;

    @PostConstruct
    public void initThreadPoolExecutor() {
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(this.blockingCapacity);
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        ThreadPoolExecutor.AbortPolicy rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
        this.executor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.SECONDS, workQueue, threadFactory, rejectedExecutionHandler);
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public void executeRunnable(Runnable runnable) {
        this.beanFactory.autowireBean((Object)runnable);
        this.executor.execute(runnable);
    }
}

