/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ubc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ubc.components.UbcProperties;
import com.tydic.dyc.ubc.components.es.UbcElasticsearchUtil;
import com.tydic.dyc.ubc.components.es.UocSearchEsSQLRspBO;
import com.tydic.dyc.ubc.service.common.UbcUserBehaviorInfoQryService;
import com.tydic.dyc.ubc.service.common.bo.UbcUserBehaviorInfoQryBo;
import com.tydic.dyc.ubc.service.common.bo.UbcUserBehaviorInfoQryServiceReqBo;
import com.tydic.dyc.ubc.service.common.bo.UbcUserBehaviorInfoQryServiceRspBo;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.ubc.service.common.UbcUserBehaviorInfoQryService"})
public class UbcUserBehaviorInfoQryServiceImpl
implements UbcUserBehaviorInfoQryService {
    private static final Logger log = LoggerFactory.getLogger(UbcUserBehaviorInfoQryServiceImpl.class);
    public static final String TABLE_UNDERSCORE = "_";
    private static Integer maxPageSize;
    @Autowired
    private UbcProperties ubcProperties;
    @Autowired
    private UbcElasticsearchUtil ubcElasticsearchUtil;

    @Value(value="${es.max.page.size:10000}")
    public void setMaxPageSize(Integer maxPageSize) {
        UbcUserBehaviorInfoQryServiceImpl.maxPageSize = maxPageSize;
    }

    @PostMapping(value={"qryUserBehaviorList"})
    public UbcUserBehaviorInfoQryServiceRspBo qryUserBehaviorList(@RequestBody UbcUserBehaviorInfoQryServiceReqBo reqBo) {
        UbcUserBehaviorInfoQryServiceRspBo rspBo = new UbcUserBehaviorInfoQryServiceRspBo();
        String queryString = this.buildQryPlanEsSql(reqBo);
        log.debug("ES\u67e5\u8be2\u8bed\u53e5\u4e3a\uff1a" + queryString);
        int operateYear = this.getOperateYear(reqBo);
        String endPoint = "/" + UbcUserBehaviorInfoQryServiceImpl.getUerBehaviorIndexName(this.ubcProperties.getUserBehaviorInfoPrefix(), operateYear) + "/_search";
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Request request = new Request("POST", endPoint);
            request.setJsonEntity(queryString);
            Response response = this.ubcElasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            System.out.println("ES\u67e5\u8be2\u8ba1\u5212\u4fe1\u606fresult---->" + result);
            this.resovelRetrunData(result, rspBo, reqBo.getPageSize(), reqBo.getPageNo());
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u884c\u4e3a\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
        }
        return rspBo;
    }

    private int getOperateYear(UbcUserBehaviorInfoQryServiceReqBo reqBo) {
        int operateYear;
        if (!StringUtils.isEmpty((Object)reqBo.getOperateTimeStart())) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                reqBo.setOperateTime(simpleDateFormat.parse(reqBo.getOperateTimeStart()));
            }
            catch (ParseException e) {
                log.error("ParseException", (Throwable)e);
                throw new BaseBusinessException("200001", "\u67e5\u8be2\u7528\u6237\u884c\u4e3a\u5217\u8868-\u65e5\u671f\u8f6c\u6362\u9519\u8bef!");
            }
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOperateTime())) {
            operateYear = LocalDate.now().getYear();
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(reqBo.getOperateTime());
            operateYear = calendar.get(1);
        }
        return operateYear;
    }

    private String buildQryPlanEsSql(UbcUserBehaviorInfoQryServiceReqBo reqBo) {
        FieldSortBuilder sortQueryFirst;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)reqBo.getUserName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"userName.keyword", (String)("*" + reqBo.getUserName() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOperateName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"userName.keyword", (String)("*" + reqBo.getOperateName() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"behaviorContent", (String)("*" + reqBo.getSkuCode() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"behaviorContent", (String)("*" + reqBo.getOrderNo() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPoolName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"behaviorContent.keyword", (String)("*" + reqBo.getPoolName() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getAgrCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"behaviorContent", (String)("*" + reqBo.getAgrCode() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBehaviorContent())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"behaviorContent.keyword", (String)("*" + reqBo.getBehaviorContent() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getRelevantDeptName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"behaviorContent.keyword", (String)("*" + reqBo.getRelevantDeptName() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCmpOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"behaviorContent.keyword", (String)("*" + reqBo.getCmpOrderNo() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUsedScope())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"behaviorContent.keyword", (String)("*" + reqBo.getUsedScope() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getLocationCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"locationCode", (String)reqBo.getLocationCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getLocationName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"locationName.keyword", (String)("*" + reqBo.getLocationName() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"busiCode", (String)reqBo.getBusiCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOperateTimeStart()) || !StringUtils.isEmpty((Object)reqBo.getOperateTimeEnd())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"operateTime");
            if (!StringUtils.isEmpty((Object)reqBo.getOperateTimeStart())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBo.getOperateTimeStart()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (!StringUtils.isEmpty((Object)reqBo.getOperateTimeEnd())) {
                Long createTimeEcp = DateUtils.strToDateLong((String)reqBo.getOperateTimeEnd()).getTime();
                rangeQueryBuilder.lte((Object)createTimeEcp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        SortOrder order = SortOrder.DESC;
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (!StringUtils.isEmpty((Object)reqBo.getOrderBy())) {
            order = SortOrder.ASC;
            sortQueryFirst = (FieldSortBuilder)SortBuilders.fieldSort((String)reqBo.getOrderBy()).order(order);
        } else {
            sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"operateTime").order(order)).unmappedType("date");
        }
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        fieldSortBuilders.add(sortQueryFirst);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setPageNo(reqBo.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBo.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    private void resovelRetrunData(String result, UbcUserBehaviorInfoQryServiceRspBo rspBo, Integer pageSize, Integer pageNo) {
        rspBo.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getJSONObject("total").getInteger("value");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBo.setPageNo(1);
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(total.intValue());
            rspBo.setRows(new ArrayList());
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f!");
            return;
        }
        ArrayList<UbcUserBehaviorInfoQryBo> rows = new ArrayList<UbcUserBehaviorInfoQryBo>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            UbcUserBehaviorInfoQryBo behaviorInfoQryBo = (UbcUserBehaviorInfoQryBo)JSON.toJavaObject((JSON)data, UbcUserBehaviorInfoQryBo.class);
            behaviorInfoQryBo.setOperateName(behaviorInfoQryBo.getUserName());
            rows.add(behaviorInfoQryBo);
        }
        int totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBo.setTotal(totalPageNo);
        rspBo.setRecordsTotal(total.intValue());
        rspBo.setPageNo(pageNo.intValue());
        rspBo.setRespDesc("\u67e5\u8be2\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBo.setRows(rows);
    }

    public static String getUerBehaviorIndexName(String tablePrefix, int operateYear) {
        if (ObjectUtil.isEmpty((Object)tablePrefix)) {
            throw new BaseBusinessException("200001", "\u8868\u540d\u524d\u7f00\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder sb = new StringBuilder(tablePrefix);
        sb.append(TABLE_UNDERSCORE).append(operateYear);
        return sb.toString();
    }

    private String getQueryString(UocSearchEsSQLRspBO uocSearchEsSQLRspBO) {
        if (uocSearchEsSQLRspBO.getPageNo() <= 0) {
            uocSearchEsSQLRspBO.setPageNo(1);
        }
        JSONObject queryJson = new JSONObject();
        if (maxPageSize < uocSearchEsSQLRspBO.getPageSize()) {
            queryJson.put("size", (Object)maxPageSize);
        } else {
            queryJson.put("size", (Object)uocSearchEsSQLRspBO.getPageSize());
        }
        queryJson.put("from", (Object)(uocSearchEsSQLRspBO.getPageSize() * (uocSearchEsSQLRspBO.getPageNo() - 1)));
        String queryString = uocSearchEsSQLRspBO.getBoolQueryBuilder().toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String sortString = uocSearchEsSQLRspBO.getSortQuery().toString();
        queryJson.put("sort", (Object)JSON.parseArray((String)sortString));
        return queryJson.toJSONString();
    }
}

