/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ubc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ubc.components.runnable.SyncUserBehaviorToEsRunnable;
import com.tydic.dyc.ubc.components.thread.UbcThreadPool;
import com.tydic.dyc.ubc.model.common.UbcCommonModel;
import com.tydic.dyc.ubc.model.common.UbcUserBehaviorInfoDo;
import com.tydic.dyc.ubc.model.common.UbcUserOperateInfoDo;
import com.tydic.dyc.ubc.service.common.UbcUserOperateSaveService;
import com.tydic.dyc.ubc.service.common.bo.UbcUserOperateSaveServiceReqBo;
import com.tydic.dyc.ubc.service.common.bo.UbcUserOperateSaveServiceReqKeyDataBo;
import com.tydic.dyc.ubc.service.common.bo.UbcUserOperateSaveServiceReqOperateBo;
import com.tydic.dyc.ubc.service.common.bo.UbcUserOperateSaveServiceRspBo;
import com.tydic.dyc.ubc.utils.UbcRu;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.ubc.service.common.UbcUserOperateSaveService"})
public class UbcUserOperateSaveServiceImpl
implements UbcUserOperateSaveService {
    @Autowired
    private UbcCommonModel ubcCommonModel;
    @Autowired
    private UbcThreadPool ubcThreadPool;

    @PostMapping(value={"saveUserOperate"})
    public UbcUserOperateSaveServiceRspBo saveUserOperate(@RequestBody UbcUserOperateSaveServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UbcUserBehaviorInfoDo behaviorInfoDo = (UbcUserBehaviorInfoDo)JUtil.js((Object)reqBo, UbcUserBehaviorInfoDo.class);
        this.fillOperateData(behaviorInfoDo, reqBo);
        UbcUserBehaviorInfoDo ubcUserBehaviorInfoDo = this.ubcCommonModel.saveBehaviorInfo(behaviorInfoDo);
        this.ubcThreadPool.executeRunnable(new SyncUserBehaviorToEsRunnable(ubcUserBehaviorInfoDo.getBehaviorId()));
        UbcUserOperateSaveServiceRspBo rspBo = UbcRu.success(UbcUserOperateSaveServiceRspBo.class);
        BeanUtils.copyProperties((Object)ubcUserBehaviorInfoDo, (Object)rspBo);
        return rspBo;
    }

    private void fillOperateData(UbcUserBehaviorInfoDo behaviorInfoDo, UbcUserOperateSaveServiceReqBo reqBo) {
        HashMap operateCodeMap = new HashMap();
        for (UbcUserOperateSaveServiceReqOperateBo operateBo : reqBo.getOperateInfoList()) {
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            for (UbcUserOperateSaveServiceReqKeyDataBo keyDataBo : operateBo.getKeyDataList()) {
                tmpMap.put(keyDataBo.getKey(), keyDataBo.getValue());
            }
            operateCodeMap.put(operateBo.getOperateCode(), tmpMap);
        }
        for (UbcUserOperateInfoDo operateInfoDo : behaviorInfoDo.getOperateInfoList()) {
            operateInfoDo.setUserOperateData(JSON.toJSONString(operateCodeMap.get(operateInfoDo.getOperateCode())));
        }
    }

    private void validateArg(UbcUserOperateSaveServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getBusiCode())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[busiCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getBehaviorCode())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[BehaviorCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserName())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[UserName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getLocationCode())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[LocationCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOperateTime())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[OperateTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getLoginDevice())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[LoginDevice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOperateInfoList())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[OperateInfoList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.validateOperateInfo(reqBo.getOperateInfoList());
    }

    private void validateOperateInfo(List<UbcUserOperateSaveServiceReqOperateBo> operateInfoList) {
        for (UbcUserOperateSaveServiceReqOperateBo reqBo : operateInfoList) {
            if (ObjectUtil.isEmpty((Object)reqBo)) {
                throw new BaseBusinessException("200001", "\u7528\u6237\u64cd\u4f5c\u884c\u4e3a\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getOperateCode())) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[OperateCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getOperateTime())) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isNotEmpty((Object)reqBo.getSnapId()) && ObjectUtil.isEmpty((Object)reqBo.getTmpCode())) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[TmpCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List keyDataList = reqBo.getKeyDataList();
            if (!ObjectUtil.isNotEmpty((Object)keyDataList)) continue;
            for (UbcUserOperateSaveServiceReqKeyDataBo keyDataBo : keyDataList) {
                if (!ObjectUtil.isEmpty((Object)keyDataBo.getKey()) && !ObjectUtil.isEmpty((Object)keyDataBo.getValue())) continue;
                throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027key\uff0cvalue\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

