/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ubc.components.runnable;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ubc.components.UbcProperties;
import com.tydic.dyc.ubc.components.es.UbcElasticsearchUtil;
import com.tydic.dyc.ubc.model.common.UbcUserBehaviorInfoDo;
import com.tydic.dyc.ubc.repository.UbcCommonRepository;
import com.tydic.dyc.ubc.utils.TableUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncUserBehaviorToEsRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SyncUserBehaviorToEsRunnable.class);
    @Autowired
    private UbcElasticsearchUtil ubcElasticsearchUtil;
    @Autowired
    private UbcCommonRepository ubcCommonRepository;
    @Autowired
    private UbcProperties ubcProperties;
    private List<Long> behaviorIdList = new ArrayList<Long>();

    @Override
    public void run() {
        if (ObjectUtil.isNotEmpty(this.behaviorIdList)) {
            for (Long behaviorId : this.behaviorIdList) {
                UbcUserBehaviorInfoDo qryDo = new UbcUserBehaviorInfoDo();
                qryDo.setBehaviorId(behaviorId);
                UbcUserBehaviorInfoDo ubcUserBehaviorInfoDo = this.ubcCommonRepository.qryUserBehaviorInfoDo(qryDo);
                log.debug("\u540c\u6b65\u7528\u6237\u884c\u4e3aes\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)ubcUserBehaviorInfoDo));
                this.ubcElasticsearchUtil.addJsonData(TableUtil.getUerBehaviorTableName(this.ubcProperties.getUserBehaviorInfoPrefix(), behaviorId), behaviorId.toString(), JSON.toJSONString((Object)ubcUserBehaviorInfoDo));
            }
        }
    }

    public SyncUserBehaviorToEsRunnable(Long behaviorId) {
        this.behaviorIdList.add(behaviorId);
    }

    public SyncUserBehaviorToEsRunnable(List<Long> behaviorIdList) {
        this.behaviorIdList = behaviorIdList;
    }

    public SyncUserBehaviorToEsRunnable() {
    }
}

