package com.tydic.dyc.ubc.repository.po;

import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import java.util.Date;

import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 用户操作记录表
 * </p>
 *
 * @author tiangy
 * @since 2023-08-04
 */
@Getter
@Setter
@TableName("ubc_user_operate_info")
public class UbcUserOperateInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 用户操作id
     */
    private Long operateId;

    /**
     * 业务行为id
     */
    private Long behaviorId;

    /**
     * 业务行为操作编码
     */
    private String operateCode;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 操作内容
     */
    private String operateContent;

    /**
     * 操作时间
     */
    private Date operateTime;

    /**
     * 快照业务功能编码,用于定位快照表
     */
    private String tmpCode;

    /**
     * 快照id
     */
    private Long snapId;

    /**
     * 是否业务起点，1是0否，默认0
     */
    private Integer busiStart;

    /**
     * 用户操作数据，存json，方便后期使用
     */
    private String userOperateData;

    /**
     * 接收时间，后端接收到的时间，因为需要异步入库，在接收到数据时组装好这个时间，而不是最终的入库时间
     */
    private Date receiveTime;


    /**
     * 表名
     */
    private String tableName;


}
