/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.util;

import com.tydic.commodity.exception.BusinessException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.util.StringUtils;

public class DateUtils {
    public static String dateToStr(Date date) {
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return DATE_FORMAT.format(date);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static Date strToDate(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return null;
        }
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return DATE_FORMAT.parse(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static Integer compareDate(Date dt1, Date dt2) {
        try {
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            throw new BusinessException("DATE_FORMAT_ERROR", "\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static Date strToDateAsFormat(String str, String format) {
        if (StringUtils.isEmpty((Object)str)) {
            return null;
        }
        if (StringUtils.isEmpty((Object)format)) {
            return null;
        }
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(format);
            return DATE_FORMAT.parse(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static String dateToStrAsFormat(Date date, String format) {
        if (StringUtils.isEmpty((Object)format)) {
            return null;
        }
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(format);
            return DATE_FORMAT.format(date);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }
}

