/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.util;

import com.tydic.commodity.util.DateUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Reflections {
    public static Object invokeGetter(Object obj, String propertyName) {
        String getterMethodName = "get" + StringUtils.capitalize((String)propertyName);
        return Reflections.invokeMethod(obj, getterMethodName, new Class[0], new Object[0]);
    }

    public static List<Object> invokeGetter(Object obj, String[] propertyNames) {
        ArrayList<Object> list = new ArrayList<Object>(propertyNames.length);
        String[] var3 = propertyNames;
        int var4 = propertyNames.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            Object propertyValue;
            String propertyName = var3[var5];
            if (!StringUtils.contains((CharSequence)propertyName, (CharSequence)".")) {
                propertyValue = Reflections.invokeGetter(obj, propertyName);
            } else {
                String[] propertyNamePaths = StringUtils.split((String)propertyName, (String)".");
                Object temp = obj;
                String[] var10 = propertyNamePaths;
                int var11 = propertyNamePaths.length;
                for (int var12 = 0; var12 < var11; ++var12) {
                    String propertyNamePath = var10[var12];
                    if (temp == null) break;
                    temp = Reflections.invokeGetter(temp, propertyNamePath);
                }
                propertyValue = temp;
            }
            list.add(propertyValue);
        }
        return list;
    }

    public static Set<String> getSimpleFieldNames(Class<?> pojoClass) {
        HashSet<String> propertyNames = new HashSet<String>();
        Class<?> clazz = pojoClass;
        do {
            Field[] fields;
            Field[] var4 = fields = clazz.getDeclaredFields();
            int var5 = fields.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                Field field = var4[var6];
                if (Modifier.isStatic(field.getModifiers()) || !field.getType().isPrimitive() && !Reflections.isWrapClass(field.getType()) && !field.getType().isAssignableFrom(Timestamp.class) && !field.getType().isAssignableFrom(Date.class) && !field.getType().isAssignableFrom(String.class) && !field.getType().isAssignableFrom(Calendar.class)) continue;
                propertyNames.add(field.getName());
            }
        } while ((clazz = clazz.getSuperclass()) != null && !clazz.getSimpleName().equalsIgnoreCase("Object"));
        return propertyNames;
    }

    public static boolean isWrapClass(Class clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception var2) {
            return false;
        }
    }

    public static List<String> invokeGetterToString(Object obj, String[] propertyNames) {
        List<Object> list = Reflections.invokeGetter(obj, propertyNames);
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (Object object : list) {
            if (object == null) {
                result.add(null);
                continue;
            }
            if (object instanceof Date) {
                result.add(DateUtils.dateToStr((Date)object));
                continue;
            }
            if (object instanceof Calendar) {
                result.add(DateUtils.dateToStr(((Calendar)object).getTime()));
                continue;
            }
            result.add(object.toString());
        }
        return result;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Method method = Reflections.getAccessibleMethod(obj, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception var6) {
            throw Reflections.convertReflectionExceptionToUnchecked(var6);
        }
    }

    public static Method getAccessibleMethod(Object obj, String methodName, Class ... parameterTypes) {
        Validate.notNull((Object)obj, (String)"object can't be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(methodName, parameterTypes);
                Reflections.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException var5) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethodByName(Object obj, String methodName) {
        Validate.notNull((Object)obj, (String)"object can't be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            Method[] var4 = methods = searchType.getDeclaredMethods();
            int var5 = methods.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                Method method = var4[var6];
                if (!method.getName().equals(methodName)) continue;
                Reflections.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        return !(e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) ? (e instanceof InvocationTargetException ? new RuntimeException(((InvocationTargetException)e).getTargetException()) : (e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException("Unexpected Checked Exception.", e))) : new IllegalArgumentException(e);
    }
}

